import sys
import convertible
import inspect
import logger
import logging
import traceback

log = logger.get_logger('app')


def call(func, kwargs):
    argspec = inspect.getargspec(func)
    params = kwargs
    if not argspec.keywords:
        params = dict()
        for key in kwargs.keys():
            if key in argspec.args:
                params[key] = kwargs.get(key)
    return func(**params)


def respond(result, message=None, success=True):
    convertible.pretty_print()
    response = dict(success=success, message=message, data=result)
    response_json = convertible.to_json(response)
    convertible.ugly_print()
    print(response_json)


def run(runner, debug=False, text=False, exit_code_on_error=1):
    try:
        data = runner()
        if text:
            print(data)
        else:
            respond(data)
    except Exception, e:
        all_info_lines = traceback.format_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)
        all_info_text = ''.join(all_info_lines)
        exc_info_lines = traceback.format_exception_only(sys.exc_type, sys.exc_value)
        exc_info_text = ''.join(exc_info_lines)
        respond(all_info_text, exc_info_text, success=False)
        exit(exit_code_on_error)


def execute(obj, args, exit_code_on_error=1):
    method = getattr(obj, args.action)
    text = False
    if hasattr(args, 'text'):
        text = args.text
    run(lambda: call(method, vars(args)), args.debug, text, exit_code_on_error)

def init_log(name, args):
    if args.debug:
        logger.console = True
        logger.level = logging.DEBUG
    logger.init('/tmp/{}.log'.format(name))
