import sys
import convertible
import inspect
import traceback


def call(func, kwargs):
    argspec = inspect.getargspec(func)
    params = kwargs
    if not argspec.keywords:
        params = dict()
        for key in kwargs.keys():
            if key in argspec.args:
                params[key] = kwargs.get(key)
    return func(**params)


def respond(result, message=None, success=True):
    convertible.pretty_print()
    response = dict(success=success, message=message, data=result)
    response_json = convertible.to_json(response)
    convertible.ugly_print()
    print(response_json)


def run(runner, debug=False, text=False):
    try:
        data = runner()
        if text:
            print(data)
        else:
            respond(data)
    except Exception, e:
        if debug:
            print '-'*60
            traceback.print_exc(file=sys.stdout)
            print '-'*60

        respond(e, str(e), success=False)
        exit(1)


def execute(obj, args):
    method = getattr(obj, args.action)
    run(lambda: call(method, vars(args)), args.debug, args.text)
