from setuptools import setup
from setuptools.command.install_scripts import install_scripts
from subprocess import check_output
from os.path import join, dirname

class PostInstall(install_scripts):
    def run(self):
        install_scripts.run(self)
        print "installing Avahi"
        print check_output("install-avahi")

version = open(join(dirname(__file__), 'version')).read().strip()

setup(
    name='syncloud-discovery',
    version=version,
    scripts=['bin/install-avahi', 'bin/syncloud-discovery-pre-remove'],
    description='Discovery for syncloud devices',
    license='GPLv3',
    author='Syncloud',
    author_email='syncloud@googlegroups.com',
    url='https://github.com/syncloud/discovery',
    cmdclass={"install_scripts": PostInstall}
)
