from systemd import SystemD
from gitbucket import config

SERVICE_NAME = 'gitbucket'
PROTOCOL = 'http'
SERVICE_TYPE = '_gitbucket._http._tcp'
PORT = 81
URL = None

class GitbucketControl:
    def __init__(self, insider):
        self.systemd = SystemD()
        self.insider = insider

    def enable(self):
        gb_config = config.read_config()
        gb_config.port = PORT
        config.write_config(gb_config)
        self.systemd.enable()
        self.systemd.start()
        self.insider.add_service(SERVICE_NAME, PROTOCOL, SERVICE_TYPE, PORT, URL)

    def disable(self):
        self.insider.remove_service(SERVICE_NAME)
        self.systemd.disable()
        self.systemd.remove_service()

    def status(self):
        return self.systemd.is_active()