from systemd import SystemD
from gitbucket import config

SERVICE_NAME = 'gitbucket'
PROTOCOL = 'http'
SERVICE_TYPE = '_gitbucket._http._tcp'
PORT = 81
URL = None

class GitbucketControl:
    def __init__(self, insider):
        self.systemd = SystemD()
        self.insider = insider

    def enable(self):
        gb_config = config.read_config()
        gb_config.port = PORT
        config.write_config(gb_config)
        self.systemd.enable()
        self.systemd.start()
        self.insider.add_service(SERVICE_NAME, PROTOCOL, SERVICE_TYPE, PORT, URL)

    def disable(self):
        self.insider.remove_service(SERVICE_NAME)
        self.systemd.stop()
        self.systemd.disable()

    def _get_url(self, info):
        url = '{0}://{1}:{2}'.format(info.service.protocol, info.external_host, info.external_port)
        if info.service.url:
            url += '/'+info.service.url
        return url

    def url(self):
        self.systemd.check_active()
        info = self.insider.service_info(SERVICE_NAME)
        return self._get_url(info)