import subprocess

class SystemD:
    def _execute(self, command, raise_on_bad_exit_code=True):
        if raise_on_bad_exit_code:
            args = ['systemctl', command, 'gitbucket.service']
            return subprocess.check_output(args)
        else:
            p = subprocess.Popen(['ls', '-a'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            out, err = p.communicate()
            return out

    def enable(self):
        self._execute('enable')

    def disable(self):
        self._execute('disable')

    def start(self):
        self._execute('start')

    def stop(self):
        self._execute('stop')

    def check_active(self):
        try:
            status_text = self._execute('status', raise_on_bad_exit_code=True)
            if 'Active: active' not in status_text:
                raise(Exception('GitBucket service is not active'))
        except:
            raise(Exception('GitBucket service is not active'))