from systemd import SystemD
from gitbucket import config
from gitbucket_web import GitBucket

SERVICE_NAME = 'gitbucket'
PROTOCOL = 'http'
SERVICE_TYPE = '_gitbucket._http._tcp'
PORT = 81
URL = None

USER_URL = 'http://syncloud.it'
DEFAULT_LOGIN = 'root'
DEFAULT_PASSWORD = 'root'

class GitbucketControl:
    def __init__(self, insider):
        self.systemd = SystemD('gitbucket.service')
        self.insider = insider

    def enable(self, login, password):
        gb_config = config.read_config()
        gb_config.port = PORT
        config.write_config(gb_config)
        self.systemd.enable()
        self.systemd.start()

        gb = GitBucket('http://localhost:{}'.format(PORT), USER_URL)
        gb.wait(timeout=60, check_period=5)
        if login == DEFAULT_LOGIN:
            gb.change_password(DEFAULT_LOGIN, DEFAULT_PASSWORD, password)
        else:
            gb.create_account(login, password, isAdmin=True)
            gb.disable_account(login, password, user_name_to_disable=DEFAULT_LOGIN)

        self.insider.add_service(SERVICE_NAME, PROTOCOL, SERVICE_TYPE, PORT, URL)

    def disable(self):
        self.insider.remove_service(SERVICE_NAME)
        self.systemd.stop()
        self.systemd.disable()

    def _get_url(self, info):
        url = '{0}://{1}:{2}'.format(info.service.protocol, info.external_host, info.external_port)
        if info.service.url:
            url += '/'+info.service.url
        return url

    def url(self):
        self.systemd.check_active()
        info = self.insider.service_info(SERVICE_NAME)
        return self._get_url(info)