from setuptools import setup
from os.path import join, dirname

requirements = [
    'syncloud-app',
    'syncloud-insider'
]

version = open(join(dirname(__file__), 'version')).read().strip()

setup(
    name='syncloud-gitbucket-ctl',
    version=version,
    scripts=['bin/gitbucket-ctl'],
    description='GitBucket control command line tool',
    packages=['syncloud', 'syncloud.gitbucketctl'],
    namespace_packages=['syncloud'],
    data_files=[
        ('/lib/systemd/system', ['config/gitbucket.service'])
    ],
    license='GPLv3',
    author='Syncloud',
    author_email='syncloud@googlegroups.com',
    url='https://github.com/syncloud/gitbucket-ctl'
)
