from setuptools import setup
from setuptools.command.install_scripts import install_scripts
from subprocess import check_output
from os.path import join, dirname

requirements = [
    'syncloud-app',
    'syncloud-insider'
]

class PostInstall(install_scripts):
    def run(self):
        install_scripts.run(self)
        print "installing GitBucket"
        print check_output("install-gitbucket")

version = open(join(dirname(__file__), 'version')).read().strip()

setup(
    name='syncloud-gitbucket',
    version=version,
    scripts=['bin/install-gitbucket', 'bin/gitbucket', 'bin/gitbucket-ctl'],
    description='GitBucket',
    packages=['syncloud', 'syncloud.gitbucket', 'syncloud.gitbucketctl'],
    namespace_packages=['syncloud'],
    data_files=[
        ('gitbucket/config', ['config/gitbucket.cfg']),
        ('/lib/systemd/system', ['config/gitbucket.service'])
    ],
    license='GPLv3',
    author='Syncloud',
    author_email='syncloud@googlegroups.com',
    url='https://github.com/syncloud/gitbucket',
    cmdclass={"install_scripts": PostInstall}
)
