import os

from gitbucket import config

default_war_path = '/opt'

def run_gitbucket(war_path=default_war_path, config_path=config.default_config_path):
    c = config.read_config(config_path)
    args = ['java', '-jar', os.path.join(war_path, 'gitbucket.war')]
    if c.port:
        args.append('--port={}'.format(c.port))
    if c.data_path:
        args.append('--gitbucket.home={}'.format(c.data_path))
    cmd = ' '.join(args)
    print(cmd)
    os.system(cmd)