from urlparse import urljoin
import requests
import time


class GitBucket:
    def __init__(self, server_url, user_url):
        self.server_url = server_url
        self.user_url = user_url

    def url(self, path):
        return urljoin(self.server_url, path)

    def sign_in(self, session, user_name, password):
        session.post(self.url('signin'), data={'userName': user_name, 'password': password})

    def change_password(self, user_name, current_password, new_password):
        s = requests.Session()
        self.sign_in(s, user_name, current_password)
        change_password_data = {
            'password': new_password,
            'fullName': 'root',
            'mailAddress': 'root@localhost',
            'url': self.user_url
        }
        s.post(self.url('root/_edit'), data=change_password_data)

    def disable_account(self, user_name, password, user_name_to_disable):
        s = requests.Session()
        self.sign_in(s, user_name, password)
        disable_account_data = {
            'userName': user_name_to_disable,
            'removed': 'true',
            'password': 'dummy',
            'fullName': 'dummy',
            'mailAddress': 'dummy@localhost',
            'url': self.user_url
        }
        s.post(self.url('admin/users/{}/_edituser'.format(user_name_to_disable)), data=disable_account_data)

    def create_account(self, user_name, password, new_user_name, new_password, isAdmin=True):
        s = requests.Session()
        self.sign_in(s, user_name, password)
        new_user_data = {
            'userName': new_user_name,
            'password': new_password,
            'fullName': new_user_name,
            'mailAddress': new_user_name+'@localhost',
            'isAdmin': str(isAdmin).lower()
        }
        s.post(self.url('admin/users/_newuser'), data=new_user_data)

    def delete_account(self, user_name, password):
        s = requests.Session()
        self.sign_in(s, user_name, password)
        s.get(self.url('{}/_delete'.format(user_name)))

    def wait(self, timeout, check_period):
        start = time.time()
        while (time.time() - start) <= timeout:
            try:
                response = requests.get(self.server_url)
                if response.status_code == 200:
                    return
            except:
                pass
            time.sleep(check_period)
        raise Exception('Timeout while waiting for GitBucket')

if __name__=='__main__':
    c = GitBucket()
    # c.change_password('root', 'root3', 'root4')
    # c.create_account('root', 'root4', 'test3', 'test3', isAdmin=True)
    c.disable_account('test3', 'test3', user_name_to_disable='root')
