from time import sleep


#TODO: Think about splitting the file by hdd/time
class Boot:

    def __init__(self, system, disks, data_dir, max_retries, user):
        self.user = user
        self.max_retries = max_retries
        self.data_dir = data_dir
        self.disks = disks
        self.system = system

    def mount_data(self):
        retry = 0
        while retry < self.max_retries:
            partition = self.__select_partition()
            if partition:
                self.system.mount_disk(partition, self.data_dir)
                self.system.fix_permissions(self.data_dir, self.user)
                return
            retry += 1
            print "waiting for disk to initialize ({})".format(retry)
            sleep(1)

        print "no disks found, tried: {}".format(self.disks)

    def __select_partition(self):
        for disk in self.disks:
            if self.system.disk_is_ready(disk):
                print "Disk found: {}".format(disk)
                return disk
        return None

    def sync_time(self):
        retry = 0
        while retry < self.max_retries:
            if self.system.network_is_up('eth0'):
                self.system.sync_time()
                return
            retry += 1
            print "waiting for network to come up ({})".format(retry)
            sleep(1)

        print "network is still down"
