from os import listdir
from subprocess import check_output


class System:

    def __init__(self):
        pass

    def disk_is_ready(self, disk):
        return self.run(['blkid', disk])

    def disks_available(self):
        return check_output(['blkid', '-o', 'device']).splitlines()

    def mount_disk(self, disk, directory):
        return self.run(['mount', disk, directory])

    def fix_permissions(self, directory, user):
        chmod = ['chmod', '770', directory]
        chown = ['chown', '-R', '{}:{}'.format(user, user), directory]
        return self.run(chmod) and self.run(chown)

    def network_is_up(self, name):
        with open("/sys/class/net/{}/operstate".format(name), 'r') as f:
            status = f.read().strip()
            print "{}: {}".format(name, status)
            return status == 'up'

    def networks_available(self):
        return listdir("/sys/class/net")

    def sync_time(self):
        return self.run(['ntpdate', '-u', 'pool.ntp.org'])

    def run(self, *args):
        try:
            print("running: '{}'".format(self.srepr(*args)))
            print check_output(*args)
            return True
        except Exception as e:
            print e.message
            return False

    def srepr(self, list):
        if isinstance(list, basestring):
            return list
        return " ".join(list)