from setuptools import setup
from setuptools.command.install_scripts import install_scripts
from subprocess import check_output


class PostInstall(install_scripts):
    def run(self):
        install_scripts.run(self)
        print "running syncloud boot image tweaks"
        print check_output("syncloud-boot-installer")

setup(
    name='syncloud-image-boot',
    version='0.24-utf8',
    scripts=['bin/syncloud-boot.sh', 'bin/syncloud-sync-time.py', 'bin/syncloud-boot-installer'],
    description='Syncloud boot image tweaks',
    packages=['syncloud', 'syncloud.boot'],
    namespace_packages=['syncloud'],
    data_files=[
        ('/etc/sudoers.d', ['config/www-data']),
        ('syncloud-image-boot/config', ['config/udisks-glue.conf'])
    ],
    long_description='Syncloud boot image tweaks',
    license='GPLv3',
    author='Syncloud',
    author_email='syncloud@googlegroups.com',
    url='https://github.com/syncloud/image-boot',
    cmdclass={"install_scripts": PostInstall}
)
