import unittest
from mock import MagicMock
from syncloud.boot.boot import Boot


class TestBoot(unittest.TestCase):

    def test_data_mount_disk_available_with_no_retries(self):
        system = MagicMock()
        system.disk_available = MagicMock(return_value=True)

        boot = Boot(system, ['/dev/sda1', '/dev/sdb1'], '/data', 2, 'user')
        boot.mount_data()

        system.mount_disk.assert_called_once_with('/dev/sda1', '/data')
        system.fix_permissions.assert_called_once_with('/data', 'user')

    def test_data_mount_disk_is_ready_with_retries(self):
        system = MagicMock()
        system.disk_is_ready = MagicMock(side_effect=[False, True])

        boot = Boot(system, ['/dev/sda1', '/dev/sdb1'], '/data', 3, 'user')
        boot.mount_data()

        system.mount_disk.assert_called_once_with('/dev/sdb1', '/data')
        system.fix_permissions.assert_called_once_with('/data', 'user')

    def test_data_mount_disk_not_available(self):
        system = MagicMock()
        system.disk_is_ready = MagicMock(return_value=False)

        boot = Boot(system, ['/dev/sda1', '/dev/sdb1'], '/data', 3, 'user')
        boot.mount_data()

        self.assertFalse(system.mount_disk.called)
        self.assertFalse(system.fix_permissions.called)

    def test_time_sync_network_available_with_no_retries(self):
        system = MagicMock()
        system.network_is_up = MagicMock(return_value=True)

        boot = Boot(system, None, None, 2, None)
        boot.sync_time()

        self.assertEquals(system.sync_time.called, 1)

    def test_time_sync_network_available_with_retries(self):
        system = MagicMock()
        system.network_is_up = MagicMock(side_effect=[False, True])

        boot = Boot(system, None, None, 3, None)
        boot.sync_time()

        self.assertEquals(system.sync_time.called, 1)

    def test_time_sync_network_not_available(self):
        system = MagicMock()
        system.network_is_up = MagicMock(return_value=False)

        boot = Boot(system, None, None, 3, None)
        boot.sync_time()

        self.assertFalse(system.sync_time.called)