import unittest
from mock import MagicMock
from syncloud.boot.boot import Boot
from syncloud.boot.system import System


class TestSystem(unittest.TestCase):

    def test_run_ok(self):
        system = System()
        self.assertTrue(system.run('date'))

    def test_run_ok_with_args(self):
        system = System()
        self.assertTrue(system.run(['date', '-u']))

    def test_run_fail(self):
        system = System()
        self.assertFalse(system.run('dateeee'), "test")

    #  blkid is not working on Travis

    #  def test_disk_is_ready(self):
    #     system = System()
    #     available = system.disks_available()
    #     print(available)
    #     disks_ready = [disk for disk in available if system.disk_is_ready(disk)]
    #     self.assertGreater(len(disks_ready), 0)
    #
    # def test_disk_is_not_ready(self):
    #     system = System()
    #     self.assertFalse(system.disk_is_ready('/dev/123'))

    def test_network_status(self):
        system = System()
        available = system.networks_available()
        print(available)
        networks_up = [net for net in available if system.network_is_up(net)]
        self.assertGreaterEqual(len(networks_up), 0)

    def test_unknown_network_status(self):
        self.assertFalse((System()).network_is_up('_unknown_'))

    def test_no_networks_available(self):
        self.assertListEqual((System('/sys/class/no_net')).networks_available(), [])