#!/usr/bin/env python

import commands
import sys


def get_partitions():
    return [p.split(':')[0] for p in (commands.getoutput('blkid')).split('\n')]


def select_partition(partitions, need_partitions):
    for p in need_partitions:
        if p in partitions:
            return p
    return None
    
if __name__ == '__main__':
    data_dir = sys.argv[1]
    print data_dir
    partitions = get_partitions()
    partition = select_partition(partitions, ['/dev/sda1', '/dev/sdb1'])
    if partition:
        mount_output = commands.getoutput('mount {} {}'.format(partition, data_dir))
        print mount_output
