from setuptools import setup
from setuptools.command.install_scripts import install_scripts
from subprocess import check_output


class PostInstall(install_scripts):
    def run(self):
        install_scripts.run(self)
        print "running syncloud boot image tweaks"
        print check_output("syncloud-boot-installer")

setup(
    name='syncloud-image-boot',
    version='0.55',
    scripts=['bin/syncloud-link-data.sh', 'bin/syncloud-boot-installer'],
    description='Syncloud boot image tweaks',
    packages=['syncloud', 'syncloud.boot'],
    namespace_packages=['syncloud'],
    data_files=[
        ('syncloud-image-boot/config', ['config/udisks/udisks-glue.conf']),
        ('/etc/sudoers.d', ['config/sudoers.d/www-data']),
        ('/etc/polkit-1/localauthority/50-local.d', ['config/polkit/55-storage.pkla']),
        ('/etc/udev/rules.d', ['config/udev/99-syncloud.udisks.rules']),
        ('/lib/systemd/system', ['config/systemd/ntpdate.service']),
        ('/lib/systemd/system', ['config/systemd/udisks-glue.service'])
    ],
    long_description='Syncloud boot image tweaks',
    license='GPLv3',
    author='Syncloud',
    author_email='syncloud@googlegroups.com',
    url='https://github.com/syncloud/image-boot',
    cmdclass={"install_scripts": PostInstall}
)
