from subprocess import check_output, CalledProcessError


class System:

    def __init__(self):
        pass

    def disk_available(self, disk):
        try:
            print check_output(['blkid', disk])
            return True
        except CalledProcessError as e:
            print e.message
            return False

    def mount_disk(self, disk, directory):
        try:
            print check_output(['mount', disk, directory])
            return True
        except CalledProcessError as e:
            print e.message
            return False

    def fix_permissions(self, directory, user):
        try:
            print check_output(['chmod', '770', directory])
            print check_output(['chown', '-R', '{}:{}'.format(user, user), directory])
            return True
        except CalledProcessError as e:
            print e.message
            return False

    def network_is_up(self):
        with open("/sys/class/net/eth0/operstate", 'r') as f:
            return f.read() == 'up'

    def sync_time(self):
        try:
            print check_output(['ntpdate', '-u', 'pool.ntp.org'])
            return True
        except CalledProcessError as e:
            print e.message
            return False