from subprocess import check_output


class System:

    def __init__(self):
        pass

    def disk_available(self, disk):
        return self.run('blkid {}'.format(disk))

    def mount_disk(self, disk, directory):
        return self.run('mount {} {}'.format(disk, directory))

    def fix_permissions(self, directory, user):
        chmod = 'chmod  770 {}'.format(directory)
        chown = 'chown -R {}:{} {}'.format(user, user, directory)
        return self.run(chmod) and self.run(chown)

    def network_is_up(self):
        with open("/sys/class/net/eth0/operstate", 'r') as f:
            return f.read() == 'up'

    def sync_time(self):
        return self.run('ntpdate -u pool.ntp.org')

    def run(self, command):
        try:
            print check_output(command.split(' '))
            return True
        except Exception as e:
            print e.message
            return False