import unittest
from mock import MagicMock
from syncloud.boot.boot import Boot
from syncloud.boot.system import System


class TestSystem(unittest.TestCase):

    def test_run_ok(self):
        system = System()
        self.assertTrue(system.run('date'))

    def test_run_ok_with_args(self):
        system = System()
        self.assertTrue(system.run('date -u'))

    def test_run_fail(self):
        system = System()
        self.assertFalse(system.run('dateeee'))

    def test_disk_available(self):
        system = System()
        self.assertFalse(system.disk_available('/dev/123'))