import footprint
import uuid
import config

def getname(footprint):
    for name, f in config.footprints.iteritems():
        if f == footprint:
            return name
    return None

def getmac():
    mac = uuid.getnode()
    mac_formated = ':'.join(("%012x" % mac)[i:i+2] for i in range(0, 12, 2))
    return mac_formated

def name():
    f = footprint.footprint()
    return getname(f)

def id():
    f = footprint.footprint()
    name = getname(f)
    if not name:
        raise Exception('Unknown footprint: {}'.format(f))
    mac_address = getmac()

    title = config.titles[name]
    id = {
        'name': name,
        'title': title,
        'mac_address': mac_address
    }
    return id