import logging
import logging.handlers

console = False
log_filename = '/tmp/syncloud-image-tools.log'
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')

fileHandler = logging.handlers.RotatingFileHandler(log_filename, maxBytes=1000000, backupCount=5)
fileHandler.setFormatter(formatter)

consoleHandler = logging.StreamHandler()
consoleHandler.setFormatter(formatter)

level = logging.INFO


def get_logger(name):
    logger = logging.getLogger(name)
    logger.setLevel(level)
    logger.addHandler(fileHandler)
    if console:
        logger.addHandler(consoleHandler)
    return logger
