from syncloud.tools.footprint import Footprint


def test_equals_all_members():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234)
    f2 = Footprint('os-name', cpu_count=1, mem_size=1234)
    assert f1 == f2


def test_equals_different_node_name():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234)
    f2 = Footprint('os-name2', cpu_count=1, mem_size=1234)
    assert f1 != f2


def test_equals_no_cpu_count():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234)
    f2 = Footprint('os-name', mem_size=1234)
    assert f1 == f2


def test_equals_different_cpu_count():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234)
    f2 = Footprint('os-name', cpu_count=2, mem_size=1234)
    assert f1 != f2


def test_equals_no_mem_size():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234)
    f2 = Footprint('os-name', cpu_count=1)
    assert f1 != f2


def test_equals_different_mem_size():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234)
    f2 = Footprint('os-name', cpu_count=1, mem_size=5678)
    assert f1 != f2


def test_equals_different_cpu_hardware():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234, cpu_hardware='arm')
    f2 = Footprint('os-name', cpu_count=1, mem_size=1234, cpu_hardware='i386')
    assert f1 != f2


def test_equals_same_cpu_hardware():
    f1 = Footprint('os-name', cpu_count=1, mem_size=1234, cpu_hardware='arm')
    f2 = Footprint('os-name', cpu_count=1, mem_size=1234, cpu_hardware='arm')
    assert f1 != f2