import platform
import psutil
from syncloud.tools.cpu.cpuinfo import CpuInfo
from syncloud.tools.cpu.reader import Reader


class Footprint:
    def __init__(self, node_name, cpu_count=None, mem_size=None, cpu_hardware=None):
        self.node_name = node_name
        self.cpu_count = cpu_count
        self.mem_size = mem_size
        self.cpu_hardware = cpu_hardware

    def __eq__(self, other):
        if self.node_name != other.node_name:
            return False
        if self.cpu_count and other.cpu_count and self.cpu_count != other.cpu_count:
            return False
        if self.mem_size and other.mem_size and self.mem_size != other.mem_size:
            return False
        if self.cpu_hardware and other.cpu_hardware and self.cpu_hardware != other.cpu_hardware:
            return False

        return True

    def __str__(self):
        return str(self.__dict__)


def footprint():
    node_name = platform.node()
    cpu_count = psutil.cpu_count()
    mem_size = psutil.virtual_memory().total
    cpu_hardware = CpuInfo(Reader()).hardware()
    return Footprint(node_name, cpu_count, mem_size, cpu_hardware)