import psutil
from syncloud.tools.cpu.cpuinfo import CpuInfo
from syncloud.tools.cpu.reader import Reader


class Footprint:
    def __init__(self, cpu_hardware, cpu_count=None, mem_size=None):
        self.cpu_hardware = cpu_hardware
        self.cpu_count = cpu_count
        self.mem_size = mem_size

    def __eq__(self, other):
        if self.cpu_hardware != other.cpu_hardware:
            return False
        if self.cpu_count and other.cpu_count and self.cpu_count != other.cpu_count:
            return False
        if self.mem_size and other.mem_size and self.mem_size != other.mem_size:
            return False

        return True

    def __str__(self):
        return str(self.__dict__)


def footprint():
    cpu_count = psutil.cpu_count()
    mem_size = psutil.virtual_memory().total
    cpu_hardware = CpuInfo(Reader()).hardware()
    return Footprint(cpu_hardware, cpu_count, mem_size)