from syncloud.tools.footprint import Footprint


def test_equals_all_members():
    f1 = Footprint('arm', cpu_count=1, mem_size=1234)
    f2 = Footprint('arm', cpu_count=1, mem_size=1234)
    assert f1 == f2


def test_equals_no_cpu_count():
    f1 = Footprint('arm', cpu_count=1, mem_size=1234)
    f2 = Footprint('arm', mem_size=1234)
    assert f1 == f2


def test_equals_different_cpu_count():
    f1 = Footprint('arm', cpu_count=1, mem_size=1234)
    f2 = Footprint('arm', cpu_count=2, mem_size=1234)
    assert f1 != f2


def test_equals_no_mem_size():
    f1 = Footprint('arm', cpu_count=1, mem_size=1234)
    f2 = Footprint('arm', cpu_count=1)
    assert f1 != f2


def test_equals_different_mem_size():
    f1 = Footprint('arm', cpu_count=1, mem_size=1234)
    f2 = Footprint('arm', cpu_count=1, mem_size=5678)
    assert f1 != f2


def test_equals_different_cpu_hardware():
    f1 = Footprint('arm', cpu_count=1, mem_size=1234)
    f2 = Footprint('i386', cpu_count=1, mem_size=1234)
    assert f1 != f2


def test_equals_same_cpu_hardware():
    f1 = Footprint('arm', cpu_count=1, mem_size=1234)
    f2 = Footprint('arm', cpu_count=1, mem_size=1234)
    assert f1 == f2