from ConfigParser import ConfigParser

import os

import config
import upnpc
import port_mapper
import dns
import cron


class Insider:

    def __init__(self, port_mapper, dns, cron):
        self.port_mapper = port_mapper
        self.dns = dns
        self.cron = cron

    def list_ports(self):
        return self.port_mapper.list()

    def sync_all(self):
        return self.dns.sync()

    def add_service(self, name, protocol, type, port, url):
        return self.dns.add_service(name, protocol, type, port, url)

    def remove_service(self, name):
        return self.dns.remove_service(name)

    def get_service(self, name):
        return self.dns.get_service(name)

    def get_mapping(self, port):
        return self.port_mapper.get(port)

    def service_urls(self, name):
        return self.dns.service_urls(name)

    def acquire_domain(self, email, password, user_domain):
        return self.dns.acquire(email, password, user_domain)

    def full_name(self):
        return self.dns.full_name()

    def cron_on(self):
        return self.cron.on()

    def cron_off(self):
        return self.cron.off()


def get_insider(bin_path, config_path, logs_path):
    script_path = os.path.join(bin_path, 'insidercli')
    insider_config_path = os.path.join(config_path, 'insider.cfg')
    cron_log_path = os.path.join(logs_path, 'insider-cron.log')

    parser = ConfigParser()
    parser.read(insider_config_path)

    store_path = parser.get('insider', 'store_path')
    redirect_api_url = parser.get('redirect', 'api_url')
    redirect_main_domain = parser.get('redirect', 'domain')
    cron_period_mins = parser.getint('cron', 'period_mins')

    domain_config_path = os.path.join(store_path, 'domain.json')
    services_config_path = os.path.join(store_path, 'services.json')
    port_config_path = os.path.join(store_path, 'ports.json')

    port_config = config.PortConfig(port_config_path)
    upnpclient = upnpc.Upnpc()
    mapper = port_mapper.PortMapper(port_config, upnpclient)
    domain_config = config.DomainConfig(domain_config_path)
    service_config = config.ServiceConfig(services_config_path)
    dns_service = dns.Dns(redirect_api_url, redirect_main_domain, domain_config, service_config, mapper)

    cron_service = cron.Cron(script_path, cron_log_path, cron_period_mins)

    return Insider(mapper, dns_service, cron_service)

def get_deployed_insider():
    return get_insider('/usr/local/bin', '/usr/local/config', '/var/log')