import unittest
from subprocess import check_output, call
from os.path import dirname, join

test_dir = dirname(__file__)
root_dir = join(dirname(__file__), '..')
cmd = '{}/bin/insider --config-path={}/test-config/ --debug'.format(root_dir, root_dir)


class TestCli(unittest.TestCase):

    def setUp(self):
        clean_up()
        check_output('mkdir {}/test-config'.format(root_dir), shell=True)
        check_output('cp {}/test_insider.cfg {}/test-config/insider.cfg'.format(test_dir, root_dir), shell=True)

    def test_full_name_not_activated(self):

        self.assertEquals(1, call('{} full_name'.format(cmd), shell=True))

    def test_full_name_activated(self):

        check_output('cp {}/test_domain.json {}/test-config/domain.json'.format(test_dir, root_dir), shell=True)

        self.assertEquals(0, call('{} full_name'.format(cmd), shell=True))

    def test_cron(self):

        output = check_output('{} cron_on'.format(cmd), shell=True)
        self.assertTrue("\"enabled\"" in output)
        output = check_output('{} cron_on'.format(cmd), shell=True)
        self.assertTrue("\"already enabled\"" in output)

        output = check_output('{} cron_off'.format(cmd), shell=True)
        self.assertTrue("\"disabled\"" in output)
        output = check_output('{} cron_off'.format(cmd), shell=True)
        self.assertTrue("\"already disabled\"" in output)

    def tearDown(self):
        clean_up()


def clean_up():
    check_output('rm -rf {}/test-config'.format(root_dir), shell=True)