from insider.config import Port

LOWER_LIMIT = 10000
UPPER_LIMIT = 65535

def find_available_port(existing_ports):
    return next(x for x in range(LOWER_LIMIT, UPPER_LIMIT) if not x in existing_ports)

class PortMapper:

    def __init__(self, port_config, upnpc):
        self.port_config = port_config
        self.upnpc = upnpc

    def add(self, local_port):
        external_port = self.available("TCP")
        mapping = Port(local_port, external_port)
        self.upnpc.add(mapping.local_port, mapping.external_port)
        self.port_config.add(mapping)
        return mapping

    def remove(self, local_port):
        mapping = self.port_config.get(local_port)
        self.upnpc.remove(mapping.external_port)
        self.port_config.remove(local_port)

    def available(self, protocol):
        return find_available_port(self.upnpc.mapped_ports(protocol))

    def get(self, local_port):
        return self.port_config.get(local_port)

    def list(self):
        return self.port_config.load()

    def external_ip(self):
        return self.upnpc.external_ip()

    def sync(self):
        for mapping in self.list():
            external_ports = self.upnpc.get_external_ports("TCP", mapping.local_port)
            if len(external_ports) > 0:
                first_external_port = external_ports.pop()
                for port in external_ports:
                    self.upnpc.remove(port)
                if first_external_port != mapping.external_port:
                    mapping.external_port = first_external_port
                    self.port_config.update_port(mapping)
            else:
                self.add(mapping.local_port)