from ConfigParser import ConfigParser

import os

import config
from insider.config import InsiderConfig
import upnpc
import port_mapper
import dns
import cron


class Insider:

    def __init__(self, port_mapper, dns, cron, insider_config):
        self.insider_config = insider_config
        self.port_mapper = port_mapper
        self.dns = dns
        self.cron = cron

    def list_ports(self):
        return self.port_mapper.list()

    def sync_all(self):
        return self.dns.sync()

    def add_service(self, name, protocol, type, port, url):
        return self.dns.add_service(name, protocol, type, port, url)

    def remove_service(self, name):
        return self.dns.remove_service(name)

    def get_service(self, name):
        return self.dns.get_service(name)

    def get_mapping(self, port):
        return self.port_mapper.get(port)

    def service_urls(self, name):
        return self.dns.service_urls(name)

    def acquire_domain(self, email, password, user_domain):
        return self.dns.acquire(email, password, user_domain)

    def drop_domain(self):
        self.dns.drop()
        self.cron.off()

    def full_name(self):
        return self.dns.full_name()

    def cron_on(self):
        return self.cron.on()

    def cron_off(self):
        return self.cron.off()

    def set_redirect_info(self, domain, api_url):
        return self.insider_config.update(domain, api_url)

def get_insider(bin_path, config_path, logs_path):

    script_path = os.path.join(bin_path, 'insidercli')
    insider_config_path = os.path.join(config_path, 'insider.cfg')
    cron_log_path = os.path.join(logs_path, 'insider-cron.log')

    insider_config = InsiderConfig(insider_config_path)

    domain_config_path = os.path.join(config_path, 'domain.json')
    services_config_path = os.path.join(config_path, 'services.json')
    port_config_path = os.path.join(config_path, 'ports.json')

    port_config = config.PortConfig(port_config_path)
    upnpclient = upnpc.Upnpc()
    mapper = port_mapper.PortMapper(port_config, upnpclient)
    domain_config = config.DomainConfig(domain_config_path)
    service_config = config.ServiceConfig(services_config_path)

    dns_service = dns.Dns(
        insider_config.get_redirect_api_url(),
        insider_config.get_redirect_main_domain(),
        domain_config,
        service_config,
        mapper)

    cron_service = cron.Cron(script_path, cron_log_path, insider_config.get_cron_period_mins())

    return Insider(mapper, dns_service, cron_service, insider_config)