from ConfigParser import ConfigParser
import convertible
import os.path


class Domain:

    def __init__(self, user_domain, token):
        self.token = token
        self.user_domain = user_domain


class Port:

    def __init__(self, local_port, external_port):
        self.local_port = local_port
        self.external_port = external_port


class Service:

    def __init__(self, name, protocol, type, port, url):
        self.name = name
        self.protocol = protocol
        self.type = type
        self.port = port
        self.url = url


class PortConfig:

    def __init__(self, filename):
        self.filename = filename

    def load(self):
        items = convertible.read_json(self.filename)
        if not items:
            return []
        return items

    def save(self, items):
        convertible.write_json(self.filename, items)

    def add(self, mapping):
        mappings_list = self.load()
        mappings_list.append(mapping)
        self.save(mappings_list)

    def remove(self, local_port):
        mappings_list = self.load()
        new_mappings = [m for m in mappings_list if m.local_port != local_port]
        self.save(new_mappings)

    def get(self, local_port):
        mappings_list = self.load()
        mapping = next((m for m in mappings_list if m.local_port == local_port), None)
        return mapping

    def update(self, new_mapping):
        mappings_list = self.load()
        mapping = next((m for m in mappings_list if m.local_port == new_mapping.local_port), None)
        loc = mappings_list.index(mapping)
        mappings_list[loc] = new_mapping
        self.save(mappings_list)


class DomainConfig:

    def __init__(self, filename):
        self.filename = filename

    def load(self):
        if not os.path.isfile(self.filename):
            raise Exception('{} does not exist'.format(self.filename))
        obj = convertible.read_json(self.filename)
        return obj

    def save(self, obj):
        convertible.write_json(self.filename, obj)

    def remove(self):
        if os.path.isfile(self.filename):
            os.remove(self.filename)


class ServiceConfig:

    def __init__(self, filename):
        self.filename = filename

    def load(self):
        items = convertible.read_json(self.filename)
        if not items:
            return []
        return items

    def save(self, items):
        convertible.write_json(self.filename, items)

    def add(self, item):
        items = self.load()
        items.append(item)
        self.save(items)

    def get(self, name):
        items = self.load()
        item = next((m for m in items if m.name == name), None)
        return item

    def get_by_port(self, local_port):
        items = self.load()
        item = next((m for m in items if m.port == local_port), None)
        return item

    def remove(self, name):
        items = self.load()
        new_items = [i for i in items if i.name != name]
        self.save(new_items)


class InsiderConfig:

    def __init__(self, filename):
        self.parser = ConfigParser()
        self.parser.read(filename)
        self.filename = filename

    def update(self, domain, api_url):
        self.parser.set('redirect', 'domain', domain)
        self.parser.set('redirect', 'api_url', api_url)
        with open(self.filename, 'wb') as file:
            self.parser.write(file)

    def get_redirect_api_url(self):
        return self.parser.get('redirect', 'api_url')

    def get_redirect_main_domain(self):
        return self.parser.get('redirect', 'domain')

    def get_cron_period_mins(self):
        return self.parser.getint('cron', 'period_mins')

