import tempfile

import os
from insider.config import DomainConfig
from insider.port_config import PortConfig
from insider.service_config import ServiceConfig


def temp_file(text=''):
    fd, filename = tempfile.mkstemp()
    f = os.fdopen(fd, 'w')
    f.write(text)
    f.close()
    return filename


def get_port_config(mappings):
    filename = temp_file()
    config = PortConfig(filename)
    config.save(mappings)
    return config


def get_domain_config(domain=None):
    domain_file = temp_file()
    domain_config = DomainConfig(domain_file)
    domain_config.save(domain)
    return domain_config


def get_service_config(services):
    filename = temp_file()
    config = ServiceConfig(filename)
    config.save(services)
    return config
