import logging
import unittest
from mock import MagicMock

from insider.port_mapper import find_available_port
from insider.port_mapper import PortMapper
from insider.config import Port

from helpers import get_port_config

logging.basicConfig(level=logging.DEBUG)


class TestFindAvailablePort(unittest.TestCase):

    def test_first_gap(self):
        ports = [10000, 10001, 10003]
        self.assertEquals(10002, find_available_port(ports))

    def test_no_gap(self):
        ports = [10000, 10001, 10002]
        self.assertEquals(10003, find_available_port(ports))

    def test_no_existing(self):
        ports = []
        self.assertEquals(10000, find_available_port(ports))


class TestPortMapper(unittest.TestCase):

    def test_add_success(self):
        port_config = get_port_config([])
        upnpc = MagicMock()
        mapper = PortMapper(port_config, upnpc)
        mapping = mapper.add(80)

        self.assertIsNotNone(mapping)
        self.assertEquals(80, mapping.local_port)
        self.assertEquals(10000, mapping.external_port)
        self.assertTrue(upnpc.add.called)

        read = port_config.get(80)
        self.assertEquals(10000, read.external_port)

    def test_sync_adds_port(self):
        port_config = get_port_config([Port(80, 10001)])
        upnpc = MagicMock()

        mapper = PortMapper(port_config, upnpc)
        mapper.sync()

        read = port_config.get(80)
        self.assertEquals(10000, read.external_port)

        self.assertTrue(upnpc.add.called)

