from setuptools import setup
from setuptools.command.install_scripts import install_scripts
from subprocess import check_output

requirements = [
    'configobj==4.7.2',
    'requests==2.2.1',
    'urllib3==1.7.1',
    'IPy==0.82a',
    'convertible',
    'syncloud-app'
]


class PostInstall(install_scripts):
    def run(self):
        install_scripts.run(self)
        print "installing insider dependencies"
        print check_output("install-insider")

setup(
    name='syncloud-insider',
    version='0.67',
    scripts=['bin/insider', 'bin/install-insider'],
    packages=['syncloud', 'syncloud.insider'],
    namespace_packages=['syncloud'],
    data_files=[('insider/config', ['config/insider.cfg'])],
    install_requires=requirements,
    description='Port mapper and redirect client tool',
    long_description='Port mapper and redirect client tool',
    license='GPLv3',
    author='Syncloud',
    author_email='syncloud@googlegroups.com',
    url='https://github.com/syncloud/insider')
