import os
from ConfigParser import ConfigParser
from config import Config
from owncloud import setup
from insider.facade import get_deployed_insider
from trusted import Trusted
from access import Access
from https import Https

class OwncloudControl:
    def __init__(self, config, insider, access):
        self.insider = insider
        self.config = config
        self.access = access

    def finish(self, login, password, host):
        owncloud_url = 'http://{}:{}/{}'.format(host, self.config.port_http, self.config.url)
        setup.finish(owncloud_url, login, password)
        self.access.https()

    def https_on(self):
        return self.access.https()

    def https_off(self):
        return self.access.http()

    def url(self):
        urls = self.insider.service_urls(self.config.service_name)
        return urls.full_url


def get_control(config_path, insider):
    config_filename = os.path.join(config_path, 'owncloud-ctl.cfg')

    parser = ConfigParser()
    parser.read(config_filename)

    service_name = parser.get('owncloud', 'service_name')
    port_http = parser.getint('owncloud', 'port_http')
    service_type_http = parser.get('owncloud', 'service_type_http')
    port_https = parser.getint('owncloud', 'port_https')
    service_type_https = parser.get('owncloud', 'service_type_https')
    url = parser.get('owncloud', 'url')
    config_file = parser.get('owncloud', 'config_file')

    config = Config(service_name, port_http, service_type_http, port_https, service_type_https, url, config_file)
    trusted = Trusted(config.config_file)
    https = Https(config)
    access = Access(config, insider, trusted, https)

    return OwncloudControl(config, insider, access)

def get_deployed_control():
    insider = get_deployed_insider()
    control = get_control('/usr/local/config', insider)
    return control
