class Access:
    def __init__(self, config, insider, trusted, https):
        self.config = config
        self.insider = insider
        self.trusted = trusted
        self.https = https

    def set_port(self, protocol, service_type, port):
        self.insider.remove_service(self.config.service_name)
        self.insider.add_service(self.config.service_name, protocol, service_type, port, self.config.url)

    def http(self):
        self.https.off()
        self.set_port('http', self.config.service_type_http, self.config.port_http)
        urls = self.insider.service_urls(self.config.service_name)
        self.trusted.trusted(urls.domain_port)

    def https(self):
        self.https.on()
        self.set_port('https', self.config.service_type_https, self.config.port_https)
        urls = self.insider.service_urls(self.config.service_name)
        self.trusted.trusted(urls.domain_port)
