import re

def convert_trusted_configuration(config, domain_port):
    prog = re.compile(r"'trusted_domains(?:\n|\r\n?|.)*array.*\((?:\n|\r\n?|.)*.*\),", re.MULTILINE)
    m = prog.search(config)
    trusted_conf = m.group(0)
    old_config = config.split(trusted_conf)
    return old_config[0] + "'trusted_domains' => array('{}'),".format(domain_port) + old_config[1]


class Trusted:
    def __init__(self, owncloud_config):
        self.owncloud_config = owncloud_config

    def trusted(self, domain, port):
        domain_port = "{0}:{1}".format(domain, port)
        with open(self.owncloud_config, "r") as f:
            config = f.read()
            new_config = convert_trusted_configuration(config, domain_port)

        if not new_config:
            raise Exception("unable to add {} to ownCloud trusted domain configuration".format(domain_port))

        with open(self.owncloud_config, 'w') as f:
            f.write(new_config)