#!/usr/bin/env python

# I'm still some kind of Python noob so this script is probably shit.
# Still, it does the job for me.

import pybean
import os
import subprocess
import re
import unicodedata
import shutil
import datetime
from hsaudiotag import mp4
from hsaudiotag import auto

__version__ = "0.0.11"
__author__ = "Mickael Desfrenes"
__email__ = "desfrenes@gmail.com"


db_dir = os.path.join(os.getenv('HOME'), '.mcz')

allowed_extensions = [".mp3", ".m4a"]


def safe_filename(unicode_string):
    unicode_string = unicode_string.replace(" ", "_")
    list = [x for x in unicode_string
            if x.isalpha()
            or x.isdigit()
            or x == "_"
            or x == "-"]
    return "".join(list)


def strip_accents(s):
    s = unicode(s)
    return "".join((
        c for c in unicodedata.normalize("NFD", s)
        if unicodedata.category(c) != "Mn"))


def store(frozen = False):
    """
    Return database
    """
    if not os.path.exists(db_dir):
        os.makedirs(db_dir)
    writer = pybean.SQLiteWriter(os.path.join(db_dir, "mcz.sqlite"), frozen)
    return pybean.Store(writer)


def walk(start):
    """
    Walk directories and yields music files paths
    """
    for root, dir, files in os.walk(unicode(start)):
        for name in files:
            file_extension = os.path.splitext(name)[1]
            if file_extension in allowed_extensions:
                path = os.path.join(root, name)
                yield path


def load_metas_from_mp4(filename, metas_instance):
    try:
        tags = mp4.File(filename)
        metas_instance.artist = tags.artist
        metas_instance.title = tags.title
        metas_instance.album = tags.album
        metas_instance.year = tags.year
        metas_instance.genre = tags.genre
        metas_instance.comment = tags.comment
        metas_instance.duration = str(
            datetime.timedelta(seconds=tags.duration))
    except:
        pass


def load_metas_from_mp3(filename, metas_instance):
    try:
        tags = auto.File(filename)
        metas_instance.artist = tags.artist
        metas_instance.title = tags.title
        metas_instance.album = tags.album
        metas_instance.year = tags.year
        metas_instance.genre = tags.genre
        metas_instance.comment = tags.comment
        metas_instance.duration = str(
            datetime.timedelta(seconds=tags.duration))
    except:
        pass


class Analyzer:
    """
    Analyze string and remove stop words
    """
    def __init__(self):
        self.stop_words = [
            "los",
            "las",
            "el",
            "the",
            "of",
            "and",
            "le",
            "de",
            "a",
            "des",
            "une",
            "un",
            "s",
            "is",
            "www",
            "http",
            "com",
            "org"]

    def analyze(self, text):
        words = []
        text = strip_accents(text)
        text = re.compile('[\'`?"]').sub(" ", text)
        text = re.compile('[^A-Za-z0-9]').sub(" ", text)
        for word in text.split(" "):
            word = word.strip()
            if word != "" and not word in self.stop_words:
                if not isinstance(word, unicode):
                    words.append(unicode(word.lower(), "utf-8"))
                else:
                    words.append(word.lower())
        return words


class Metas:
    def __init__(self, filename=None):
        self._set_default(filename)
        if filename:
            self.load_from_file(filename)

    def _set_default(self, filename):
        self.artist = ""
        self.title = ""
        self.album = ""
        self.year = ""
        self.comment = ""
        self.genre = ""
        self.size = os.stat(filename).st_size
        self.duration = "0:00"
        self.path = filename

    def load_from_file(self, filename):
        if filename[-4:].lower() == ".mp3":
            load_metas_from_mp3(filename, self)
        if filename[-4:].lower() == ".m4a":
            load_metas_from_mp4(filename, self)


class Index(object):
    def __init__(self, store):
        """
        Pass a pybean store
        """
        self.db = store

    def add_watched_dir(self, watched_dir):
        bean = self.db.find_one("watched_dir", "path like ?", [watched_dir])
        if not bean:
            bean = self.db.new("watched_dir")
        bean.path = watched_dir
        self.db.save(bean)
        return bean

    def get_watched_dirs(self):
        return self.db.find("watched_dir")

    def add_file(self, file):
        metas = Metas(file)
        bean = self.db.find_one("meta_tags", "path like ?", [metas.path])
        if not bean:
            bean = self.db.new("meta_tags")
        for key in metas.__dict__.keys():
            bean.__dict__[key] = metas.__dict__[key]
        self.db.save(bean)
        self.index_bean(bean)
        return bean

    def field_to_int(self, field):
        if field == "artist":
            return 1
        if field == "title":
            return 2
        if field == "album":
            return 3
        if field == "comment":
            return 4
        if field == "genre":
            return 5

    def index_bean(self, bean):
        analyzer = Analyzer()
        self.db.delete_all("meta_tags", "metas_uuid = ?", [bean.uuid])
        for field in ["artist", "title", "album", "comment", "genre"]:
            analyzed = analyzer.analyze(bean.__dict__[field])
            for word in analyzed:
                idx_bean = self.db.new("idx")
                idx_bean.metas_uuid = bean.uuid
                idx_bean.word = word
                idx_bean.field = self.field_to_int(field)
                self.db.save(idx_bean)

    def find(self, words, fields = None):
        analyzer = Analyzer()
        words_clauses = []
        fields_clause = ""
        if fields is not None:
            fields_num = []
            for field in fields:
                field = self.field_to_int(field)
                if field is not None:
                    fields_num.append(str(field))
            if len(fields_num) > 0:
                fields_clause = " AND field in(" + ",".join(fields_num) + ")"
        for word in analyzer.analyze(words):
            words_clauses.append(
                "uuid IN(SELECT metas_uuid FROM idx WHERE word LIKE '"
                + str(word) + "'" + fields_clause + ")")
        q = "SELECT COUNT(uuid) AS score, uuid from meta_tags where " \
            + " AND ".join(words_clauses) \
            + " GROUP BY uuid ORDER BY score DESC"
        cursor = self.db.writer.db.cursor()
        cursor.execute(q)
        for line in cursor:
            yield self.db.find_one("meta_tags", "uuid = ?", [line["uuid"]])

    def reset(self):
        self.db.delete_all("meta_tags")


def add(music_dir):
    """
    Add a directory to the tags database.
    """
    idx = Index(store())
    idx.add_watched_dir(music_dir)
    for file in walk(music_dir):
        idx.add_file(file)
        yield file


def clear():
    """
    Empty the tag database.
    """
    idx = Index(store())
    idx.reset()


def find(words, tags = None):
    """
    Perform a search in the tags database.
    Optionnaly pass the id3 tags to search for with -t
    (artist, genre, comment, etc)
    """
    if tags is not None:
        tags = tags.split()
    idx = Index(store())
    for tag in idx.find(words, tags):
        yield tag.path


def listinfos(music_dir):
    """
    List the content of the music directory
    """
    for file in walk(music_dir):
        tags = Metas(file)
        print '%s - "%s" (%s)' % (tags.artist, tags.album, tags.path)


def update():
    """
    Update tags database from watched directories.
    """
    idx = Index(store())
    for dir in idx.get_watched_dirs():
        for file in walk(dir.path):
            idx.add_file(file)
            yield file


def convert(path):
    """
    Convert all tags to id3 v2.4
    For some reason
    """
    for file in walk(path):
        subprocess.call(["eyeD3", "--to-v2.4", file])
        yield file


def gather(src, dest, dry_run = False):
    """
    rename from source directory to target directory like this:
    target/a/artist/album/title.mp3
    """
    idx = Index(store())
    for file in walk(src):
        metas = Metas(file)
        file_extension = os.path.splitext(file)[1]
        if metas.artist.strip() != "" and metas.title.strip() != "":
            album = "unknow"
            if metas.album.strip() != "":
                album = metas.album.strip()
            new_path = os.path.join(
                dest,
                metas.artist[0:1].lower(),
                safe_filename(metas.artist),
                safe_filename(album),
                safe_filename(metas.title) + file_extension)
            new_dir = os.path.dirname(new_path)
            if not os.path.isfile(new_path):
                if not dry_run:
                    if not os.path.exists(new_dir):
                        os.makedirs(new_dir)
                    shutil.move(file, new_path)
                    idx.add_file(new_path)
                yield new_path
