import os
from distutils.core import setup
# Utility function to read the README file.
# Used for the long_description.  It's nice, because now 1) we have a top level
# README file and 2) it's easier to type in the README file than to put a raw
# string in below ...
def read(fname):
        return open(os.path.join(os.path.dirname(__file__), fname)).read()

setup(
        name="tagz",
        version="0.0.9",
        description="MP3 collection utilities.",
        author="Mickael Desfrenes",
        author_email="desfrenes@gmail.com",
        py_modules=["tagz"],
        long_description=read('README'),
        scripts = ["tagz"],
        classifiers=[
            "Development Status :: 2 - Pre-Alpha",
            "Intended Audience :: End Users/Desktop",
            "Topic :: Multimedia :: Sound/Audio",
            "Topic :: Software Development :: Libraries :: Python Modules",
            "License :: OSI Approved :: BSD License",
            "Programming Language :: Python",
            ],
        install_requires=[
            'argh >= 0.15.1',
            'pybean >= 0.1.1',
            'eyeD3-pip >= 0.6.17'
            ]
)
