// Copyright 2013 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Compact number formatting symbols.
 *
 * This file is autogenerated by script:
 * http://go/generate_number_constants.py
 * using the --for_closure flag.
 * File generated from CLDR ver. 24
 *
 * To reduce the file size (which may cause issues in some JS
 * developing environments), this file will only contain locales
 * that are frequently used by web applications. This is defined as
 * closure_tier1_locales and will change (most likely addition)
 * over time.  Rest of the data can be found in another file named
 * "compactnumberformatsymbols_ext.js", which will be generated at
 * the same time together with this file.
 *
 * Before checkin, this file could have been manually edited. This is
 * to incorporate changes before we could fix CLDR. All manual
 * modification must be documented in this section, and should be
 * removed after those changes land to CLDR.
 */

goog.provide('goog.i18n.CompactNumberFormatSymbols');
goog.provide('goog.i18n.CompactNumberFormatSymbols_af');
goog.provide('goog.i18n.CompactNumberFormatSymbols_af_ZA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_am');
goog.provide('goog.i18n.CompactNumberFormatSymbols_am_ET');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_001');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bg');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bg_BG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bn_BD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_br');
goog.provide('goog.i18n.CompactNumberFormatSymbols_br_FR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_AD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_FR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_IT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_chr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_chr_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cs');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cs_CZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cy');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cy_GB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_da');
goog.provide('goog.i18n.CompactNumberFormatSymbols_da_DK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_da_GL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_AT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_BE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_DE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_LU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_el');
goog.provide('goog.i18n.CompactNumberFormatSymbols_el_GR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_001');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_AS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_AU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_DG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_Dsrt_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_FM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_TC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_UM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_VG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_VI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_ZA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_ZW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_419');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_EA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_IC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_et');
goog.provide('goog.i18n.CompactNumberFormatSymbols_et_EE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_eu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_eu_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fa');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fa_IR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fi_FI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fil');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fil_PH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_BL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_FR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_GF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_GP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_PM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_RE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_YT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gl_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gsw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gsw_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gsw_LI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gu_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_haw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_haw_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_he');
goog.provide('goog.i18n.CompactNumberFormatSymbols_he_IL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hi_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hr_HR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hu_HU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_id');
goog.provide('goog.i18n.CompactNumberFormatSymbols_id_ID');
goog.provide('goog.i18n.CompactNumberFormatSymbols_in');
goog.provide('goog.i18n.CompactNumberFormatSymbols_is');
goog.provide('goog.i18n.CompactNumberFormatSymbols_is_IS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_it');
goog.provide('goog.i18n.CompactNumberFormatSymbols_it_IT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_it_SM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_iw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ja');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ja_JP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kn_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ko');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ko_KR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ln');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ln_CD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lt_LT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lv');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lv_LV');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ml');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ml_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mr_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ms');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ms_Latn_MY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mt_MT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nb');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nb_NO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nb_SJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_NL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_no');
goog.provide('goog.i18n.CompactNumberFormatSymbols_or');
goog.provide('goog.i18n.CompactNumberFormatSymbols_or_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pl_PL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_BR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_PT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ro');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ro_RO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru_RU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sk');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sk_SK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sl_SI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sq');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sq_AL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_RS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sv');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sv_SE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sw_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ta');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ta_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_te');
goog.provide('goog.i18n.CompactNumberFormatSymbols_te_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_th');
goog.provide('goog.i18n.CompactNumberFormatSymbols_th_TH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tr');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tr_TR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uk');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uk_UA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ur');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ur_PK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vi_VN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_CN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_HK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hans_CN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_TW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zu_ZA');


/**
 * Compact number formatting symbols for locale af.
 */
goog.i18n.CompactNumberFormatSymbols_af = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0\u00A0m'
    },
    '10000000': {
      'other': '00\u00A0m'
    },
    '100000000': {
      'other': '000\u00A0m'
    },
    '1000000000': {
      'other': '0\u00A0mjd'
    },
    '10000000000': {
      'other': '00\u00A0mjd'
    },
    '100000000000': {
      'other': '000\u00A0mjd'
    },
    '1000000000000': {
      'other': '0\u00A0bn'
    },
    '10000000000000': {
      'other': '00\u00A0bn'
    },
    '100000000000000': {
      'other': '000\u00A0bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 duisend'
    },
    '10000': {
      'other': '00 duisend'
    },
    '100000': {
      'other': '000 duisend'
    },
    '1000000': {
      'other': '0 miljoen'
    },
    '10000000': {
      'other': '00 miljoen'
    },
    '100000000': {
      'other': '000 miljoen'
    },
    '1000000000': {
      'other': '0 miljard'
    },
    '10000000000': {
      'other': '00 miljard'
    },
    '100000000000': {
      'other': '000 miljard'
    },
    '1000000000000': {
      'other': '0 biljoen'
    },
    '10000000000000': {
      'other': '00 biljoen'
    },
    '100000000000000': {
      'other': '000 biljoen'
    }
  }
};


/**
 * Compact number formatting symbols for locale af_ZA.
 */
goog.i18n.CompactNumberFormatSymbols_af_ZA =
    goog.i18n.CompactNumberFormatSymbols_af;


/**
 * Compact number formatting symbols for locale am.
 */
goog.i18n.CompactNumberFormatSymbols_am = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u123A'
    },
    '10000': {
      'other': '00\u00A0\u123A'
    },
    '100000': {
      'other': '000\u00A0\u123A'
    },
    '1000000': {
      'other': '0\u00A0\u121C\u1275\u122D'
    },
    '10000000': {
      'other': '00\u00A0\u121C\u1275\u122D'
    },
    '100000000': {
      'other': '000\u00A0\u121C\u1275\u122D'
    },
    '1000000000': {
      'other': '0\u00A0\u1262'
    },
    '10000000000': {
      'other': '00\u00A0\u1262'
    },
    '100000000000': {
      'other': '000\u00A0\u1262'
    },
    '1000000000000': {
      'other': '0\u00A0\u1275'
    },
    '10000000000000': {
      'other': '00\u00A0\u1275'
    },
    '100000000000000': {
      'other': '000\u00A0\u1275'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u123A'
    },
    '10000': {
      'other': '00 \u123A'
    },
    '100000': {
      'other': '000 \u123A'
    },
    '1000000': {
      'other': '0 \u121A\u120A\u12EE\u1295'
    },
    '10000000': {
      'other': '00 \u121A\u120A\u12EE\u1295'
    },
    '100000000': {
      'other': '000 \u121A\u120A\u12EE\u1295'
    },
    '1000000000': {
      'other': '0 \u1262\u120A\u12EE\u1295'
    },
    '10000000000': {
      'other': '00 \u1262\u120A\u12EE\u1295'
    },
    '100000000000': {
      'other': '000 \u1262\u120A\u12EE\u1295'
    },
    '1000000000000': {
      'other': '0 \u1275\u122A\u120A\u12EE\u1295'
    },
    '10000000000000': {
      'other': '00 \u1275\u122A\u120A\u12EE\u1295'
    },
    '100000000000000': {
      'other': '000 \u1275\u122A\u120A\u12EE\u1295'
    }
  }
};


/**
 * Compact number formatting symbols for locale am_ET.
 */
goog.i18n.CompactNumberFormatSymbols_am_ET =
    goog.i18n.CompactNumberFormatSymbols_am;


/**
 * Compact number formatting symbols for locale ar.
 */
goog.i18n.CompactNumberFormatSymbols_ar = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u0623\u0644\u0641'
    },
    '10000': {
      'other': '00\u00A0\u0623\u0644\u0641'
    },
    '100000': {
      'other': '000\u00A0\u0623\u0644\u0641'
    },
    '1000000': {
      'other': '0\u00A0\u0645\u0644\u064A\u0648'
    },
    '10000000': {
      'other': '00\u00A0\u0645\u0644\u064A\u0648'
    },
    '100000000': {
      'other': '000\u00A0\u0645\u0644\u064A\u0648'
    },
    '1000000000': {
      'other': '0\u00A0\u0628\u0644\u064A\u0648'
    },
    '10000000000': {
      'other': '00\u00A0\u0628\u0644\u064A\u0648'
    },
    '100000000000': {
      'other': '000\u00A0\u0628\u0644\u064A\u0648'
    },
    '1000000000000': {
      'other': '0\u00A0\u062A\u0631\u0644\u064A\u0648'
    },
    '10000000000000': {
      'other': '00\u00A0\u062A\u0631\u0644\u064A\u0648'
    },
    '100000000000000': {
      'other': '000\u00A0\u062A\u0631\u0644\u064A\u0648'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0623\u0644\u0641'
    },
    '10000': {
      'other': '00 \u0623\u0644\u0641'
    },
    '100000': {
      'other': '000 \u0623\u0644\u0641'
    },
    '1000000': {
      'other': '0 \u0645\u0644\u064A\u0648\u0646'
    },
    '10000000': {
      'other': '00 \u0645\u0644\u064A\u0648\u0646'
    },
    '100000000': {
      'other': '000 \u0645\u0644\u064A\u0648\u0646'
    },
    '1000000000': {
      'other': '0 \u0628\u0644\u064A\u0648\u0646'
    },
    '10000000000': {
      'other': '00 \u0628\u0644\u064A\u0648\u0646'
    },
    '100000000000': {
      'other': '000 \u0628\u0644\u064A\u0648\u0646'
    },
    '1000000000000': {
      'other': '0 \u062A\u0631\u064A\u0644\u064A\u0648\u0646'
    },
    '10000000000000': {
      'other': '00 \u062A\u0631\u064A\u0644\u064A\u0648\u0646'
    },
    '100000000000000': {
      'other': '000 \u062A\u0631\u064A\u0644\u064A\u0648\u0646'
    }
  }
};


/**
 * Compact number formatting symbols for locale ar_001.
 */
goog.i18n.CompactNumberFormatSymbols_ar_001 =
    goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale bg.
 */
goog.i18n.CompactNumberFormatSymbols_bg = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u0445\u0438\u043B.'
    },
    '10000': {
      'other': '00\u00A0\u0445\u0438\u043B.'
    },
    '100000': {
      'other': '000\u00A0\u0445\u0438\u043B.'
    },
    '1000000': {
      'other': '0\u00A0\u043C\u043B\u043D.'
    },
    '10000000': {
      'other': '00\u00A0\u043C\u043B\u043D.'
    },
    '100000000': {
      'other': '000\u00A0\u043C\u043B\u043D.'
    },
    '1000000000': {
      'other': '0\u00A0\u043C\u043B\u0440\u0434.'
    },
    '10000000000': {
      'other': '00\u00A0\u043C\u043B\u0440\u0434.'
    },
    '100000000000': {
      'other': '000\u00A0\u043C\u043B\u0440\u0434.'
    },
    '1000000000000': {
      'other': '0\u00A0\u0442\u0440\u043B\u043D.'
    },
    '10000000000000': {
      'other': '00\u00A0\u0442\u0440\u043B\u043D.'
    },
    '100000000000000': {
      'other': '000\u00A0\u0442\u0440\u043B\u043D.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0445\u0438\u043B\u044F\u0434\u0438'
    },
    '10000': {
      'other': '00 \u0445\u0438\u043B\u044F\u0434\u0438'
    },
    '100000': {
      'other': '000 \u0445\u0438\u043B\u044F\u0434\u0438'
    },
    '1000000': {
      'other': '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '10000000': {
      'other': '00 \u043C\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '100000000': {
      'other': '000 \u043C\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '1000000000': {
      'other': '0 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430'
    },
    '10000000000': {
      'other': '00 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430'
    },
    '100000000000': {
      'other': '000 \u043C\u0438\u043B\u0438\u0430\u0440\u0434\u0430'
    },
    '1000000000000': {
      'other': '0 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '10000000000000': {
      'other': '00 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '100000000000000': {
      'other': '000 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430'
    }
  }
};


/**
 * Compact number formatting symbols for locale bg_BG.
 */
goog.i18n.CompactNumberFormatSymbols_bg_BG =
    goog.i18n.CompactNumberFormatSymbols_bg;


/**
 * Compact number formatting symbols for locale bn.
 */
goog.i18n.CompactNumberFormatSymbols_bn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '0\u00A0\u09B2\u09BE\u0996'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u09B9\u09BE\u099C\u09BE\u09B0'
    },
    '10000': {
      'other': '00 \u09B9\u09BE\u099C\u09BE\u09B0'
    },
    '100000': {
      'other': '0 \u09B2\u09BE\u0996'
    },
    '1000000': {
      'other': '0 \u09AE\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '10000000': {
      'other': '00 \u09AE\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '100000000': {
      'other': '000 \u09AE\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '1000000000': {
      'other': '0 \u09AC\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '10000000000': {
      'other': '00 \u09AC\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '100000000000': {
      'other': '000 \u09AC\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '1000000000000': {
      'other': '0 \u099F\u09CD\u09B0\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '10000000000000': {
      'other': '00 \u099F\u09CD\u09B0\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    },
    '100000000000000': {
      'other': '000 \u099F\u09CD\u09B0\u09BF\u09B2\u09BF\u09AF\u09BC\u09A8'
    }
  }
};


/**
 * Compact number formatting symbols for locale bn_BD.
 */
goog.i18n.CompactNumberFormatSymbols_bn_BD =
    goog.i18n.CompactNumberFormatSymbols_bn;


/**
 * Compact number formatting symbols for locale br.
 */
goog.i18n.CompactNumberFormatSymbols_br = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale br_FR.
 */
goog.i18n.CompactNumberFormatSymbols_br_FR =
    goog.i18n.CompactNumberFormatSymbols_br;


/**
 * Compact number formatting symbols for locale ca.
 */
goog.i18n.CompactNumberFormatSymbols_ca = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0m'
    },
    '10000': {
      'other': '00m'
    },
    '100000': {
      'other': '000m'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00\u00A0M'
    },
    '100000000': {
      'other': '000\u00A0M'
    },
    '1000000000': {
      'other': '0000\u00A0M'
    },
    '10000000000': {
      'other': '00mM'
    },
    '100000000000': {
      'other': '000mM'
    },
    '1000000000000': {
      'other': '0B'
    },
    '10000000000000': {
      'other': '00\u00A0B'
    },
    '100000000000000': {
      'other': '000\u00A0B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 milers'
    },
    '10000': {
      'other': '00 milers'
    },
    '100000': {
      'other': '000 milers'
    },
    '1000000': {
      'other': '0 milions'
    },
    '10000000': {
      'other': '00 milions'
    },
    '100000000': {
      'other': '000 milions'
    },
    '1000000000': {
      'other': '0 milers de milions'
    },
    '10000000000': {
      'other': '00 milers de milions'
    },
    '100000000000': {
      'other': '000 milers de milions'
    },
    '1000000000000': {
      'other': '0 bilions'
    },
    '10000000000000': {
      'other': '00 bilions'
    },
    '100000000000000': {
      'other': '000 bilions'
    }
  }
};


/**
 * Compact number formatting symbols for locale ca_AD.
 */
goog.i18n.CompactNumberFormatSymbols_ca_AD =
    goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale ca_ES.
 */
goog.i18n.CompactNumberFormatSymbols_ca_ES =
    goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale ca_FR.
 */
goog.i18n.CompactNumberFormatSymbols_ca_FR =
    goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale ca_IT.
 */
goog.i18n.CompactNumberFormatSymbols_ca_IT =
    goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale chr.
 */
goog.i18n.CompactNumberFormatSymbols_chr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale chr_US.
 */
goog.i18n.CompactNumberFormatSymbols_chr_US =
    goog.i18n.CompactNumberFormatSymbols_chr;


/**
 * Compact number formatting symbols for locale cs.
 */
goog.i18n.CompactNumberFormatSymbols_cs = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tis.'
    },
    '10000': {
      'other': '00\u00A0tis.'
    },
    '100000': {
      'other': '000\u00A0tis.'
    },
    '1000000': {
      'other': '0\u00A0mil.'
    },
    '10000000': {
      'other': '00\u00A0mil.'
    },
    '100000000': {
      'other': '000\u00A0mil.'
    },
    '1000000000': {
      'other': '0\u00A0mld.'
    },
    '10000000000': {
      'other': '00\u00A0mld.'
    },
    '100000000000': {
      'other': '000\u00A0mld.'
    },
    '1000000000000': {
      'other': '0\u00A0bil.'
    },
    '10000000000000': {
      'other': '00\u00A0bil.'
    },
    '100000000000000': {
      'other': '000\u00A0bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tis\u00EDc'
    },
    '10000': {
      'other': '00 tis\u00EDc'
    },
    '100000': {
      'other': '000 tis\u00EDc'
    },
    '1000000': {
      'other': '0 milion\u016F'
    },
    '10000000': {
      'other': '00 milion\u016F'
    },
    '100000000': {
      'other': '000 milion\u016F'
    },
    '1000000000': {
      'other': '0 miliard'
    },
    '10000000000': {
      'other': '00 miliard'
    },
    '100000000000': {
      'other': '000 miliard'
    },
    '1000000000000': {
      'other': '0 bilion\u016F'
    },
    '10000000000000': {
      'other': '00 bilion\u016F'
    },
    '100000000000000': {
      'other': '000 bilion\u016F'
    }
  }
};


/**
 * Compact number formatting symbols for locale cs_CZ.
 */
goog.i18n.CompactNumberFormatSymbols_cs_CZ =
    goog.i18n.CompactNumberFormatSymbols_cs;


/**
 * Compact number formatting symbols for locale cy.
 */
goog.i18n.CompactNumberFormatSymbols_cy = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 miliwn'
    },
    '10000000': {
      'other': '00 miliwn'
    },
    '100000000': {
      'other': '000 miliwn'
    },
    '1000000000': {
      'other': '0 biliwn'
    },
    '10000000000': {
      'other': '00 biliwn'
    },
    '100000000000': {
      'other': '000 biliwn'
    },
    '1000000000000': {
      'other': '0 triliwn'
    },
    '10000000000000': {
      'other': '00 triliwn'
    },
    '100000000000000': {
      'other': '000 triliwn'
    }
  }
};


/**
 * Compact number formatting symbols for locale cy_GB.
 */
goog.i18n.CompactNumberFormatSymbols_cy_GB =
    goog.i18n.CompactNumberFormatSymbols_cy;


/**
 * Compact number formatting symbols for locale da.
 */
goog.i18n.CompactNumberFormatSymbols_da = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0td'
    },
    '10000': {
      'other': '00\u00A0td'
    },
    '100000': {
      'other': '000\u00A0td'
    },
    '1000000': {
      'other': '0\u00A0mio'
    },
    '10000000': {
      'other': '00\u00A0mio'
    },
    '100000000': {
      'other': '000\u00A0mio'
    },
    '1000000000': {
      'other': '0\u00A0mia'
    },
    '10000000000': {
      'other': '00\u00A0mia'
    },
    '100000000000': {
      'other': '000\u00A0mia'
    },
    '1000000000000': {
      'other': '0\u00A0bill'
    },
    '10000000000000': {
      'other': '00\u00A0bill'
    },
    '100000000000000': {
      'other': '000\u00A0bill'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusind'
    },
    '10000': {
      'other': '00 tusind'
    },
    '100000': {
      'other': '000 tusind'
    },
    '1000000': {
      'other': '0 millioner'
    },
    '10000000': {
      'other': '00 millioner'
    },
    '100000000': {
      'other': '000 millioner'
    },
    '1000000000': {
      'other': '0 milliarder'
    },
    '10000000000': {
      'other': '00 milliarder'
    },
    '100000000000': {
      'other': '000 milliarder'
    },
    '1000000000000': {
      'other': '0 billioner'
    },
    '10000000000000': {
      'other': '00 billioner'
    },
    '100000000000000': {
      'other': '000 billioner'
    }
  }
};


/**
 * Compact number formatting symbols for locale da_DK.
 */
goog.i18n.CompactNumberFormatSymbols_da_DK =
    goog.i18n.CompactNumberFormatSymbols_da;


/**
 * Compact number formatting symbols for locale da_GL.
 */
goog.i18n.CompactNumberFormatSymbols_da_GL =
    goog.i18n.CompactNumberFormatSymbols_da;


/**
 * Compact number formatting symbols for locale de.
 */
goog.i18n.CompactNumberFormatSymbols_de = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0Tsd'
    },
    '10000': {
      'other': '00\u00A0Tsd'
    },
    '100000': {
      'other': '000\u00A0Tsd'
    },
    '1000000': {
      'other': '0\u00A0Mio'
    },
    '10000000': {
      'other': '00\u00A0Mio'
    },
    '100000000': {
      'other': '000\u00A0Mio'
    },
    '1000000000': {
      'other': '0\u00A0Mrd'
    },
    '10000000000': {
      'other': '00\u00A0Mrd'
    },
    '100000000000': {
      'other': '000\u00A0Mrd'
    },
    '1000000000000': {
      'other': '0\u00A0Bio'
    },
    '10000000000000': {
      'other': '00\u00A0Bio'
    },
    '100000000000000': {
      'other': '000\u00A0Bio'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 Tausend'
    },
    '10000': {
      'other': '00 Tausend'
    },
    '100000': {
      'other': '000 Tausend'
    },
    '1000000': {
      'other': '0 Millionen'
    },
    '10000000': {
      'other': '00 Millionen'
    },
    '100000000': {
      'other': '000 Millionen'
    },
    '1000000000': {
      'other': '0 Milliarden'
    },
    '10000000000': {
      'other': '00 Milliarden'
    },
    '100000000000': {
      'other': '000 Milliarden'
    },
    '1000000000000': {
      'other': '0 Billionen'
    },
    '10000000000000': {
      'other': '00 Billionen'
    },
    '100000000000000': {
      'other': '000 Billionen'
    }
  }
};


/**
 * Compact number formatting symbols for locale de_AT.
 */
goog.i18n.CompactNumberFormatSymbols_de_AT = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0Tsd'
    },
    '10000': {
      'other': '00\u00A0Tsd'
    },
    '100000': {
      'other': '000\u00A0Tsd'
    },
    '1000000': {
      'other': '0\u00A0Mio'
    },
    '10000000': {
      'other': '00\u00A0Mio'
    },
    '100000000': {
      'other': '000\u00A0Mio'
    },
    '1000000000': {
      'other': '0\u00A0Mrd'
    },
    '10000000000': {
      'other': '00\u00A0Mrd'
    },
    '100000000000': {
      'other': '000\u00A0Mrd'
    },
    '1000000000000': {
      'other': '0\u00A0Bio'
    },
    '10000000000000': {
      'other': '00\u00A0Bio'
    },
    '100000000000000': {
      'other': '000\u00A0Bio'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 Tausend'
    },
    '10000': {
      'other': '00 Tausend'
    },
    '100000': {
      'other': '000 Tausend'
    },
    '1000000': {
      'other': '0 Millionen'
    },
    '10000000': {
      'other': '00 Millionen'
    },
    '100000000': {
      'other': '000 Millionen'
    },
    '1000000000': {
      'other': '0 Milliarden'
    },
    '10000000000': {
      'other': '00 Milliarden'
    },
    '100000000000': {
      'other': '000 Milliarden'
    },
    '1000000000000': {
      'other': '0 Billionen'
    },
    '10000000000000': {
      'other': '00 Billionen'
    },
    '100000000000000': {
      'other': '000 Billionen'
    }
  }
};


/**
 * Compact number formatting symbols for locale de_BE.
 */
goog.i18n.CompactNumberFormatSymbols_de_BE =
    goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale de_CH.
 */
goog.i18n.CompactNumberFormatSymbols_de_CH = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0Tsd'
    },
    '10000': {
      'other': '00\u00A0Tsd'
    },
    '100000': {
      'other': '000\u00A0Tsd'
    },
    '1000000': {
      'other': '0\u00A0Mio'
    },
    '10000000': {
      'other': '00\u00A0Mio'
    },
    '100000000': {
      'other': '000\u00A0Mio'
    },
    '1000000000': {
      'other': '0\u00A0Mrd'
    },
    '10000000000': {
      'other': '00\u00A0Mrd'
    },
    '100000000000': {
      'other': '000\u00A0Mrd'
    },
    '1000000000000': {
      'other': '0\u00A0Bio'
    },
    '10000000000000': {
      'other': '00\u00A0Bio'
    },
    '100000000000000': {
      'other': '000\u00A0Bio'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 Tausend'
    },
    '10000': {
      'other': '00 Tausend'
    },
    '100000': {
      'other': '000 Tausend'
    },
    '1000000': {
      'other': '0 Millionen'
    },
    '10000000': {
      'other': '00 Millionen'
    },
    '100000000': {
      'other': '000 Millionen'
    },
    '1000000000': {
      'other': '0 Milliarden'
    },
    '10000000000': {
      'other': '00 Milliarden'
    },
    '100000000000': {
      'other': '000 Milliarden'
    },
    '1000000000000': {
      'other': '0 Billionen'
    },
    '10000000000000': {
      'other': '00 Billionen'
    },
    '100000000000000': {
      'other': '000 Billionen'
    }
  }
};


/**
 * Compact number formatting symbols for locale de_DE.
 */
goog.i18n.CompactNumberFormatSymbols_de_DE =
    goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale de_LU.
 */
goog.i18n.CompactNumberFormatSymbols_de_LU =
    goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale el.
 */
goog.i18n.CompactNumberFormatSymbols_el = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u03C7\u03B9\u03BB.'
    },
    '10000': {
      'other': '00\u00A0\u03C7\u03B9\u03BB.'
    },
    '100000': {
      'other': '000\u00A0\u03C7\u03B9\u03BB.'
    },
    '1000000': {
      'other': '0\u00A0\u03B5\u03BA.'
    },
    '10000000': {
      'other': '00\u00A0\u03B5\u03BA.'
    },
    '100000000': {
      'other': '000\u00A0\u03B5\u03BA.'
    },
    '1000000000': {
      'other': '0\u00A0\u03B4\u03B9\u03C3.'
    },
    '10000000000': {
      'other': '00\u00A0\u03B4\u03B9\u03C3.'
    },
    '100000000000': {
      'other': '000\u00A0\u03B4\u03B9\u03C3.'
    },
    '1000000000000': {
      'other': '0\u00A0\u03C4\u03C1\u03B9\u03C3.'
    },
    '10000000000000': {
      'other': '00\u00A0\u03C4\u03C1\u03B9\u03C3.'
    },
    '100000000000000': {
      'other': '000\u00A0\u03C4\u03C1\u03B9\u03C3.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2'
    },
    '10000': {
      'other': '00 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2'
    },
    '100000': {
      'other': '000 \u03C7\u03B9\u03BB\u03B9\u03AC\u03B4\u03B5\u03C2'
    },
    '1000000': {
      'other': '0 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '10000000': {
      'other': '00 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '100000000': {
      'other': '000 \u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '1000000000': {
      'other': '0 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '10000000000': {
      'other': '00 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '100000000000': {
      'other': '000 \u03B4\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '1000000000000': {
      'other': '0 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '10000000000000': {
      'other': '00 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    },
    '100000000000000': {
      'other': '000 \u03C4\u03C1\u03B9\u03C3\u03B5\u03BA\u03B1\u03C4\u03BF\u03BC\u03BC\u03CD\u03C1\u03B9\u03B1'
    }
  }
};


/**
 * Compact number formatting symbols for locale el_GR.
 */
goog.i18n.CompactNumberFormatSymbols_el_GR =
    goog.i18n.CompactNumberFormatSymbols_el;


/**
 * Compact number formatting symbols for locale en.
 */
goog.i18n.CompactNumberFormatSymbols_en = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_001.
 */
goog.i18n.CompactNumberFormatSymbols_en_001 =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_AS.
 */
goog.i18n.CompactNumberFormatSymbols_en_AS =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_AU.
 */
goog.i18n.CompactNumberFormatSymbols_en_AU = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_DG.
 */
goog.i18n.CompactNumberFormatSymbols_en_DG =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_Dsrt_US.
 */
goog.i18n.CompactNumberFormatSymbols_en_Dsrt_US =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_FM.
 */
goog.i18n.CompactNumberFormatSymbols_en_FM =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GB.
 */
goog.i18n.CompactNumberFormatSymbols_en_GB = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_GU.
 */
goog.i18n.CompactNumberFormatSymbols_en_GU =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_IE.
 */
goog.i18n.CompactNumberFormatSymbols_en_IE = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_IN.
 */
goog.i18n.CompactNumberFormatSymbols_en_IN = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_IO.
 */
goog.i18n.CompactNumberFormatSymbols_en_IO =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MH.
 */
goog.i18n.CompactNumberFormatSymbols_en_MH =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MP.
 */
goog.i18n.CompactNumberFormatSymbols_en_MP =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PR.
 */
goog.i18n.CompactNumberFormatSymbols_en_PR =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PW.
 */
goog.i18n.CompactNumberFormatSymbols_en_PW =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SG.
 */
goog.i18n.CompactNumberFormatSymbols_en_SG = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_TC.
 */
goog.i18n.CompactNumberFormatSymbols_en_TC =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_UM.
 */
goog.i18n.CompactNumberFormatSymbols_en_UM =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_US.
 */
goog.i18n.CompactNumberFormatSymbols_en_US =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_VG.
 */
goog.i18n.CompactNumberFormatSymbols_en_VG =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_VI.
 */
goog.i18n.CompactNumberFormatSymbols_en_VI =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_ZA.
 */
goog.i18n.CompactNumberFormatSymbols_en_ZA = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 thousand'
    },
    '10000': {
      'other': '00 thousand'
    },
    '100000': {
      'other': '000 thousand'
    },
    '1000000': {
      'other': '0 million'
    },
    '10000000': {
      'other': '00 million'
    },
    '100000000': {
      'other': '000 million'
    },
    '1000000000': {
      'other': '0 billion'
    },
    '10000000000': {
      'other': '00 billion'
    },
    '100000000000': {
      'other': '000 billion'
    },
    '1000000000000': {
      'other': '0 trillion'
    },
    '10000000000000': {
      'other': '00 trillion'
    },
    '100000000000000': {
      'other': '000 trillion'
    }
  }
};


/**
 * Compact number formatting symbols for locale en_ZW.
 */
goog.i18n.CompactNumberFormatSymbols_en_ZW =
    goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale es.
 */
goog.i18n.CompactNumberFormatSymbols_es = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0000\u00A0M'
    },
    '10000000000': {
      'other': '00MRD'
    },
    '100000000000': {
      'other': '000MRD'
    },
    '1000000000000': {
      'other': '0B'
    },
    '10000000000000': {
      'other': '00B'
    },
    '100000000000000': {
      'other': '000B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_419.
 */
goog.i18n.CompactNumberFormatSymbols_es_419 = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000': {
      'other': '0\u00A0M'
    },
    '10000000': {
      'other': '00\u00A0M'
    },
    '100000000': {
      'other': '000\u00A0M'
    },
    '1000000000': {
      'other': '0k\u00A0M'
    },
    '10000000000': {
      'other': '00k\u00A0M'
    },
    '100000000000': {
      'other': '000k\u00A0M'
    },
    '1000000000000': {
      'other': '0\u00A0B'
    },
    '10000000000000': {
      'other': '00\u00A0B'
    },
    '100000000000000': {
      'other': '000\u00A0B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_EA.
 */
goog.i18n.CompactNumberFormatSymbols_es_EA =
    goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale es_ES.
 */
goog.i18n.CompactNumberFormatSymbols_es_ES =
    goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale es_IC.
 */
goog.i18n.CompactNumberFormatSymbols_es_IC =
    goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale et.
 */
goog.i18n.CompactNumberFormatSymbols_et = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tuh'
    },
    '10000': {
      'other': '00\u00A0tuh'
    },
    '100000': {
      'other': '000\u00A0tuh'
    },
    '1000000': {
      'other': '0\u00A0mln'
    },
    '10000000': {
      'other': '00\u00A0mln'
    },
    '100000000': {
      'other': '000\u00A0mln'
    },
    '1000000000': {
      'other': '0\u00A0mld'
    },
    '10000000000': {
      'other': '00\u00A0mld'
    },
    '100000000000': {
      'other': '000\u00A0mld'
    },
    '1000000000000': {
      'other': '0\u00A0trl'
    },
    '10000000000000': {
      'other': '00\u00A0trl'
    },
    '100000000000000': {
      'other': '000\u00A0trl'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tuhat'
    },
    '10000': {
      'other': '00 tuhat'
    },
    '100000': {
      'other': '000 tuhat'
    },
    '1000000': {
      'other': '0 miljonit'
    },
    '10000000': {
      'other': '00 miljonit'
    },
    '100000000': {
      'other': '000 miljonit'
    },
    '1000000000': {
      'other': '0 miljardit'
    },
    '10000000000': {
      'other': '00 miljardit'
    },
    '100000000000': {
      'other': '000 miljardit'
    },
    '1000000000000': {
      'other': '0 triljonit'
    },
    '10000000000000': {
      'other': '00 triljonit'
    },
    '100000000000000': {
      'other': '000 triljonit'
    }
  }
};


/**
 * Compact number formatting symbols for locale et_EE.
 */
goog.i18n.CompactNumberFormatSymbols_et_EE =
    goog.i18n.CompactNumberFormatSymbols_et;


/**
 * Compact number formatting symbols for locale eu.
 */
goog.i18n.CompactNumberFormatSymbols_eu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0000'
    },
    '10000': {
      'other': '00000'
    },
    '100000': {
      'other': '000000'
    },
    '1000000': {
      'other': '0\u00A0M'
    },
    '10000000': {
      'other': '00\u00A0M'
    },
    '100000000': {
      'other': '000\u00A0M'
    },
    '1000000000': {
      'other': '0000\u00A0M'
    },
    '10000000000': {
      'other': '00000\u00A0M'
    },
    '100000000000': {
      'other': '000000\u00A0M'
    },
    '1000000000000': {
      'other': '0\u00A0B'
    },
    '10000000000000': {
      'other': '00\u00A0B'
    },
    '100000000000000': {
      'other': '000\u00A0B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0000'
    },
    '10000': {
      'other': '00000'
    },
    '100000': {
      'other': '000000'
    },
    '1000000': {
      'other': '0 milioi'
    },
    '10000000': {
      'other': '00 milioi'
    },
    '100000000': {
      'other': '000 milioi'
    },
    '1000000000': {
      'other': '0000 milioi'
    },
    '10000000000': {
      'other': '00000 milioi'
    },
    '100000000000': {
      'other': '000000 milioi'
    },
    '1000000000000': {
      'other': '0 bilioi'
    },
    '10000000000000': {
      'other': '00 bilioi'
    },
    '100000000000000': {
      'other': '000 bilioi'
    }
  }
};


/**
 * Compact number formatting symbols for locale eu_ES.
 */
goog.i18n.CompactNumberFormatSymbols_eu_ES =
    goog.i18n.CompactNumberFormatSymbols_eu;


/**
 * Compact number formatting symbols for locale fa.
 */
goog.i18n.CompactNumberFormatSymbols_fa = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0647\u0632\u0627\u0631'
    },
    '10000': {
      'other': '00 \u0647\u0632\u0627\u0631'
    },
    '100000': {
      'other': '000 \u0647\u0632\u0627\u0631'
    },
    '1000000': {
      'other': '0 \u0645\u06CC\u0644\u06CC\u0648\u0646'
    },
    '10000000': {
      'other': '00 \u0645\u06CC\u0644\u06CC\u0648\u0646'
    },
    '100000000': {
      'other': '000 \u0645\u06CC\u0644\u06CC\u0648\u0646'
    },
    '1000000000': {
      'other': '0 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'
    },
    '10000000000': {
      'other': '00 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'
    },
    '100000000000': {
      'other': '000 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'
    },
    '1000000000000': {
      'other': '0 \u0647\u0632\u0627\u0631 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'
    },
    '10000000000000': {
      'other': '00 \u0647\u0632\u0627\u0631 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'
    },
    '100000000000000': {
      'other': '000 \u0647\u0632\u0627\u0631 \u0645\u06CC\u0644\u06CC\u0627\u0631\u062F'
    }
  }
};


/**
 * Compact number formatting symbols for locale fa_IR.
 */
goog.i18n.CompactNumberFormatSymbols_fa_IR =
    goog.i18n.CompactNumberFormatSymbols_fa;


/**
 * Compact number formatting symbols for locale fi.
 */
goog.i18n.CompactNumberFormatSymbols_fi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0t.'
    },
    '10000': {
      'other': '00\u00A0t.'
    },
    '100000': {
      'other': '000\u00A0t.'
    },
    '1000000': {
      'other': '0\u00A0milj.'
    },
    '10000000': {
      'other': '00\u00A0milj.'
    },
    '100000000': {
      'other': '000\u00A0milj.'
    },
    '1000000000': {
      'other': '0\u00A0mrd.'
    },
    '10000000000': {
      'other': '00\u00A0mrd.'
    },
    '100000000000': {
      'other': '000\u00A0mrd.'
    },
    '1000000000000': {
      'other': '0\u00A0bilj.'
    },
    '10000000000000': {
      'other': '00\u00A0bilj.'
    },
    '100000000000000': {
      'other': '000\u00A0bilj.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tuhatta'
    },
    '10000': {
      'other': '00 tuhatta'
    },
    '100000': {
      'other': '000 tuhatta'
    },
    '1000000': {
      'other': '0 miljoonaa'
    },
    '10000000': {
      'other': '00 miljoonaa'
    },
    '100000000': {
      'other': '000 miljoonaa'
    },
    '1000000000': {
      'other': '0 miljardia'
    },
    '10000000000': {
      'other': '00 miljardia'
    },
    '100000000000': {
      'other': '000 miljardia'
    },
    '1000000000000': {
      'other': '0 biljoonaa'
    },
    '10000000000000': {
      'other': '00 biljoonaa'
    },
    '100000000000000': {
      'other': '000 biljoonaa'
    }
  }
};


/**
 * Compact number formatting symbols for locale fi_FI.
 */
goog.i18n.CompactNumberFormatSymbols_fi_FI =
    goog.i18n.CompactNumberFormatSymbols_fi;


/**
 * Compact number formatting symbols for locale fil.
 */
goog.i18n.CompactNumberFormatSymbols_fil = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 libo'
    },
    '10000': {
      'other': '00 libo'
    },
    '100000': {
      'other': '000 libo'
    },
    '1000000': {
      'other': '0 milyon'
    },
    '10000000': {
      'other': '00 milyon'
    },
    '100000000': {
      'other': '000 milyon'
    },
    '1000000000': {
      'other': '0 bilyon'
    },
    '10000000000': {
      'other': '00 bilyon'
    },
    '100000000000': {
      'other': '000 bilyon'
    },
    '1000000000000': {
      'other': '0 trilyon'
    },
    '10000000000000': {
      'other': '00 trilyon'
    },
    '100000000000000': {
      'other': '000 trilyon'
    }
  }
};


/**
 * Compact number formatting symbols for locale fil_PH.
 */
goog.i18n.CompactNumberFormatSymbols_fil_PH =
    goog.i18n.CompactNumberFormatSymbols_fil;


/**
 * Compact number formatting symbols for locale fr.
 */
goog.i18n.CompactNumberFormatSymbols_fr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0k'
    },
    '10000': {
      'other': '00\u00A0k'
    },
    '100000': {
      'other': '000\u00A0k'
    },
    '1000000': {
      'other': '0\u00A0M'
    },
    '10000000': {
      'other': '00\u00A0M'
    },
    '100000000': {
      'other': '000\u00A0M'
    },
    '1000000000': {
      'other': '0\u00A0Md'
    },
    '10000000000': {
      'other': '00\u00A0Md'
    },
    '100000000000': {
      'other': '000\u00A0Md'
    },
    '1000000000000': {
      'other': '0\u00A0Bn'
    },
    '10000000000000': {
      'other': '00\u00A0Bn'
    },
    '100000000000000': {
      'other': '000\u00A0Bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mille'
    },
    '10000': {
      'other': '00 mille'
    },
    '100000': {
      'other': '000 mille'
    },
    '1000000': {
      'other': '0 millions'
    },
    '10000000': {
      'other': '00 millions'
    },
    '100000000': {
      'other': '000 millions'
    },
    '1000000000': {
      'other': '0 milliards'
    },
    '10000000000': {
      'other': '00 milliards'
    },
    '100000000000': {
      'other': '000 milliards'
    },
    '1000000000000': {
      'other': '0 billions'
    },
    '10000000000000': {
      'other': '00 billions'
    },
    '100000000000000': {
      'other': '000 billions'
    }
  }
};


/**
 * Compact number formatting symbols for locale fr_BL.
 */
goog.i18n.CompactNumberFormatSymbols_fr_BL =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_CA.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CA = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0k'
    },
    '10000': {
      'other': '00\u00A0k'
    },
    '100000': {
      'other': '000\u00A0k'
    },
    '1000000': {
      'other': '0\u00A0M'
    },
    '10000000': {
      'other': '00\u00A0M'
    },
    '100000000': {
      'other': '000\u00A0M'
    },
    '1000000000': {
      'other': '0\u00A0Md'
    },
    '10000000000': {
      'other': '00\u00A0Md'
    },
    '100000000000': {
      'other': '000\u00A0Md'
    },
    '1000000000000': {
      'other': '0\u00A0Bn'
    },
    '10000000000000': {
      'other': '00\u00A0Bn'
    },
    '100000000000000': {
      'other': '000\u00A0Bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mille'
    },
    '10000': {
      'other': '00 mille'
    },
    '100000': {
      'other': '000 mille'
    },
    '1000000': {
      'other': '0 millions'
    },
    '10000000': {
      'other': '00 millions'
    },
    '100000000': {
      'other': '000 millions'
    },
    '1000000000': {
      'other': '0 milliards'
    },
    '10000000000': {
      'other': '00 milliards'
    },
    '100000000000': {
      'other': '000 milliards'
    },
    '1000000000000': {
      'other': '0 billions'
    },
    '10000000000000': {
      'other': '00 billions'
    },
    '100000000000000': {
      'other': '000 billions'
    }
  }
};


/**
 * Compact number formatting symbols for locale fr_FR.
 */
goog.i18n.CompactNumberFormatSymbols_fr_FR =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_GF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_GF =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_GP.
 */
goog.i18n.CompactNumberFormatSymbols_fr_GP =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MC.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MC =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MF =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MQ.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MQ =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_PM.
 */
goog.i18n.CompactNumberFormatSymbols_fr_PM =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_RE.
 */
goog.i18n.CompactNumberFormatSymbols_fr_RE =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_YT.
 */
goog.i18n.CompactNumberFormatSymbols_fr_YT =
    goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale gl.
 */
goog.i18n.CompactNumberFormatSymbols_gl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0k\u00A0M'
    },
    '10000000000': {
      'other': '00k\u00A0M'
    },
    '100000000000': {
      'other': '000k\u00A0M'
    },
    '1000000000000': {
      'other': '0\u00A0B'
    },
    '10000000000000': {
      'other': '00\u00A0B'
    },
    '100000000000000': {
      'other': '000\u00A0B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 mill\u00F3ns'
    },
    '10000000': {
      'other': '00 mill\u00F3ns'
    },
    '100000000': {
      'other': '000 mill\u00F3ns'
    },
    '1000000000': {
      'other': '0 mil mill\u00F3ns'
    },
    '10000000000': {
      'other': '00 mil mill\u00F3ns'
    },
    '100000000000': {
      'other': '000 mil mill\u00F3ns'
    },
    '1000000000000': {
      'other': '0 bill\u00F3ns'
    },
    '10000000000000': {
      'other': '00 bill\u00F3ns'
    },
    '100000000000000': {
      'other': '000 bill\u00F3ns'
    }
  }
};


/**
 * Compact number formatting symbols for locale gl_ES.
 */
goog.i18n.CompactNumberFormatSymbols_gl_ES =
    goog.i18n.CompactNumberFormatSymbols_gl;


/**
 * Compact number formatting symbols for locale gsw.
 */
goog.i18n.CompactNumberFormatSymbols_gsw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tsd'
    },
    '10000': {
      'other': '00\u00A0tsd'
    },
    '100000': {
      'other': '000\u00A0tsd'
    },
    '1000000': {
      'other': '0\u00A0Mio'
    },
    '10000000': {
      'other': '00\u00A0Mio'
    },
    '100000000': {
      'other': '000\u00A0Mio'
    },
    '1000000000': {
      'other': '0\u00A0Mrd'
    },
    '10000000000': {
      'other': '00\u00A0Mrd'
    },
    '100000000000': {
      'other': '000\u00A0Mrd'
    },
    '1000000000000': {
      'other': '0\u00A0Bio'
    },
    '10000000000000': {
      'other': '00\u00A0Bio'
    },
    '100000000000000': {
      'other': '000\u00A0Bio'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tausend'
    },
    '10000': {
      'other': '00 tausend'
    },
    '100000': {
      'other': '000 tausend'
    },
    '1000000': {
      'other': '0 Millionen'
    },
    '10000000': {
      'other': '00 Millionen'
    },
    '100000000': {
      'other': '000 Millionen'
    },
    '1000000000': {
      'other': '0 Milliarden'
    },
    '10000000000': {
      'other': '00 Milliarden'
    },
    '100000000000': {
      'other': '000 Milliarden'
    },
    '1000000000000': {
      'other': '0 Billionen'
    },
    '10000000000000': {
      'other': '00 Billionen'
    },
    '100000000000000': {
      'other': '000 Billionen'
    }
  }
};


/**
 * Compact number formatting symbols for locale gsw_CH.
 */
goog.i18n.CompactNumberFormatSymbols_gsw_CH =
    goog.i18n.CompactNumberFormatSymbols_gsw;


/**
 * Compact number formatting symbols for locale gsw_LI.
 */
goog.i18n.CompactNumberFormatSymbols_gsw_LI =
    goog.i18n.CompactNumberFormatSymbols_gsw;


/**
 * Compact number formatting symbols for locale gu.
 */
goog.i18n.CompactNumberFormatSymbols_gu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u0AB9\u0A9C\u0ABE\u0AB0'
    },
    '10000': {
      'other': '00\u00A0\u0AB9\u0A9C\u0ABE\u0AB0'
    },
    '100000': {
      'other': '0\u00A0\u0AB2\u0ABE\u0A96'
    },
    '1000000': {
      'other': '00\u00A0\u0AB2\u0ABE\u0A96'
    },
    '10000000': {
      'other': '0\u00A0\u0A95\u0AB0\u0ACB\u0AA1'
    },
    '100000000': {
      'other': '00\u00A0\u0A95\u0AB0\u0ACB\u0AA1'
    },
    '1000000000': {
      'other': '0\u00A0\u0A85\u0AAC\u0A9C'
    },
    '10000000000': {
      'other': '00\u00A0\u0A85\u0AAC\u0A9C'
    },
    '100000000000': {
      'other': '0\u00A0\u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5'
    },
    '1000000000000': {
      'other': '0\u00A0\u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE'
    },
    '10000000000000': {
      'other': '0\u00A0\u0AB6\u0A82\u0A95\u0AC1'
    },
    '100000000000000': {
      'other': '0\u00A0\u0A9C\u0AB2\u0AA7\u0ABF'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0AB9\u0A9C\u0ABE\u0AB0'
    },
    '10000': {
      'other': '00 \u0AB9\u0A9C\u0ABE\u0AB0'
    },
    '100000': {
      'other': '0 \u0AB2\u0ABE\u0A96'
    },
    '1000000': {
      'other': '00 \u0AB2\u0ABE\u0A96'
    },
    '10000000': {
      'other': '0 \u0A95\u0AB0\u0ACB\u0AA1'
    },
    '100000000': {
      'other': '00 \u0A95\u0AB0\u0ACB\u0AA1'
    },
    '1000000000': {
      'other': '0 \u0A85\u0AAC\u0A9C'
    },
    '10000000000': {
      'other': '00 \u0A85\u0AAC\u0A9C'
    },
    '100000000000': {
      'other': '0 \u0AA8\u0ABF\u0A96\u0AB0\u0ACD\u0AB5'
    },
    '1000000000000': {
      'other': '0 \u0AAE\u0AB9\u0ABE\u0AAA\u0AA6\u0ACD\u0AAE'
    },
    '10000000000000': {
      'other': '0 \u0AB6\u0A82\u0A95\u0AC1'
    },
    '100000000000000': {
      'other': '0 \u0A9C\u0AB2\u0AA7\u0ABF'
    }
  }
};


/**
 * Compact number formatting symbols for locale gu_IN.
 */
goog.i18n.CompactNumberFormatSymbols_gu_IN =
    goog.i18n.CompactNumberFormatSymbols_gu;


/**
 * Compact number formatting symbols for locale haw.
 */
goog.i18n.CompactNumberFormatSymbols_haw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale haw_US.
 */
goog.i18n.CompactNumberFormatSymbols_haw_US =
    goog.i18n.CompactNumberFormatSymbols_haw;


/**
 * Compact number formatting symbols for locale he.
 */
goog.i18n.CompactNumberFormatSymbols_he = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '\u200F0\u00A0\u05D0\u05DC\u05E3'
    },
    '10000': {
      'other': '\u200F00\u00A0\u05D0\u05DC\u05E3'
    },
    '100000': {
      'other': '\u200F000\u00A0\u05D0\u05DC\u05E3'
    },
    '1000000': {
      'other': '\u200F0\u00A0\u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '10000000': {
      'other': '\u200F00\u00A0\u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '100000000': {
      'other': '\u200F000\u00A0\u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '\u200F0 \u05D0\u05DC\u05E3'
    },
    '10000': {
      'other': '\u200F00 \u05D0\u05DC\u05E3'
    },
    '100000': {
      'other': '\u200F000 \u05D0\u05DC\u05E3'
    },
    '1000000': {
      'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '10000000': {
      'other': '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '100000000': {
      'other': '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '1000000000': {
      'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'
    },
    '10000000000': {
      'other': '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'
    },
    '100000000000': {
      'other': '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'
    },
    '1000000000000': {
      'other': '\u200F0 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '10000000000000': {
      'other': '\u200F00 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '100000000000000': {
      'other': '\u200F000 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'
    }
  }
};


/**
 * Compact number formatting symbols for locale he_IL.
 */
goog.i18n.CompactNumberFormatSymbols_he_IL =
    goog.i18n.CompactNumberFormatSymbols_he;


/**
 * Compact number formatting symbols for locale hi.
 */
goog.i18n.CompactNumberFormatSymbols_hi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0L'
    },
    '1000000': {
      'other': '00L'
    },
    '10000000': {
      'other': '0Cr'
    },
    '100000000': {
      'other': '00Cr'
    },
    '1000000000': {
      'other': '000Cr'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0939\u091C\u093C\u093E\u0930'
    },
    '10000': {
      'other': '00 \u0939\u091C\u093C\u093E\u0930'
    },
    '100000': {
      'other': '0 \u0932\u093E\u0916'
    },
    '1000000': {
      'other': '00 \u0932\u093E\u0916'
    },
    '10000000': {
      'other': '0 \u0915\u0930\u094B\u0921\u093C'
    },
    '100000000': {
      'other': '00 \u0915\u0930\u094B\u0921\u093C'
    },
    '1000000000': {
      'other': '0 \u0905\u0930\u092C'
    },
    '10000000000': {
      'other': '00 \u0905\u0930\u092C'
    },
    '100000000000': {
      'other': '0 \u0916\u0930\u092C'
    },
    '1000000000000': {
      'other': '00 \u0916\u0930\u092C'
    },
    '10000000000000': {
      'other': '000 \u0916\u0930\u092C'
    },
    '100000000000000': {
      'other': '0000 \u0916\u0930\u092C'
    }
  }
};


/**
 * Compact number formatting symbols for locale hi_IN.
 */
goog.i18n.CompactNumberFormatSymbols_hi_IN =
    goog.i18n.CompactNumberFormatSymbols_hi;


/**
 * Compact number formatting symbols for locale hr.
 */
goog.i18n.CompactNumberFormatSymbols_hr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tis.'
    },
    '10000': {
      'other': '00\u00A0tis.'
    },
    '100000': {
      'other': '000\u00A0tis.'
    },
    '1000000': {
      'other': '0\u00A0mil.'
    },
    '10000000': {
      'other': '00\u00A0mil.'
    },
    '100000000': {
      'other': '000\u00A0mil.'
    },
    '1000000000': {
      'other': '0\u00A0mlr.'
    },
    '10000000000': {
      'other': '00\u00A0mlr.'
    },
    '100000000000': {
      'other': '000\u00A0mlr.'
    },
    '1000000000000': {
      'other': '0\u00A0bil.'
    },
    '10000000000000': {
      'other': '00\u00A0bil.'
    },
    '100000000000000': {
      'other': '000\u00A0bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tisu\u0107a'
    },
    '10000': {
      'other': '00 tisu\u0107a'
    },
    '100000': {
      'other': '000 tisu\u0107a'
    },
    '1000000': {
      'other': '0 milijuna'
    },
    '10000000': {
      'other': '00 milijuna'
    },
    '100000000': {
      'other': '000 milijuna'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 bilijuna'
    },
    '10000000000000': {
      'other': '00 bilijuna'
    },
    '100000000000000': {
      'other': '000 bilijuna'
    }
  }
};


/**
 * Compact number formatting symbols for locale hr_HR.
 */
goog.i18n.CompactNumberFormatSymbols_hr_HR =
    goog.i18n.CompactNumberFormatSymbols_hr;


/**
 * Compact number formatting symbols for locale hu.
 */
goog.i18n.CompactNumberFormatSymbols_hu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0E'
    },
    '10000': {
      'other': '00\u00A0E'
    },
    '100000': {
      'other': '000\u00A0E'
    },
    '1000000': {
      'other': '0\u00A0M'
    },
    '10000000': {
      'other': '00\u00A0M'
    },
    '100000000': {
      'other': '000\u00A0M'
    },
    '1000000000': {
      'other': '0\u00A0Mrd'
    },
    '10000000000': {
      'other': '00\u00A0Mrd'
    },
    '100000000000': {
      'other': '000\u00A0Mrd'
    },
    '1000000000000': {
      'other': '0\u00A0B'
    },
    '10000000000000': {
      'other': '00\u00A0B'
    },
    '100000000000000': {
      'other': '000\u00A0B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ezer'
    },
    '10000': {
      'other': '00 ezer'
    },
    '100000': {
      'other': '000 ezer'
    },
    '1000000': {
      'other': '0 milli\u00F3'
    },
    '10000000': {
      'other': '00 milli\u00F3'
    },
    '100000000': {
      'other': '000 milli\u00F3'
    },
    '1000000000': {
      'other': '0 milli\u00E1rd'
    },
    '10000000000': {
      'other': '00 milli\u00E1rd'
    },
    '100000000000': {
      'other': '000 milli\u00E1rd'
    },
    '1000000000000': {
      'other': '0 billi\u00F3'
    },
    '10000000000000': {
      'other': '00 billi\u00F3'
    },
    '100000000000000': {
      'other': '000 billi\u00F3'
    }
  }
};


/**
 * Compact number formatting symbols for locale hu_HU.
 */
goog.i18n.CompactNumberFormatSymbols_hu_HU =
    goog.i18n.CompactNumberFormatSymbols_hu;


/**
 * Compact number formatting symbols for locale id.
 */
goog.i18n.CompactNumberFormatSymbols_id = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00\u00A0rb'
    },
    '100000': {
      'other': '000\u00A0rb'
    },
    '1000000': {
      'other': '0\u00A0jt'
    },
    '10000000': {
      'other': '00\u00A0jt'
    },
    '100000000': {
      'other': '000\u00A0jt'
    },
    '1000000000': {
      'other': '0\u00A0M'
    },
    '10000000000': {
      'other': '00\u00A0M'
    },
    '100000000000': {
      'other': '000\u00A0M'
    },
    '1000000000000': {
      'other': '0\u00A0T'
    },
    '10000000000000': {
      'other': '00\u00A0T'
    },
    '100000000000000': {
      'other': '000\u00A0T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ribu'
    },
    '10000': {
      'other': '00 ribu'
    },
    '100000': {
      'other': '000 ribu'
    },
    '1000000': {
      'other': '0 juta'
    },
    '10000000': {
      'other': '00 juta'
    },
    '100000000': {
      'other': '000 juta'
    },
    '1000000000': {
      'other': '0 miliar'
    },
    '10000000000': {
      'other': '00 miliar'
    },
    '100000000000': {
      'other': '000 miliar'
    },
    '1000000000000': {
      'other': '0 triliun'
    },
    '10000000000000': {
      'other': '00 triliun'
    },
    '100000000000000': {
      'other': '000 triliun'
    }
  }
};


/**
 * Compact number formatting symbols for locale id_ID.
 */
goog.i18n.CompactNumberFormatSymbols_id_ID =
    goog.i18n.CompactNumberFormatSymbols_id;


/**
 * Compact number formatting symbols for locale in.
 */
goog.i18n.CompactNumberFormatSymbols_in = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00\u00A0rb'
    },
    '100000': {
      'other': '000\u00A0rb'
    },
    '1000000': {
      'other': '0\u00A0jt'
    },
    '10000000': {
      'other': '00\u00A0jt'
    },
    '100000000': {
      'other': '000\u00A0jt'
    },
    '1000000000': {
      'other': '0\u00A0M'
    },
    '10000000000': {
      'other': '00\u00A0M'
    },
    '100000000000': {
      'other': '000\u00A0M'
    },
    '1000000000000': {
      'other': '0\u00A0T'
    },
    '10000000000000': {
      'other': '00\u00A0T'
    },
    '100000000000000': {
      'other': '000\u00A0T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ribu'
    },
    '10000': {
      'other': '00 ribu'
    },
    '100000': {
      'other': '000 ribu'
    },
    '1000000': {
      'other': '0 juta'
    },
    '10000000': {
      'other': '00 juta'
    },
    '100000000': {
      'other': '000 juta'
    },
    '1000000000': {
      'other': '0 miliar'
    },
    '10000000000': {
      'other': '00 miliar'
    },
    '100000000000': {
      'other': '000 miliar'
    },
    '1000000000000': {
      'other': '0 triliun'
    },
    '10000000000000': {
      'other': '00 triliun'
    },
    '100000000000000': {
      'other': '000 triliun'
    }
  }
};


/**
 * Compact number formatting symbols for locale is.
 */
goog.i18n.CompactNumberFormatSymbols_is = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u00FE.'
    },
    '10000': {
      'other': '00\u00A0\u00FE.'
    },
    '100000': {
      'other': '000\u00A0\u00FE.'
    },
    '1000000': {
      'other': '0\u00A0m.'
    },
    '10000000': {
      'other': '00\u00A0m.'
    },
    '100000000': {
      'other': '000\u00A0m.'
    },
    '1000000000': {
      'other': '0\u00A0ma.'
    },
    '10000000000': {
      'other': '00\u00A0ma.'
    },
    '100000000000': {
      'other': '000\u00A0ma.'
    },
    '1000000000000': {
      'other': '0\u00A0bn'
    },
    '10000000000000': {
      'other': '00\u00A0bn'
    },
    '100000000000000': {
      'other': '000\u00A0bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u00FE\u00FAsund'
    },
    '10000': {
      'other': '00 \u00FE\u00FAsund'
    },
    '100000': {
      'other': '000 \u00FE\u00FAsund'
    },
    '1000000': {
      'other': '0 millj\u00F3nir'
    },
    '10000000': {
      'other': '00 millj\u00F3nir'
    },
    '100000000': {
      'other': '000 millj\u00F3nir'
    },
    '1000000000': {
      'other': '0 milljar\u00F0ar'
    },
    '10000000000': {
      'other': '00 milljar\u00F0ar'
    },
    '100000000000': {
      'other': '000 milljar\u00F0ar'
    },
    '1000000000000': {
      'other': '0 billj\u00F3nir'
    },
    '10000000000000': {
      'other': '00 billj\u00F3nir'
    },
    '100000000000000': {
      'other': '000 billj\u00F3nir'
    }
  }
};


/**
 * Compact number formatting symbols for locale is_IS.
 */
goog.i18n.CompactNumberFormatSymbols_is_IS =
    goog.i18n.CompactNumberFormatSymbols_is;


/**
 * Compact number formatting symbols for locale it.
 */
goog.i18n.CompactNumberFormatSymbols_it = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '0'
    },
    '100000': {
      'other': '0'
    },
    '1000000': {
      'other': '0\u00A0Mln'
    },
    '10000000': {
      'other': '00\u00A0Mln'
    },
    '100000000': {
      'other': '000\u00A0Mln'
    },
    '1000000000': {
      'other': '0\u00A0Mld'
    },
    '10000000000': {
      'other': '00\u00A0Mld'
    },
    '100000000000': {
      'other': '000\u00A0Mld'
    },
    '1000000000000': {
      'other': '0\u00A0Bln'
    },
    '10000000000000': {
      'other': '00\u00A0Bln'
    },
    '100000000000000': {
      'other': '000\u00A0Bln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 migliaia'
    },
    '10000': {
      'other': '00 migliaia'
    },
    '100000': {
      'other': '000 migliaia'
    },
    '1000000': {
      'other': '0 milioni'
    },
    '10000000': {
      'other': '00 milioni'
    },
    '100000000': {
      'other': '000 milioni'
    },
    '1000000000': {
      'other': '0 miliardi'
    },
    '10000000000': {
      'other': '00 miliardi'
    },
    '100000000000': {
      'other': '000 miliardi'
    },
    '1000000000000': {
      'other': '0 bilioni'
    },
    '10000000000000': {
      'other': '00 bilioni'
    },
    '100000000000000': {
      'other': '000 bilioni'
    }
  }
};


/**
 * Compact number formatting symbols for locale it_IT.
 */
goog.i18n.CompactNumberFormatSymbols_it_IT =
    goog.i18n.CompactNumberFormatSymbols_it;


/**
 * Compact number formatting symbols for locale it_SM.
 */
goog.i18n.CompactNumberFormatSymbols_it_SM =
    goog.i18n.CompactNumberFormatSymbols_it;


/**
 * Compact number formatting symbols for locale iw.
 */
goog.i18n.CompactNumberFormatSymbols_iw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '\u200F0\u00A0\u05D0\u05DC\u05E3'
    },
    '10000': {
      'other': '\u200F00\u00A0\u05D0\u05DC\u05E3'
    },
    '100000': {
      'other': '\u200F000\u00A0\u05D0\u05DC\u05E3'
    },
    '1000000': {
      'other': '\u200F0\u00A0\u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '10000000': {
      'other': '\u200F00\u00A0\u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '100000000': {
      'other': '\u200F000\u00A0\u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '\u200F0 \u05D0\u05DC\u05E3'
    },
    '10000': {
      'other': '\u200F00 \u05D0\u05DC\u05E3'
    },
    '100000': {
      'other': '\u200F000 \u05D0\u05DC\u05E3'
    },
    '1000000': {
      'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '10000000': {
      'other': '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '100000000': {
      'other': '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '1000000000': {
      'other': '\u200F0 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'
    },
    '10000000000': {
      'other': '\u200F00 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'
    },
    '100000000000': {
      'other': '\u200F000 \u05DE\u05D9\u05DC\u05D9\u05D0\u05E8\u05D3'
    },
    '1000000000000': {
      'other': '\u200F0 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '10000000000000': {
      'other': '\u200F00 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'
    },
    '100000000000000': {
      'other': '\u200F000 \u05D8\u05E8\u05D9\u05DC\u05D9\u05D5\u05DF'
    }
  }
};


/**
 * Compact number formatting symbols for locale ja.
 */
goog.i18n.CompactNumberFormatSymbols_ja = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u5343'
    },
    '10000': {
      'other': '0\u4E07'
    },
    '100000': {
      'other': '00\u4E07'
    },
    '1000000': {
      'other': '000\u4E07'
    },
    '10000000': {
      'other': '0000\u4E07'
    },
    '100000000': {
      'other': '0\u5104'
    },
    '1000000000': {
      'other': '00\u5104'
    },
    '10000000000': {
      'other': '000\u5104'
    },
    '100000000000': {
      'other': '0000\u5104'
    },
    '1000000000000': {
      'other': '0\u5146'
    },
    '10000000000000': {
      'other': '00\u5146'
    },
    '100000000000000': {
      'other': '000\u5146'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0\u5343'
    },
    '10000': {
      'other': '0\u4E07'
    },
    '100000': {
      'other': '00\u4E07'
    },
    '1000000': {
      'other': '000\u4E07'
    },
    '10000000': {
      'other': '0000\u4E07'
    },
    '100000000': {
      'other': '0\u5104'
    },
    '1000000000': {
      'other': '00\u5104'
    },
    '10000000000': {
      'other': '000\u5104'
    },
    '100000000000': {
      'other': '0000\u5104'
    },
    '1000000000000': {
      'other': '0\u5146'
    },
    '10000000000000': {
      'other': '00\u5146'
    },
    '100000000000000': {
      'other': '000\u5146'
    }
  }
};


/**
 * Compact number formatting symbols for locale ja_JP.
 */
goog.i18n.CompactNumberFormatSymbols_ja_JP =
    goog.i18n.CompactNumberFormatSymbols_ja;


/**
 * Compact number formatting symbols for locale kn.
 */
goog.i18n.CompactNumberFormatSymbols_kn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0CB8\u0CBE\u0CB5\u0CBF\u0CB0'
    },
    '10000': {
      'other': '00 \u0CB8\u0CBE\u0CB5\u0CBF\u0CB0'
    },
    '100000': {
      'other': '000 \u0CB8\u0CBE\u0CB5\u0CBF\u0CB0'
    },
    '1000000': {
      'other': '0 \u0CAE\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'
    },
    '10000000': {
      'other': '00 \u0CAE\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'
    },
    '100000000': {
      'other': '000 \u0CAE\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'
    },
    '1000000000': {
      'other': '0 \u0CAC\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'
    },
    '10000000000': {
      'other': '00 \u0CAC\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'
    },
    '100000000000': {
      'other': '000 \u0CAC\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD'
    },
    '1000000000000': {
      'other': '0 \u0C9F\u0CCD\u0CB0\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD\u200C'
    },
    '10000000000000': {
      'other': '00 \u0C9F\u0CCD\u0CB0\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD\u200C'
    },
    '100000000000000': {
      'other': '000 \u0C9F\u0CCD\u0CB0\u0CBF\u0CB2\u0CBF\u0CAF\u0CA8\u0CCD\u200C'
    }
  }
};


/**
 * Compact number formatting symbols for locale kn_IN.
 */
goog.i18n.CompactNumberFormatSymbols_kn_IN =
    goog.i18n.CompactNumberFormatSymbols_kn;


/**
 * Compact number formatting symbols for locale ko.
 */
goog.i18n.CompactNumberFormatSymbols_ko = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0000'
    },
    '10000': {
      'other': '0\uB9CC'
    },
    '100000': {
      'other': '00\uB9CC'
    },
    '1000000': {
      'other': '000\uB9CC'
    },
    '10000000': {
      'other': '0000\uB9CC'
    },
    '100000000': {
      'other': '0\uC5B5'
    },
    '1000000000': {
      'other': '00\uC5B5'
    },
    '10000000000': {
      'other': '000\uC5B5'
    },
    '100000000000': {
      'other': '0000\uC5B5'
    },
    '1000000000000': {
      'other': '0\uC870'
    },
    '10000000000000': {
      'other': '00\uC870'
    },
    '100000000000000': {
      'other': '000\uC870'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0000'
    },
    '10000': {
      'other': '0\uB9CC'
    },
    '100000': {
      'other': '00\uB9CC'
    },
    '1000000': {
      'other': '000\uB9CC'
    },
    '10000000': {
      'other': '0000\uB9CC'
    },
    '100000000': {
      'other': '0\uC5B5'
    },
    '1000000000': {
      'other': '00\uC5B5'
    },
    '10000000000': {
      'other': '000\uC5B5'
    },
    '100000000000': {
      'other': '0000\uC5B5'
    },
    '1000000000000': {
      'other': '0\uC870'
    },
    '10000000000000': {
      'other': '00\uC870'
    },
    '100000000000000': {
      'other': '000\uC870'
    }
  }
};


/**
 * Compact number formatting symbols for locale ko_KR.
 */
goog.i18n.CompactNumberFormatSymbols_ko_KR =
    goog.i18n.CompactNumberFormatSymbols_ko;


/**
 * Compact number formatting symbols for locale ln.
 */
goog.i18n.CompactNumberFormatSymbols_ln = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ln_CD.
 */
goog.i18n.CompactNumberFormatSymbols_ln_CD =
    goog.i18n.CompactNumberFormatSymbols_ln;


/**
 * Compact number formatting symbols for locale lt.
 */
goog.i18n.CompactNumberFormatSymbols_lt = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0t\u016Bkst.'
    },
    '10000': {
      'other': '00\u00A0t\u016Bkst.'
    },
    '100000': {
      'other': '000\u00A0t\u016Bkst.'
    },
    '1000000': {
      'other': '0\u00A0mln.'
    },
    '10000000': {
      'other': '00\u00A0mln.'
    },
    '100000000': {
      'other': '000\u00A0mln.'
    },
    '1000000000': {
      'other': '0\u00A0mlrd.'
    },
    '10000000000': {
      'other': '00\u00A0mlrd.'
    },
    '100000000000': {
      'other': '000\u00A0mlrd.'
    },
    '1000000000000': {
      'other': '0\u00A0trln.'
    },
    '10000000000000': {
      'other': '00\u00A0trln.'
    },
    '100000000000000': {
      'other': '000\u00A0trln.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 t\u016Bkstan\u010Di\u0173'
    },
    '10000': {
      'other': '00 t\u016Bkstan\u010Di\u0173'
    },
    '100000': {
      'other': '000 t\u016Bkstan\u010Di\u0173'
    },
    '1000000': {
      'other': '0 milijon\u0173'
    },
    '10000000': {
      'other': '00 milijon\u0173'
    },
    '100000000': {
      'other': '000 milijon\u0173'
    },
    '1000000000': {
      'other': '0 milijard\u0173'
    },
    '10000000000': {
      'other': '00 milijard\u0173'
    },
    '100000000000': {
      'other': '000 milijard\u0173'
    },
    '1000000000000': {
      'other': '0 trilijon\u0173'
    },
    '10000000000000': {
      'other': '00 trilijon\u0173'
    },
    '100000000000000': {
      'other': '000 trilijon\u0173'
    }
  }
};


/**
 * Compact number formatting symbols for locale lt_LT.
 */
goog.i18n.CompactNumberFormatSymbols_lt_LT =
    goog.i18n.CompactNumberFormatSymbols_lt;


/**
 * Compact number formatting symbols for locale lv.
 */
goog.i18n.CompactNumberFormatSymbols_lv = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0t\u016Bkst.'
    },
    '10000': {
      'other': '00\u00A0t\u016Bkst.'
    },
    '100000': {
      'other': '000\u00A0t\u016Bkst.'
    },
    '1000000': {
      'other': '0\u00A0milj.'
    },
    '10000000': {
      'other': '00\u00A0milj.'
    },
    '100000000': {
      'other': '000\u00A0milj.'
    },
    '1000000000': {
      'other': '0\u00A0mljrd.'
    },
    '10000000000': {
      'other': '00\u00A0mljrd.'
    },
    '100000000000': {
      'other': '000\u00A0mljrd.'
    },
    '1000000000000': {
      'other': '0\u00A0trilj.'
    },
    '10000000000000': {
      'other': '00\u00A0trilj.'
    },
    '100000000000000': {
      'other': '000\u00A0trilj.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 t\u016Bksto\u0161i'
    },
    '10000': {
      'other': '00 t\u016Bksto\u0161i'
    },
    '100000': {
      'other': '000 t\u016Bksto\u0161i'
    },
    '1000000': {
      'other': '0 miljoni'
    },
    '10000000': {
      'other': '00 miljoni'
    },
    '100000000': {
      'other': '000 miljoni'
    },
    '1000000000': {
      'other': '0 miljardi'
    },
    '10000000000': {
      'other': '00 miljardi'
    },
    '100000000000': {
      'other': '000 miljardi'
    },
    '1000000000000': {
      'other': '0 triljoni'
    },
    '10000000000000': {
      'other': '00 triljoni'
    },
    '100000000000000': {
      'other': '000 triljoni'
    }
  }
};


/**
 * Compact number formatting symbols for locale lv_LV.
 */
goog.i18n.CompactNumberFormatSymbols_lv_LV =
    goog.i18n.CompactNumberFormatSymbols_lv;


/**
 * Compact number formatting symbols for locale ml.
 */
goog.i18n.CompactNumberFormatSymbols_ml = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0D06\u0D2F\u0D3F\u0D30\u0D02'
    },
    '10000': {
      'other': '00 \u0D06\u0D2F\u0D3F\u0D30\u0D02'
    },
    '100000': {
      'other': '000 \u0D06\u0D2F\u0D3F\u0D30\u0D02'
    },
    '1000000': {
      'other': '0 \u0D26\u0D36\u0D32\u0D15\u0D4D\u0D37\u0D02'
    },
    '10000000': {
      'other': '00 \u0D26\u0D36\u0D32\u0D15\u0D4D\u0D37\u0D02'
    },
    '100000000': {
      'other': '000 \u0D26\u0D36\u0D32\u0D15\u0D4D\u0D37\u0D02'
    },
    '1000000000': {
      'other': '0 \u0D32\u0D15\u0D4D\u0D37\u0D02 \u0D15\u0D4B\u0D1F\u0D3F'
    },
    '10000000000': {
      'other': '00 \u0D32\u0D15\u0D4D\u0D37\u0D02 \u0D15\u0D4B\u0D1F\u0D3F'
    },
    '100000000000': {
      'other': '000 \u0D32\u0D15\u0D4D\u0D37\u0D02 \u0D15\u0D4B\u0D1F\u0D3F'
    },
    '1000000000000': {
      'other': '0 \u0D1F\u0D4D\u0D30\u0D3F\u0D32\u0D4D\u0D2F\u0D7A'
    },
    '10000000000000': {
      'other': '00 \u0D1F\u0D4D\u0D30\u0D3F\u0D32\u0D4D\u0D2F\u0D7A'
    },
    '100000000000000': {
      'other': '000 \u0D1F\u0D4D\u0D30\u0D3F\u0D32\u0D4D\u0D2F\u0D7A'
    }
  }
};


/**
 * Compact number formatting symbols for locale ml_IN.
 */
goog.i18n.CompactNumberFormatSymbols_ml_IN =
    goog.i18n.CompactNumberFormatSymbols_ml;


/**
 * Compact number formatting symbols for locale mr.
 */
goog.i18n.CompactNumberFormatSymbols_mr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0939\u091C\u093E\u0930'
    },
    '10000': {
      'other': '00 \u0939\u091C\u093E\u0930'
    },
    '100000': {
      'other': '000 \u0939\u091C\u093E\u0930'
    },
    '1000000': {
      'other': '0 \u0926\u0936\u0932\u0915\u094D\u0937'
    },
    '10000000': {
      'other': '00 \u0926\u0936\u0932\u0915\u094D\u0937'
    },
    '100000000': {
      'other': '000 \u0926\u0936\u0932\u0915\u094D\u0937'
    },
    '1000000000': {
      'other': '0 \u092E\u0939\u093E\u092A\u0926\u094D\u092E'
    },
    '10000000000': {
      'other': '00 \u092E\u0939\u093E\u092A\u0926\u094D\u092E'
    },
    '100000000000': {
      'other': '000 \u092E\u0939\u093E\u092A\u0926\u094D\u092E'
    },
    '1000000000000': {
      'other': '0 \u0916\u0930\u092C'
    },
    '10000000000000': {
      'other': '00 \u0916\u0930\u092C'
    },
    '100000000000000': {
      'other': '000 \u0916\u0930\u092C'
    }
  }
};


/**
 * Compact number formatting symbols for locale mr_IN.
 */
goog.i18n.CompactNumberFormatSymbols_mr_IN =
    goog.i18n.CompactNumberFormatSymbols_mr;


/**
 * Compact number formatting symbols for locale ms.
 */
goog.i18n.CompactNumberFormatSymbols_ms = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0J'
    },
    '10000000': {
      'other': '00J'
    },
    '100000000': {
      'other': '000J'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ribu'
    },
    '10000': {
      'other': '00 ribu'
    },
    '100000': {
      'other': '000 ribu'
    },
    '1000000': {
      'other': '0 juta'
    },
    '10000000': {
      'other': '00 juta'
    },
    '100000000': {
      'other': '000 juta'
    },
    '1000000000': {
      'other': '0 bilion'
    },
    '10000000000': {
      'other': '00 bilion'
    },
    '100000000000': {
      'other': '000 bilion'
    },
    '1000000000000': {
      'other': '0 trilion'
    },
    '10000000000000': {
      'other': '00 trilion'
    },
    '100000000000000': {
      'other': '000 trilion'
    }
  }
};


/**
 * Compact number formatting symbols for locale ms_Latn_MY.
 */
goog.i18n.CompactNumberFormatSymbols_ms_Latn_MY =
    goog.i18n.CompactNumberFormatSymbols_ms;


/**
 * Compact number formatting symbols for locale mt.
 */
goog.i18n.CompactNumberFormatSymbols_mt = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mt_MT.
 */
goog.i18n.CompactNumberFormatSymbols_mt_MT =
    goog.i18n.CompactNumberFormatSymbols_mt;


/**
 * Compact number formatting symbols for locale nb.
 */
goog.i18n.CompactNumberFormatSymbols_nb = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0K'
    },
    '10000': {
      'other': '00\u00A0K'
    },
    '100000': {
      'other': '000\u00A0K'
    },
    '1000000': {
      'other': '0\u00A0mill'
    },
    '10000000': {
      'other': '00\u00A0mill'
    },
    '100000000': {
      'other': '000\u00A0mill'
    },
    '1000000000': {
      'other': '0\u00A0mrd'
    },
    '10000000000': {
      'other': '00\u00A0mrd'
    },
    '100000000000': {
      'other': '000\u00A0mrd'
    },
    '1000000000000': {
      'other': '0\u00A0bill'
    },
    '10000000000000': {
      'other': '00\u00A0bill'
    },
    '100000000000000': {
      'other': '000\u00A0bill'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusen'
    },
    '10000': {
      'other': '00 tusen'
    },
    '100000': {
      'other': '000 tusen'
    },
    '1000000': {
      'other': '0 millioner'
    },
    '10000000': {
      'other': '00 millioner'
    },
    '100000000': {
      'other': '000 millioner'
    },
    '1000000000': {
      'other': '0 milliarder'
    },
    '10000000000': {
      'other': '00 milliarder'
    },
    '100000000000': {
      'other': '000 milliarder'
    },
    '1000000000000': {
      'other': '0 billioner'
    },
    '10000000000000': {
      'other': '00 billioner'
    },
    '100000000000000': {
      'other': '000 billioner'
    }
  }
};


/**
 * Compact number formatting symbols for locale nb_NO.
 */
goog.i18n.CompactNumberFormatSymbols_nb_NO =
    goog.i18n.CompactNumberFormatSymbols_nb;


/**
 * Compact number formatting symbols for locale nb_SJ.
 */
goog.i18n.CompactNumberFormatSymbols_nb_SJ =
    goog.i18n.CompactNumberFormatSymbols_nb;


/**
 * Compact number formatting symbols for locale nl.
 */
goog.i18n.CompactNumberFormatSymbols_nl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0\u00A0mln.'
    },
    '10000000': {
      'other': '00\u00A0mln.'
    },
    '100000000': {
      'other': '000\u00A0mln.'
    },
    '1000000000': {
      'other': '0\u00A0mld.'
    },
    '10000000000': {
      'other': '00\u00A0mld.'
    },
    '100000000000': {
      'other': '000\u00A0mld.'
    },
    '1000000000000': {
      'other': '0\u00A0bln.'
    },
    '10000000000000': {
      'other': '00\u00A0bln.'
    },
    '100000000000000': {
      'other': '000\u00A0bln.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 duizend'
    },
    '10000': {
      'other': '00 duizend'
    },
    '100000': {
      'other': '000 duizend'
    },
    '1000000': {
      'other': '0 miljoen'
    },
    '10000000': {
      'other': '00 miljoen'
    },
    '100000000': {
      'other': '000 miljoen'
    },
    '1000000000': {
      'other': '0 miljard'
    },
    '10000000000': {
      'other': '00 miljard'
    },
    '100000000000': {
      'other': '000 miljard'
    },
    '1000000000000': {
      'other': '0 biljoen'
    },
    '10000000000000': {
      'other': '00 biljoen'
    },
    '100000000000000': {
      'other': '000 biljoen'
    }
  }
};


/**
 * Compact number formatting symbols for locale nl_NL.
 */
goog.i18n.CompactNumberFormatSymbols_nl_NL =
    goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale no.
 */
goog.i18n.CompactNumberFormatSymbols_no = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0K'
    },
    '10000': {
      'other': '00\u00A0K'
    },
    '100000': {
      'other': '000\u00A0K'
    },
    '1000000': {
      'other': '0\u00A0mill'
    },
    '10000000': {
      'other': '00\u00A0mill'
    },
    '100000000': {
      'other': '000\u00A0mill'
    },
    '1000000000': {
      'other': '0\u00A0mrd'
    },
    '10000000000': {
      'other': '00\u00A0mrd'
    },
    '100000000000': {
      'other': '000\u00A0mrd'
    },
    '1000000000000': {
      'other': '0\u00A0bill'
    },
    '10000000000000': {
      'other': '00\u00A0bill'
    },
    '100000000000000': {
      'other': '000\u00A0bill'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusen'
    },
    '10000': {
      'other': '00 tusen'
    },
    '100000': {
      'other': '000 tusen'
    },
    '1000000': {
      'other': '0 millioner'
    },
    '10000000': {
      'other': '00 millioner'
    },
    '100000000': {
      'other': '000 millioner'
    },
    '1000000000': {
      'other': '0 milliarder'
    },
    '10000000000': {
      'other': '00 milliarder'
    },
    '100000000000': {
      'other': '000 milliarder'
    },
    '1000000000000': {
      'other': '0 billioner'
    },
    '10000000000000': {
      'other': '00 billioner'
    },
    '100000000000000': {
      'other': '000 billioner'
    }
  }
};


/**
 * Compact number formatting symbols for locale or.
 */
goog.i18n.CompactNumberFormatSymbols_or = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale or_IN.
 */
goog.i18n.CompactNumberFormatSymbols_or_IN =
    goog.i18n.CompactNumberFormatSymbols_or;


/**
 * Compact number formatting symbols for locale pl.
 */
goog.i18n.CompactNumberFormatSymbols_pl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tys.'
    },
    '10000': {
      'other': '00\u00A0tys.'
    },
    '100000': {
      'other': '000\u00A0tys.'
    },
    '1000000': {
      'other': '0\u00A0mln'
    },
    '10000000': {
      'other': '00\u00A0mln'
    },
    '100000000': {
      'other': '000\u00A0mln'
    },
    '1000000000': {
      'other': '0\u00A0mld'
    },
    '10000000000': {
      'other': '00\u00A0mld'
    },
    '100000000000': {
      'other': '000\u00A0mld'
    },
    '1000000000000': {
      'other': '0\u00A0bln'
    },
    '10000000000000': {
      'other': '00\u00A0bln'
    },
    '100000000000000': {
      'other': '000\u00A0bln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tysi\u0105ca'
    },
    '10000': {
      'other': '00 tysi\u0105ca'
    },
    '100000': {
      'other': '000 tysi\u0105ca'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 miliarda'
    },
    '10000000000': {
      'other': '00 miliarda'
    },
    '100000000000': {
      'other': '000 miliarda'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale pl_PL.
 */
goog.i18n.CompactNumberFormatSymbols_pl_PL =
    goog.i18n.CompactNumberFormatSymbols_pl;


/**
 * Compact number formatting symbols for locale pt.
 */
goog.i18n.CompactNumberFormatSymbols_pt = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0mil'
    },
    '10000': {
      'other': '00\u00A0mil'
    },
    '100000': {
      'other': '000\u00A0mil'
    },
    '1000000': {
      'other': '0\u00A0mi'
    },
    '10000000': {
      'other': '00\u00A0mi'
    },
    '100000000': {
      'other': '000\u00A0mi'
    },
    '1000000000': {
      'other': '0\u00A0bi'
    },
    '10000000000': {
      'other': '00\u00A0bi'
    },
    '100000000000': {
      'other': '000\u00A0bi'
    },
    '1000000000000': {
      'other': '0\u00A0tri'
    },
    '10000000000000': {
      'other': '00\u00A0tri'
    },
    '100000000000000': {
      'other': '000\u00A0tri'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 milh\u00F5es'
    },
    '10000000': {
      'other': '00 milh\u00F5es'
    },
    '100000000': {
      'other': '000 milh\u00F5es'
    },
    '1000000000': {
      'other': '0 bilh\u00F5es'
    },
    '10000000000': {
      'other': '00 bilh\u00F5es'
    },
    '100000000000': {
      'other': '000 bilh\u00F5es'
    },
    '1000000000000': {
      'other': '0 trilh\u00F5es'
    },
    '10000000000000': {
      'other': '00 trilh\u00F5es'
    },
    '100000000000000': {
      'other': '000 trilh\u00F5es'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_BR.
 */
goog.i18n.CompactNumberFormatSymbols_pt_BR =
    goog.i18n.CompactNumberFormatSymbols_pt;


/**
 * Compact number formatting symbols for locale pt_PT.
 */
goog.i18n.CompactNumberFormatSymbols_pt_PT = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0mil'
    },
    '10000': {
      'other': '00\u00A0mil'
    },
    '100000': {
      'other': '000\u00A0mil'
    },
    '1000000': {
      'other': '0\u00A0M'
    },
    '10000000': {
      'other': '00\u00A0M'
    },
    '100000000': {
      'other': '000\u00A0M'
    },
    '1000000000': {
      'other': '0\u00A0MM'
    },
    '10000000000': {
      'other': '00\u00A0MM'
    },
    '100000000000': {
      'other': '000\u00A0MM'
    },
    '1000000000000': {
      'other': '0\u00A0Bi'
    },
    '10000000000000': {
      'other': '00\u00A0Bi'
    },
    '100000000000000': {
      'other': '000\u00A0Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 milh\u00F5es'
    },
    '10000000': {
      'other': '00 milh\u00F5es'
    },
    '100000000': {
      'other': '000 milh\u00F5es'
    },
    '1000000000': {
      'other': '0 mil milh\u00F5es'
    },
    '10000000000': {
      'other': '00 mil milh\u00F5es'
    },
    '100000000000': {
      'other': '000 mil milh\u00F5es'
    },
    '1000000000000': {
      'other': '0 bili\u00F5es'
    },
    '10000000000000': {
      'other': '00 bili\u00F5es'
    },
    '100000000000000': {
      'other': '000 bili\u00F5es'
    }
  }
};


/**
 * Compact number formatting symbols for locale ro.
 */
goog.i18n.CompactNumberFormatSymbols_ro = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0K'
    },
    '10000': {
      'other': '00\u00A0K'
    },
    '100000': {
      'other': '000\u00A0K'
    },
    '1000000': {
      'other': '0\u00A0mil.'
    },
    '10000000': {
      'other': '00\u00A0mil.'
    },
    '100000000': {
      'other': '000\u00A0mil.'
    },
    '1000000000': {
      'other': '0\u00A0mld.'
    },
    '10000000000': {
      'other': '00\u00A0mld.'
    },
    '100000000000': {
      'other': '000\u00A0mld.'
    },
    '1000000000000': {
      'other': '0\u00A0tril.'
    },
    '10000000000000': {
      'other': '00\u00A0tril.'
    },
    '100000000000000': {
      'other': '000\u00A0tril.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 de mii'
    },
    '10000': {
      'other': '00 de mii'
    },
    '100000': {
      'other': '000 de mii'
    },
    '1000000': {
      'other': '0 de milioane'
    },
    '10000000': {
      'other': '00 de milioane'
    },
    '100000000': {
      'other': '000 de milioane'
    },
    '1000000000': {
      'other': '0 de miliarde'
    },
    '10000000000': {
      'other': '00 de miliarde'
    },
    '100000000000': {
      'other': '000 de miliarde'
    },
    '1000000000000': {
      'other': '0 de trilioane'
    },
    '10000000000000': {
      'other': '00 de trilioane'
    },
    '100000000000000': {
      'other': '000 de trilioane'
    }
  }
};


/**
 * Compact number formatting symbols for locale ro_RO.
 */
goog.i18n.CompactNumberFormatSymbols_ro_RO =
    goog.i18n.CompactNumberFormatSymbols_ro;


/**
 * Compact number formatting symbols for locale ru.
 */
goog.i18n.CompactNumberFormatSymbols_ru = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u0442\u044B\u0441.'
    },
    '10000': {
      'other': '00\u00A0\u0442\u044B\u0441.'
    },
    '100000': {
      'other': '000\u00A0\u0442\u044B\u0441.'
    },
    '1000000': {
      'other': '0\u00A0\u043C\u043B\u043D'
    },
    '10000000': {
      'other': '00\u00A0\u043C\u043B\u043D'
    },
    '100000000': {
      'other': '000\u00A0\u043C\u043B\u043D'
    },
    '1000000000': {
      'other': '0\u00A0\u043C\u043B\u0440\u0434'
    },
    '10000000000': {
      'other': '00\u00A0\u043C\u043B\u0440\u0434'
    },
    '100000000000': {
      'other': '000\u00A0\u043C\u043B\u0440\u0434'
    },
    '1000000000000': {
      'other': '0\u00A0\u0442\u0440\u043B\u043D'
    },
    '10000000000000': {
      'other': '00\u00A0\u0442\u0440\u043B\u043D'
    },
    '100000000000000': {
      'other': '000\u00A0\u0442\u0440\u043B\u043D'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0442\u044B\u0441\u044F\u0447\u0438'
    },
    '10000': {
      'other': '00 \u0442\u044B\u0441\u044F\u0447\u0438'
    },
    '100000': {
      'other': '000 \u0442\u044B\u0441\u044F\u0447\u0438'
    },
    '1000000': {
      'other': '0 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430'
    },
    '10000000': {
      'other': '00 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430'
    },
    '100000000': {
      'other': '000 \u043C\u0438\u043B\u043B\u0438\u043E\u043D\u0430'
    },
    '1000000000': {
      'other': '0 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430'
    },
    '10000000000': {
      'other': '00 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430'
    },
    '100000000000': {
      'other': '000 \u043C\u0438\u043B\u043B\u0438\u0430\u0440\u0434\u0430'
    },
    '1000000000000': {
      'other': '0 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430'
    },
    '10000000000000': {
      'other': '00 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430'
    },
    '100000000000000': {
      'other': '000 \u0442\u0440\u0438\u043B\u043B\u0438\u043E\u043D\u0430'
    }
  }
};


/**
 * Compact number formatting symbols for locale ru_RU.
 */
goog.i18n.CompactNumberFormatSymbols_ru_RU =
    goog.i18n.CompactNumberFormatSymbols_ru;


/**
 * Compact number formatting symbols for locale sk.
 */
goog.i18n.CompactNumberFormatSymbols_sk = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tis.'
    },
    '10000': {
      'other': '00\u00A0tis.'
    },
    '100000': {
      'other': '000\u00A0tis.'
    },
    '1000000': {
      'other': '0\u00A0mil.'
    },
    '10000000': {
      'other': '00\u00A0mil.'
    },
    '100000000': {
      'other': '000\u00A0mil.'
    },
    '1000000000': {
      'other': '0\u00A0mld.'
    },
    '10000000000': {
      'other': '00\u00A0mld.'
    },
    '100000000000': {
      'other': '000\u00A0mld.'
    },
    '1000000000000': {
      'other': '0\u00A0bil.'
    },
    '10000000000000': {
      'other': '00\u00A0bil.'
    },
    '100000000000000': {
      'other': '000\u00A0bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tis\u00EDc'
    },
    '10000': {
      'other': '00 tis\u00EDc'
    },
    '100000': {
      'other': '000 tis\u00EDc'
    },
    '1000000': {
      'other': '0 mili\u00F3nov'
    },
    '10000000': {
      'other': '00 mili\u00F3nov'
    },
    '100000000': {
      'other': '000 mili\u00F3nov'
    },
    '1000000000': {
      'other': '0 miliard'
    },
    '10000000000': {
      'other': '00 mili\u00E1rd'
    },
    '100000000000': {
      'other': '000 mili\u00E1rd'
    },
    '1000000000000': {
      'other': '0 bili\u00F3nov'
    },
    '10000000000000': {
      'other': '00 bili\u00F3nov'
    },
    '100000000000000': {
      'other': '000 bili\u00F3nov'
    }
  }
};


/**
 * Compact number formatting symbols for locale sk_SK.
 */
goog.i18n.CompactNumberFormatSymbols_sk_SK =
    goog.i18n.CompactNumberFormatSymbols_sk;


/**
 * Compact number formatting symbols for locale sl.
 */
goog.i18n.CompactNumberFormatSymbols_sl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tis.'
    },
    '10000': {
      'other': '00\u00A0tis.'
    },
    '100000': {
      'other': '000\u00A0tis.'
    },
    '1000000': {
      'other': '0\u00A0mio.'
    },
    '10000000': {
      'other': '00\u00A0mio.'
    },
    '100000000': {
      'other': '000\u00A0mio.'
    },
    '1000000000': {
      'other': '0\u00A0mrd.'
    },
    '10000000000': {
      'other': '00\u00A0mrd.'
    },
    '100000000000': {
      'other': '000\u00A0mrd.'
    },
    '1000000000000': {
      'other': '0\u00A0bil.'
    },
    '10000000000000': {
      'other': '00\u00A0bil.'
    },
    '100000000000000': {
      'other': '000\u00A0bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tiso\u010D'
    },
    '10000': {
      'other': '00 tiso\u010D'
    },
    '100000': {
      'other': '000 tiso\u010D'
    },
    '1000000': {
      'other': '0 milijonov'
    },
    '10000000': {
      'other': '00 milijonov'
    },
    '100000000': {
      'other': '000 milijonov'
    },
    '1000000000': {
      'other': '0 milijard'
    },
    '10000000000': {
      'other': '00 milijard'
    },
    '100000000000': {
      'other': '000 milijard'
    },
    '1000000000000': {
      'other': '0 bilijonov'
    },
    '10000000000000': {
      'other': '00 bilijonov'
    },
    '100000000000000': {
      'other': '000 bilijonov'
    }
  }
};


/**
 * Compact number formatting symbols for locale sl_SI.
 */
goog.i18n.CompactNumberFormatSymbols_sl_SI =
    goog.i18n.CompactNumberFormatSymbols_sl;


/**
 * Compact number formatting symbols for locale sq.
 */
goog.i18n.CompactNumberFormatSymbols_sq = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0mij\u00EB'
    },
    '10000': {
      'other': '00\u00A0mij\u00EB'
    },
    '100000': {
      'other': '000\u00A0mij\u00EB'
    },
    '1000000': {
      'other': '0\u00A0Mln'
    },
    '10000000': {
      'other': '00\u00A0Mln'
    },
    '100000000': {
      'other': '000\u00A0Mln'
    },
    '1000000000': {
      'other': '0\u00A0Mld'
    },
    '10000000000': {
      'other': '00\u00A0Mld'
    },
    '100000000000': {
      'other': '000\u00A0Mld'
    },
    '1000000000000': {
      'other': '0\u00A0Bln'
    },
    '10000000000000': {
      'other': '00\u00A0Bln'
    },
    '100000000000000': {
      'other': '000\u00A0Bln'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mij\u00EB'
    },
    '10000': {
      'other': '00 mij\u00EB'
    },
    '100000': {
      'other': '000 mij\u00EB'
    },
    '1000000': {
      'other': '0 milion'
    },
    '10000000': {
      'other': '00 milion'
    },
    '100000000': {
      'other': '000 milion'
    },
    '1000000000': {
      'other': '0 miliard'
    },
    '10000000000': {
      'other': '00 miliard'
    },
    '100000000000': {
      'other': '000 miliard'
    },
    '1000000000000': {
      'other': '0 bilion'
    },
    '10000000000000': {
      'other': '00 bilion'
    },
    '100000000000000': {
      'other': '000 bilion'
    }
  }
};


/**
 * Compact number formatting symbols for locale sq_AL.
 */
goog.i18n.CompactNumberFormatSymbols_sq_AL =
    goog.i18n.CompactNumberFormatSymbols_sq;


/**
 * Compact number formatting symbols for locale sr.
 */
goog.i18n.CompactNumberFormatSymbols_sr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00\u00A0\u0445\u0438\u0459'
    },
    '100000': {
      'other': '000\u00A0\u0445\u0438\u0459'
    },
    '1000000': {
      'other': '0\u00A0\u043C\u0438\u043B'
    },
    '10000000': {
      'other': '00\u00A0\u043C\u0438\u043B'
    },
    '100000000': {
      'other': '000\u00A0\u043C\u0438\u043B'
    },
    '1000000000': {
      'other': '0\u00A0\u043C\u043B\u0440\u0434'
    },
    '10000000000': {
      'other': '00\u00A0\u043C\u043B\u0440\u0434'
    },
    '100000000000': {
      'other': '000\u00A0\u043C\u043B\u0440\u0434'
    },
    '1000000000000': {
      'other': '0\u00A0\u0431\u0438\u043B'
    },
    '10000000000000': {
      'other': '00\u00A0\u0431\u0438\u043B'
    },
    '100000000000000': {
      'other': '000\u00A0\u0431\u0438\u043B'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0445\u0438\u0459\u0430\u0434\u0430'
    },
    '10000': {
      'other': '00 \u0445\u0438\u0459\u0430\u0434\u0430'
    },
    '100000': {
      'other': '000 \u0445\u0438\u0459\u0430\u0434\u0430'
    },
    '1000000': {
      'other': '0 \u043C\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '10000000': {
      'other': '00 \u043C\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '100000000': {
      'other': '000 \u043C\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '1000000000': {
      'other': '0 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438'
    },
    '10000000000': {
      'other': '00 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438'
    },
    '100000000000': {
      'other': '000 \u043C\u0438\u043B\u0438\u0458\u0430\u0440\u0434\u0438'
    },
    '1000000000000': {
      'other': '0 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '10000000000000': {
      'other': '00 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430'
    },
    '100000000000000': {
      'other': '000 \u0442\u0440\u0438\u043B\u0438\u043E\u043D\u0430'
    }
  }
};


/**
 * Compact number formatting symbols for locale sr_Cyrl_RS.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_RS =
    goog.i18n.CompactNumberFormatSymbols_sr;


/**
 * Compact number formatting symbols for locale sv.
 */
goog.i18n.CompactNumberFormatSymbols_sv = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0tn'
    },
    '10000': {
      'other': '00\u00A0tn'
    },
    '100000': {
      'other': '000\u00A0tn'
    },
    '1000000': {
      'other': '0\u00A0mn'
    },
    '10000000': {
      'other': '00\u00A0mn'
    },
    '100000000': {
      'other': '000\u00A0mn'
    },
    '1000000000': {
      'other': '0\u00A0md'
    },
    '10000000000': {
      'other': '00\u00A0md'
    },
    '100000000000': {
      'other': '000\u00A0md'
    },
    '1000000000000': {
      'other': '0\u00A0bn'
    },
    '10000000000000': {
      'other': '00\u00A0bn'
    },
    '100000000000000': {
      'other': '000\u00A0bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tusen'
    },
    '10000': {
      'other': '00 tusen'
    },
    '100000': {
      'other': '000 tusen'
    },
    '1000000': {
      'other': '0 miljoner'
    },
    '10000000': {
      'other': '00 miljoner'
    },
    '100000000': {
      'other': '000 miljoner'
    },
    '1000000000': {
      'other': '0 miljarder'
    },
    '10000000000': {
      'other': '00 miljarder'
    },
    '100000000000': {
      'other': '000 miljarder'
    },
    '1000000000000': {
      'other': '0 biljoner'
    },
    '10000000000000': {
      'other': '00 biljoner'
    },
    '100000000000000': {
      'other': '000 biljoner'
    }
  }
};


/**
 * Compact number formatting symbols for locale sv_SE.
 */
goog.i18n.CompactNumberFormatSymbols_sv_SE =
    goog.i18n.CompactNumberFormatSymbols_sv;


/**
 * Compact number formatting symbols for locale sw.
 */
goog.i18n.CompactNumberFormatSymbols_sw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': 'elfu\u00A00'
    },
    '10000': {
      'other': 'elfu\u00A000'
    },
    '100000': {
      'other': 'laki0'
    },
    '1000000': {
      'other': 'M0'
    },
    '10000000': {
      'other': 'M00'
    },
    '100000000': {
      'other': 'M000'
    },
    '1000000000': {
      'other': 'B0'
    },
    '10000000000': {
      'other': 'B00'
    },
    '100000000000': {
      'other': 'B000'
    },
    '1000000000000': {
      'other': 'T0'
    },
    '10000000000000': {
      'other': 'T00'
    },
    '100000000000000': {
      'other': 'T000'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': 'Elfu 0'
    },
    '10000': {
      'other': 'Elfu 00'
    },
    '100000': {
      'other': 'Elfu 000'
    },
    '1000000': {
      'other': 'Milioni 0'
    },
    '10000000': {
      'other': 'Milioni 00'
    },
    '100000000': {
      'other': 'Milioni 000'
    },
    '1000000000': {
      'other': 'Bilioni 0'
    },
    '10000000000': {
      'other': 'Bilioni 00'
    },
    '100000000000': {
      'other': 'Bilioni 000'
    },
    '1000000000000': {
      'other': 'Trilioni 0'
    },
    '10000000000000': {
      'other': 'Trilioni 00'
    },
    '100000000000000': {
      'other': 'Trilioni 000'
    }
  }
};


/**
 * Compact number formatting symbols for locale sw_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_sw_TZ =
    goog.i18n.CompactNumberFormatSymbols_sw;


/**
 * Compact number formatting symbols for locale ta.
 */
goog.i18n.CompactNumberFormatSymbols_ta = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u0B86'
    },
    '10000': {
      'other': '00\u0B86'
    },
    '100000': {
      'other': '000\u0B86'
    },
    '1000000': {
      'other': '0\u0BAE\u0BBF'
    },
    '10000000': {
      'other': '00\u0BAE\u0BBF'
    },
    '100000000': {
      'other': '000\u0BAE\u0BBF'
    },
    '1000000000': {
      'other': '0\u0BAA\u0BBF'
    },
    '10000000000': {
      'other': '00\u0BAA\u0BBF'
    },
    '100000000000': {
      'other': '000\u0BAA\u0BBF'
    },
    '1000000000000': {
      'other': '0\u0B9F\u0BBF'
    },
    '10000000000000': {
      'other': '00\u0B9F\u0BBF'
    },
    '100000000000000': {
      'other': '000\u0B9F\u0BBF'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0B86\u0BAF\u0BBF\u0BB0\u0BAE\u0BCD'
    },
    '10000': {
      'other': '00 \u0B86\u0BAF\u0BBF\u0BB0\u0BAE\u0BCD'
    },
    '100000': {
      'other': '000 \u0B86\u0BAF\u0BBF\u0BB0\u0BAE\u0BCD'
    },
    '1000000': {
      'other': '0 \u0BAE\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '10000000': {
      'other': '00 \u0BAE\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '100000000': {
      'other': '000 \u0BAE\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '1000000000': {
      'other': '0 \u0BAA\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '10000000000': {
      'other': '00 \u0BAA\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '100000000000': {
      'other': '000 \u0BAA\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '1000000000000': {
      'other': '0 \u0B9F\u0BBF\u0BB0\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '10000000000000': {
      'other': '00 \u0B9F\u0BBF\u0BB0\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    },
    '100000000000000': {
      'other': '000 \u0B9F\u0BBF\u0BB0\u0BBF\u0BB2\u0BCD\u0BB2\u0BBF\u0BAF\u0BA9\u0BCD'
    }
  }
};


/**
 * Compact number formatting symbols for locale ta_IN.
 */
goog.i18n.CompactNumberFormatSymbols_ta_IN =
    goog.i18n.CompactNumberFormatSymbols_ta;


/**
 * Compact number formatting symbols for locale te.
 */
goog.i18n.CompactNumberFormatSymbols_te = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u0C35\u0C47'
    },
    '10000': {
      'other': '00\u0C35\u0C47'
    },
    '100000': {
      'other': '000\u0C35\u0C47'
    },
    '1000000': {
      'other': '0\u0C2E\u0C3F'
    },
    '10000000': {
      'other': '00\u0C2E\u0C3F'
    },
    '100000000': {
      'other': '000\u0C2E\u0C3F'
    },
    '1000000000': {
      'other': '0\u0C2C\u0C3F'
    },
    '10000000000': {
      'other': '00\u0C2C\u0C3F'
    },
    '100000000000': {
      'other': '000\u0C2C\u0C3F'
    },
    '1000000000000': {
      'other': '0\u0C1F\u0C4D\u0C30\u0C3F'
    },
    '10000000000000': {
      'other': '00\u0C1F\u0C4D\u0C30\u0C3F'
    },
    '100000000000000': {
      'other': '000\u0C1F\u0C4D\u0C30\u0C3F'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0C35\u0C47\u0C32\u0C41'
    },
    '10000': {
      'other': '00 \u0C35\u0C47\u0C32\u0C41'
    },
    '100000': {
      'other': '000 \u0C35\u0C47\u0C32\u0C41'
    },
    '1000000': {
      'other': '0 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '10000000': {
      'other': '00 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '100000000': {
      'other': '000 \u0C2E\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '1000000000': {
      'other': '0 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '10000000000': {
      'other': '00 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '100000000000': {
      'other': '000 \u0C2C\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '1000000000000': {
      'other': '0 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '10000000000000': {
      'other': '00 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    },
    '100000000000000': {
      'other': '000 \u0C1F\u0C4D\u0C30\u0C3F\u0C32\u0C3F\u0C2F\u0C28\u0C4D'
    }
  }
};


/**
 * Compact number formatting symbols for locale te_IN.
 */
goog.i18n.CompactNumberFormatSymbols_te_IN =
    goog.i18n.CompactNumberFormatSymbols_te;


/**
 * Compact number formatting symbols for locale th.
 */
goog.i18n.CompactNumberFormatSymbols_th = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u0E1E.'
    },
    '10000': {
      'other': '0\u00A0\u0E21.'
    },
    '100000': {
      'other': '0\u00A0\u0E2A.'
    },
    '1000000': {
      'other': '0\u00A0\u0E25.'
    },
    '10000000': {
      'other': '00\u00A0\u0E25.'
    },
    '100000000': {
      'other': '000\u00A0\u0E25.'
    },
    '1000000000': {
      'other': '0\u00A0\u0E1E.\u0E25.'
    },
    '10000000000': {
      'other': '0\u00A0\u0E21.\u0E25.'
    },
    '100000000000': {
      'other': '0\u00A0\u0E2A.\u0E25.'
    },
    '1000000000000': {
      'other': '0\u00A0\u0E25.\u0E25.'
    },
    '10000000000000': {
      'other': '00\u00A0\u0E25.\u0E25.'
    },
    '100000000000000': {
      'other': '000\u00A0\u0E25.\u0E25.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0E1E\u0E31\u0E19'
    },
    '10000': {
      'other': '0 \u0E2B\u0E21\u0E37\u0E48\u0E19'
    },
    '100000': {
      'other': '0 \u0E41\u0E2A\u0E19'
    },
    '1000000': {
      'other': '0 \u0E25\u0E49\u0E32\u0E19'
    },
    '10000000': {
      'other': '00 \u0E25\u0E49\u0E32\u0E19'
    },
    '100000000': {
      'other': '000 \u0E25\u0E49\u0E32\u0E19'
    },
    '1000000000': {
      'other': '0 \u0E1E\u0E31\u0E19\u0E25\u0E49\u0E32\u0E19'
    },
    '10000000000': {
      'other': '0 \u0E2B\u0E21\u0E37\u0E48\u0E19\u0E25\u0E49\u0E32\u0E19'
    },
    '100000000000': {
      'other': '0 \u0E41\u0E2A\u0E19\u0E25\u0E49\u0E32\u0E19'
    },
    '1000000000000': {
      'other': '0 \u0E25\u0E49\u0E32\u0E19\u0E25\u0E49\u0E32\u0E19'
    },
    '10000000000000': {
      'other': '00 \u0E25\u0E49\u0E32\u0E19\u0E25\u0E49\u0E32\u0E19'
    },
    '100000000000000': {
      'other': '000 \u0E25\u0E49\u0E32\u0E19\u0E25\u0E49\u0E32\u0E19'
    }
  }
};


/**
 * Compact number formatting symbols for locale th_TH.
 */
goog.i18n.CompactNumberFormatSymbols_th_TH =
    goog.i18n.CompactNumberFormatSymbols_th;


/**
 * Compact number formatting symbols for locale tl.
 */
goog.i18n.CompactNumberFormatSymbols_tl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 libo'
    },
    '10000': {
      'other': '00 libo'
    },
    '100000': {
      'other': '000 libo'
    },
    '1000000': {
      'other': '0 milyon'
    },
    '10000000': {
      'other': '00 milyon'
    },
    '100000000': {
      'other': '000 milyon'
    },
    '1000000000': {
      'other': '0 bilyon'
    },
    '10000000000': {
      'other': '00 bilyon'
    },
    '100000000000': {
      'other': '000 bilyon'
    },
    '1000000000000': {
      'other': '0 trilyon'
    },
    '10000000000000': {
      'other': '00 trilyon'
    },
    '100000000000000': {
      'other': '000 trilyon'
    }
  }
};


/**
 * Compact number formatting symbols for locale tr.
 */
goog.i18n.CompactNumberFormatSymbols_tr = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00\u00A0B'
    },
    '100000': {
      'other': '000\u00A0B'
    },
    '1000000': {
      'other': '0\u00A0Mn'
    },
    '10000000': {
      'other': '00\u00A0Mn'
    },
    '100000000': {
      'other': '000\u00A0Mn'
    },
    '1000000000': {
      'other': '0\u00A0Mr'
    },
    '10000000000': {
      'other': '00\u00A0Mr'
    },
    '100000000000': {
      'other': '000\u00A0Mr'
    },
    '1000000000000': {
      'other': '0\u00A0Tn'
    },
    '10000000000000': {
      'other': '00\u00A0Tn'
    },
    '100000000000000': {
      'other': '000\u00A0Tn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 bin'
    },
    '10000': {
      'other': '00 bin'
    },
    '100000': {
      'other': '000 bin'
    },
    '1000000': {
      'other': '0 milyon'
    },
    '10000000': {
      'other': '00 milyon'
    },
    '100000000': {
      'other': '000 milyon'
    },
    '1000000000': {
      'other': '0 milyar'
    },
    '10000000000': {
      'other': '00 milyar'
    },
    '100000000000': {
      'other': '000 milyar'
    },
    '1000000000000': {
      'other': '0 trilyon'
    },
    '10000000000000': {
      'other': '00 trilyon'
    },
    '100000000000000': {
      'other': '000 trilyon'
    }
  }
};


/**
 * Compact number formatting symbols for locale tr_TR.
 */
goog.i18n.CompactNumberFormatSymbols_tr_TR =
    goog.i18n.CompactNumberFormatSymbols_tr;


/**
 * Compact number formatting symbols for locale uk.
 */
goog.i18n.CompactNumberFormatSymbols_uk = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u0442\u0438\u0441'
    },
    '10000': {
      'other': '00\u00A0\u0442\u0438\u0441'
    },
    '100000': {
      'other': '000\u00A0\u0442\u0438\u0441'
    },
    '1000000': {
      'other': '0\u00A0\u043C\u043B\u043D'
    },
    '10000000': {
      'other': '00\u00A0\u043C\u043B\u043D'
    },
    '100000000': {
      'other': '000\u00A0\u043C\u043B\u043D'
    },
    '1000000000': {
      'other': '0\u00A0\u043C\u043B\u0440\u0434'
    },
    '10000000000': {
      'other': '00\u00A0\u043C\u043B\u0440\u0434'
    },
    '100000000000': {
      'other': '000\u00A0\u043C\u043B\u0440\u0434'
    },
    '1000000000000': {
      'other': '0\u00A0\u0442\u0440\u043B\u043D'
    },
    '10000000000000': {
      'other': '00\u00A0\u0442\u0440\u043B\u043D'
    },
    '100000000000000': {
      'other': '000\u00A0\u0442\u0440\u043B\u043D'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u0442\u0438\u0441\u044F\u0447\u0456'
    },
    '10000': {
      'other': '00 \u0442\u0438\u0441\u044F\u0447\u0456'
    },
    '100000': {
      'other': '000 \u0442\u0438\u0441\u044F\u0447\u0456'
    },
    '1000000': {
      'other': '0 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0430'
    },
    '10000000': {
      'other': '00 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0430'
    },
    '100000000': {
      'other': '000 \u043C\u0456\u043B\u044C\u0439\u043E\u043D\u0430'
    },
    '1000000000': {
      'other': '0 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430'
    },
    '10000000000': {
      'other': '00 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430'
    },
    '100000000000': {
      'other': '000 \u043C\u0456\u043B\u044C\u044F\u0440\u0434\u0430'
    },
    '1000000000000': {
      'other': '0 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0430'
    },
    '10000000000000': {
      'other': '00 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0430'
    },
    '100000000000000': {
      'other': '000 \u0442\u0440\u0438\u043B\u044C\u0439\u043E\u043D\u0430'
    }
  }
};


/**
 * Compact number formatting symbols for locale uk_UA.
 */
goog.i18n.CompactNumberFormatSymbols_uk_UA =
    goog.i18n.CompactNumberFormatSymbols_uk;


/**
 * Compact number formatting symbols for locale ur.
 */
goog.i18n.CompactNumberFormatSymbols_ur = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0\u06C1\u0632\u0627\u0631'
    },
    '10000': {
      'other': '00\u00A0\u06C1\u0632\u0627\u0631'
    },
    '100000': {
      'other': '0\u00A0\u0644\u0627\u06A9\u06BE'
    },
    '1000000': {
      'other': '00\u00A0\u0644\u0627\u06A9\u06BE'
    },
    '10000000': {
      'other': '0\u00A0\u06A9\u0631\u0648\u0691'
    },
    '100000000': {
      'other': '00\u00A0\u06A9\u0631\u0648\u0691'
    },
    '1000000000': {
      'other': '0\u00A0\u0627\u0631\u0628'
    },
    '10000000000': {
      'other': '00\u00A0\u0627\u0631\u0628'
    },
    '100000000000': {
      'other': '0\u00A0\u06A9\u06BE\u0631\u0628'
    },
    '1000000000000': {
      'other': '00\u00A0\u06A9\u06BE\u0631\u0628'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ur_PK.
 */
goog.i18n.CompactNumberFormatSymbols_ur_PK =
    goog.i18n.CompactNumberFormatSymbols_ur;


/**
 * Compact number formatting symbols for locale vi.
 */
goog.i18n.CompactNumberFormatSymbols_vi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u00A0N'
    },
    '10000': {
      'other': '00\u00A0N'
    },
    '100000': {
      'other': '000\u00A0N'
    },
    '1000000': {
      'other': '0\u00A0Tr'
    },
    '10000000': {
      'other': '00\u00A0Tr'
    },
    '100000000': {
      'other': '000\u00A0Tr'
    },
    '1000000000': {
      'other': '0\u00A0T'
    },
    '10000000000': {
      'other': '00\u00A0T'
    },
    '100000000000': {
      'other': '000\u00A0T'
    },
    '1000000000000': {
      'other': '0\u00A0NT'
    },
    '10000000000000': {
      'other': '00\u00A0NT'
    },
    '100000000000000': {
      'other': '000\u00A0NT'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 ngh\u00ECn'
    },
    '10000': {
      'other': '00 ngh\u00ECn'
    },
    '100000': {
      'other': '000 ngh\u00ECn'
    },
    '1000000': {
      'other': '0 tri\u1EC7u'
    },
    '10000000': {
      'other': '00 tri\u1EC7u'
    },
    '100000000': {
      'other': '000 tri\u1EC7u'
    },
    '1000000000': {
      'other': '0 t\u1EF7'
    },
    '10000000000': {
      'other': '00 t\u1EF7'
    },
    '100000000000': {
      'other': '000 t\u1EF7'
    },
    '1000000000000': {
      'other': '0 ngh\u00ECn t\u1EF7'
    },
    '10000000000000': {
      'other': '00 ngh\u00ECn t\u1EF7'
    },
    '100000000000000': {
      'other': '000 ngh\u00ECn t\u1EF7'
    }
  }
};


/**
 * Compact number formatting symbols for locale vi_VN.
 */
goog.i18n.CompactNumberFormatSymbols_vi_VN =
    goog.i18n.CompactNumberFormatSymbols_vi;


/**
 * Compact number formatting symbols for locale zh.
 */
goog.i18n.CompactNumberFormatSymbols_zh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0\u5343'
    },
    '10000': {
      'other': '0\u4E07'
    },
    '100000': {
      'other': '00\u4E07'
    },
    '1000000': {
      'other': '000\u4E07'
    },
    '10000000': {
      'other': '0000\u4E07'
    },
    '100000000': {
      'other': '0\u4EBF'
    },
    '1000000000': {
      'other': '00\u4EBF'
    },
    '10000000000': {
      'other': '000\u4EBF'
    },
    '100000000000': {
      'other': '0000\u4EBF'
    },
    '1000000000000': {
      'other': '0\u5146'
    },
    '10000000000000': {
      'other': '00\u5146'
    },
    '100000000000000': {
      'other': '000\u5146'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0\u5343'
    },
    '10000': {
      'other': '0\u4E07'
    },
    '100000': {
      'other': '00\u4E07'
    },
    '1000000': {
      'other': '000\u4E07'
    },
    '10000000': {
      'other': '0000\u4E07'
    },
    '100000000': {
      'other': '0\u4EBF'
    },
    '1000000000': {
      'other': '00\u4EBF'
    },
    '10000000000': {
      'other': '000\u4EBF'
    },
    '100000000000': {
      'other': '0000\u4EBF'
    },
    '1000000000000': {
      'other': '0\u5146'
    },
    '10000000000000': {
      'other': '00\u5146'
    },
    '100000000000000': {
      'other': '000\u5146'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_CN.
 */
goog.i18n.CompactNumberFormatSymbols_zh_CN =
    goog.i18n.CompactNumberFormatSymbols_zh;


/**
 * Compact number formatting symbols for locale zh_HK.
 */
goog.i18n.CompactNumberFormatSymbols_zh_HK = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u5343'
    },
    '10000': {
      'other': '0\u842C'
    },
    '100000': {
      'other': '00\u842C'
    },
    '1000000': {
      'other': '000\u842C'
    },
    '10000000': {
      'other': '0000\u842C'
    },
    '100000000': {
      'other': '0\u5104'
    },
    '1000000000': {
      'other': '00\u5104'
    },
    '10000000000': {
      'other': '000\u5104'
    },
    '100000000000': {
      'other': '0000\u5104'
    },
    '1000000000000': {
      'other': '0\u5146'
    },
    '10000000000000': {
      'other': '00\u5146'
    },
    '100000000000000': {
      'other': '000\u5146'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_Hans_CN.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hans_CN =
    goog.i18n.CompactNumberFormatSymbols_zh;


/**
 * Compact number formatting symbols for locale zh_TW.
 */
goog.i18n.CompactNumberFormatSymbols_zh_TW = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 \u5343'
    },
    '10000': {
      'other': '0\u842C'
    },
    '100000': {
      'other': '00\u842C'
    },
    '1000000': {
      'other': '000\u842C'
    },
    '10000000': {
      'other': '0000\u842C'
    },
    '100000000': {
      'other': '0\u5104'
    },
    '1000000000': {
      'other': '00\u5104'
    },
    '10000000000': {
      'other': '000\u5104'
    },
    '100000000000': {
      'other': '0000\u5104'
    },
    '1000000000000': {
      'other': '0\u5146'
    },
    '10000000000000': {
      'other': '00\u5146'
    },
    '100000000000000': {
      'other': '000\u5146'
    }
  }
};


/**
 * Compact number formatting symbols for locale zu.
 */
goog.i18n.CompactNumberFormatSymbols_zu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 inkulungwane'
    },
    '10000': {
      'other': '00 inkulungwane'
    },
    '100000': {
      'other': '000 inkulungwane'
    },
    '1000000': {
      'other': '0 isigidi'
    },
    '10000000': {
      'other': '00 isigidi'
    },
    '100000000': {
      'other': '000 isigidi'
    },
    '1000000000': {
      'other': '0 isigidi sezigidi'
    },
    '10000000000': {
      'other': '00 isigidi sezigidi'
    },
    '100000000000': {
      'other': '000 isigidi sezigidi'
    },
    '1000000000000': {
      'other': '0 isigidintathu'
    },
    '10000000000000': {
      'other': '00 isigidintathu'
    },
    '100000000000000': {
      'other': '000 isigidintathu'
    }
  }
};


/**
 * Compact number formatting symbols for locale zu_ZA.
 */
goog.i18n.CompactNumberFormatSymbols_zu_ZA =
    goog.i18n.CompactNumberFormatSymbols_zu;


/**
 * Selected compact number formatting symbols by locale.
 */
goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;

if (goog.LOCALE == 'af') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_af;
}

if (goog.LOCALE == 'af_ZA' || goog.LOCALE == 'af-ZA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_af;
}

if (goog.LOCALE == 'am') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_am;
}

if (goog.LOCALE == 'am_ET' || goog.LOCALE == 'am-ET') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_am;
}

if (goog.LOCALE == 'ar') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar;
}

if (goog.LOCALE == 'ar_001' || goog.LOCALE == 'ar-001') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar;
}

if (goog.LOCALE == 'bg') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bg;
}

if (goog.LOCALE == 'bg_BG' || goog.LOCALE == 'bg-BG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bg;
}

if (goog.LOCALE == 'bn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bn;
}

if (goog.LOCALE == 'bn_BD' || goog.LOCALE == 'bn-BD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bn;
}

if (goog.LOCALE == 'br') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_br;
}

if (goog.LOCALE == 'br_FR' || goog.LOCALE == 'br-FR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_br;
}

if (goog.LOCALE == 'ca') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca;
}

if (goog.LOCALE == 'ca_AD' || goog.LOCALE == 'ca-AD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca;
}

if (goog.LOCALE == 'ca_ES' || goog.LOCALE == 'ca-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca;
}

if (goog.LOCALE == 'ca_FR' || goog.LOCALE == 'ca-FR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca;
}

if (goog.LOCALE == 'ca_IT' || goog.LOCALE == 'ca-IT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca;
}

if (goog.LOCALE == 'chr') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_chr;
}

if (goog.LOCALE == 'chr_US' || goog.LOCALE == 'chr-US') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_chr;
}

if (goog.LOCALE == 'cs') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cs;
}

if (goog.LOCALE == 'cs_CZ' || goog.LOCALE == 'cs-CZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cs;
}

if (goog.LOCALE == 'cy') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cy;
}

if (goog.LOCALE == 'cy_GB' || goog.LOCALE == 'cy-GB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cy;
}

if (goog.LOCALE == 'da') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_da;
}

if (goog.LOCALE == 'da_DK' || goog.LOCALE == 'da-DK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_da;
}

if (goog.LOCALE == 'da_GL' || goog.LOCALE == 'da-GL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_da;
}

if (goog.LOCALE == 'de') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de;
}

if (goog.LOCALE == 'de_AT' || goog.LOCALE == 'de-AT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_AT;
}

if (goog.LOCALE == 'de_BE' || goog.LOCALE == 'de-BE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de;
}

if (goog.LOCALE == 'de_CH' || goog.LOCALE == 'de-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_CH;
}

if (goog.LOCALE == 'de_DE' || goog.LOCALE == 'de-DE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de;
}

if (goog.LOCALE == 'de_LU' || goog.LOCALE == 'de-LU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de;
}

if (goog.LOCALE == 'el') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_el;
}

if (goog.LOCALE == 'el_GR' || goog.LOCALE == 'el-GR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_el;
}

if (goog.LOCALE == 'en') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_001' || goog.LOCALE == 'en-001') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_AS' || goog.LOCALE == 'en-AS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_AU' || goog.LOCALE == 'en-AU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_AU;
}

if (goog.LOCALE == 'en_DG' || goog.LOCALE == 'en-DG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_Dsrt_US' || goog.LOCALE == 'en-Dsrt-US') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_FM' || goog.LOCALE == 'en-FM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_GB' || goog.LOCALE == 'en-GB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GB;
}

if (goog.LOCALE == 'en_GU' || goog.LOCALE == 'en-GU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_IE' || goog.LOCALE == 'en-IE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_IE;
}

if (goog.LOCALE == 'en_IN' || goog.LOCALE == 'en-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_IN;
}

if (goog.LOCALE == 'en_IO' || goog.LOCALE == 'en-IO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_MH' || goog.LOCALE == 'en-MH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_MP' || goog.LOCALE == 'en-MP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_PR' || goog.LOCALE == 'en-PR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_PW' || goog.LOCALE == 'en-PW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_SG' || goog.LOCALE == 'en-SG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SG;
}

if (goog.LOCALE == 'en_TC' || goog.LOCALE == 'en-TC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_UM' || goog.LOCALE == 'en-UM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_US' || goog.LOCALE == 'en-US') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_VG' || goog.LOCALE == 'en-VG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_VI' || goog.LOCALE == 'en-VI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_ZA' || goog.LOCALE == 'en-ZA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_ZA;
}

if (goog.LOCALE == 'en_ZW' || goog.LOCALE == 'en-ZW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en;
}

if (goog.LOCALE == 'es') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es;
}

if (goog.LOCALE == 'es_419' || goog.LOCALE == 'es-419') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_419;
}

if (goog.LOCALE == 'es_EA' || goog.LOCALE == 'es-EA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es;
}

if (goog.LOCALE == 'es_ES' || goog.LOCALE == 'es-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es;
}

if (goog.LOCALE == 'es_IC' || goog.LOCALE == 'es-IC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es;
}

if (goog.LOCALE == 'et') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_et;
}

if (goog.LOCALE == 'et_EE' || goog.LOCALE == 'et-EE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_et;
}

if (goog.LOCALE == 'eu') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_eu;
}

if (goog.LOCALE == 'eu_ES' || goog.LOCALE == 'eu-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_eu;
}

if (goog.LOCALE == 'fa') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fa;
}

if (goog.LOCALE == 'fa_IR' || goog.LOCALE == 'fa-IR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fa;
}

if (goog.LOCALE == 'fi') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fi;
}

if (goog.LOCALE == 'fi_FI' || goog.LOCALE == 'fi-FI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fi;
}

if (goog.LOCALE == 'fil') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fil;
}

if (goog.LOCALE == 'fil_PH' || goog.LOCALE == 'fil-PH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fil;
}

if (goog.LOCALE == 'fr') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_BL' || goog.LOCALE == 'fr-BL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_CA' || goog.LOCALE == 'fr-CA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CA;
}

if (goog.LOCALE == 'fr_FR' || goog.LOCALE == 'fr-FR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_GF' || goog.LOCALE == 'fr-GF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_GP' || goog.LOCALE == 'fr-GP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_MC' || goog.LOCALE == 'fr-MC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_MF' || goog.LOCALE == 'fr-MF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_MQ' || goog.LOCALE == 'fr-MQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_PM' || goog.LOCALE == 'fr-PM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_RE' || goog.LOCALE == 'fr-RE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_YT' || goog.LOCALE == 'fr-YT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr;
}

if (goog.LOCALE == 'gl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gl;
}

if (goog.LOCALE == 'gl_ES' || goog.LOCALE == 'gl-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gl;
}

if (goog.LOCALE == 'gsw') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gsw;
}

if (goog.LOCALE == 'gsw_CH' || goog.LOCALE == 'gsw-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gsw;
}

if (goog.LOCALE == 'gsw_LI' || goog.LOCALE == 'gsw-LI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gsw;
}

if (goog.LOCALE == 'gu') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gu;
}

if (goog.LOCALE == 'gu_IN' || goog.LOCALE == 'gu-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gu;
}

if (goog.LOCALE == 'haw') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_haw;
}

if (goog.LOCALE == 'haw_US' || goog.LOCALE == 'haw-US') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_haw;
}

if (goog.LOCALE == 'he') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_he;
}

if (goog.LOCALE == 'he_IL' || goog.LOCALE == 'he-IL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_he;
}

if (goog.LOCALE == 'hi') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hi;
}

if (goog.LOCALE == 'hi_IN' || goog.LOCALE == 'hi-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hi;
}

if (goog.LOCALE == 'hr') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hr;
}

if (goog.LOCALE == 'hr_HR' || goog.LOCALE == 'hr-HR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hr;
}

if (goog.LOCALE == 'hu') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hu;
}

if (goog.LOCALE == 'hu_HU' || goog.LOCALE == 'hu-HU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hu;
}

if (goog.LOCALE == 'id') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_id;
}

if (goog.LOCALE == 'id_ID' || goog.LOCALE == 'id-ID') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_id;
}

if (goog.LOCALE == 'in') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_in;
}

if (goog.LOCALE == 'is') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_is;
}

if (goog.LOCALE == 'is_IS' || goog.LOCALE == 'is-IS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_is;
}

if (goog.LOCALE == 'it') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_it;
}

if (goog.LOCALE == 'it_IT' || goog.LOCALE == 'it-IT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_it;
}

if (goog.LOCALE == 'it_SM' || goog.LOCALE == 'it-SM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_it;
}

if (goog.LOCALE == 'iw') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_iw;
}

if (goog.LOCALE == 'ja') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ja;
}

if (goog.LOCALE == 'ja_JP' || goog.LOCALE == 'ja-JP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ja;
}

if (goog.LOCALE == 'kn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kn;
}

if (goog.LOCALE == 'kn_IN' || goog.LOCALE == 'kn-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kn;
}

if (goog.LOCALE == 'ko') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ko;
}

if (goog.LOCALE == 'ko_KR' || goog.LOCALE == 'ko-KR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ko;
}

if (goog.LOCALE == 'ln') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ln;
}

if (goog.LOCALE == 'ln_CD' || goog.LOCALE == 'ln-CD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ln;
}

if (goog.LOCALE == 'lt') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lt;
}

if (goog.LOCALE == 'lt_LT' || goog.LOCALE == 'lt-LT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lt;
}

if (goog.LOCALE == 'lv') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lv;
}

if (goog.LOCALE == 'lv_LV' || goog.LOCALE == 'lv-LV') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lv;
}

if (goog.LOCALE == 'ml') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ml;
}

if (goog.LOCALE == 'ml_IN' || goog.LOCALE == 'ml-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ml;
}

if (goog.LOCALE == 'mr') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mr;
}

if (goog.LOCALE == 'mr_IN' || goog.LOCALE == 'mr-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mr;
}

if (goog.LOCALE == 'ms') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ms;
}

if (goog.LOCALE == 'ms_Latn_MY' || goog.LOCALE == 'ms-Latn-MY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ms;
}

if (goog.LOCALE == 'mt') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mt;
}

if (goog.LOCALE == 'mt_MT' || goog.LOCALE == 'mt-MT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mt;
}

if (goog.LOCALE == 'nb') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nb;
}

if (goog.LOCALE == 'nb_NO' || goog.LOCALE == 'nb-NO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nb;
}

if (goog.LOCALE == 'nb_SJ' || goog.LOCALE == 'nb-SJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nb;
}

if (goog.LOCALE == 'nl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl;
}

if (goog.LOCALE == 'nl_NL' || goog.LOCALE == 'nl-NL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl;
}

if (goog.LOCALE == 'no') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_no;
}

if (goog.LOCALE == 'or') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_or;
}

if (goog.LOCALE == 'or_IN' || goog.LOCALE == 'or-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_or;
}

if (goog.LOCALE == 'pl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pl;
}

if (goog.LOCALE == 'pl_PL' || goog.LOCALE == 'pl-PL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pl;
}

if (goog.LOCALE == 'pt') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt;
}

if (goog.LOCALE == 'pt_BR' || goog.LOCALE == 'pt-BR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt;
}

if (goog.LOCALE == 'pt_PT' || goog.LOCALE == 'pt-PT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_PT;
}

if (goog.LOCALE == 'ro') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ro;
}

if (goog.LOCALE == 'ro_RO' || goog.LOCALE == 'ro-RO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ro;
}

if (goog.LOCALE == 'ru') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru;
}

if (goog.LOCALE == 'ru_RU' || goog.LOCALE == 'ru-RU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru;
}

if (goog.LOCALE == 'sk') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sk;
}

if (goog.LOCALE == 'sk_SK' || goog.LOCALE == 'sk-SK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sk;
}

if (goog.LOCALE == 'sl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sl;
}

if (goog.LOCALE == 'sl_SI' || goog.LOCALE == 'sl-SI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sl;
}

if (goog.LOCALE == 'sq') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sq;
}

if (goog.LOCALE == 'sq_AL' || goog.LOCALE == 'sq-AL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sq;
}

if (goog.LOCALE == 'sr') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr;
}

if (goog.LOCALE == 'sr_Cyrl_RS' || goog.LOCALE == 'sr-Cyrl-RS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr;
}

if (goog.LOCALE == 'sv') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sv;
}

if (goog.LOCALE == 'sv_SE' || goog.LOCALE == 'sv-SE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sv;
}

if (goog.LOCALE == 'sw') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sw;
}

if (goog.LOCALE == 'sw_TZ' || goog.LOCALE == 'sw-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sw;
}

if (goog.LOCALE == 'ta') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ta;
}

if (goog.LOCALE == 'ta_IN' || goog.LOCALE == 'ta-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ta;
}

if (goog.LOCALE == 'te') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_te;
}

if (goog.LOCALE == 'te_IN' || goog.LOCALE == 'te-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_te;
}

if (goog.LOCALE == 'th') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_th;
}

if (goog.LOCALE == 'th_TH' || goog.LOCALE == 'th-TH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_th;
}

if (goog.LOCALE == 'tl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tl;
}

if (goog.LOCALE == 'tr') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tr;
}

if (goog.LOCALE == 'tr_TR' || goog.LOCALE == 'tr-TR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tr;
}

if (goog.LOCALE == 'uk') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uk;
}

if (goog.LOCALE == 'uk_UA' || goog.LOCALE == 'uk-UA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uk;
}

if (goog.LOCALE == 'ur') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ur;
}

if (goog.LOCALE == 'ur_PK' || goog.LOCALE == 'ur-PK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ur;
}

if (goog.LOCALE == 'vi') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vi;
}

if (goog.LOCALE == 'vi_VN' || goog.LOCALE == 'vi-VN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vi;
}

if (goog.LOCALE == 'zh') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh;
}

if (goog.LOCALE == 'zh_CN' || goog.LOCALE == 'zh-CN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh;
}

if (goog.LOCALE == 'zh_HK' || goog.LOCALE == 'zh-HK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_HK;
}

if (goog.LOCALE == 'zh_Hans_CN' || goog.LOCALE == 'zh-Hans-CN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh;
}

if (goog.LOCALE == 'zh_TW' || goog.LOCALE == 'zh-TW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_TW;
}

if (goog.LOCALE == 'zu') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zu;
}

if (goog.LOCALE == 'zu_ZA' || goog.LOCALE == 'zu-ZA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zu;
}

