import distutils.core
import os


# Recursively collect all files in a given directory.
def rcollect(path):
    if not os.path.exists(path):
        raise IOError("%s does not exist" % (path))
    return sum(map(lambda x: map(lambda y: x[0] + "/" + y, x[2]),
                   os.walk(path)),
               [])


def copy_with_dir(files, base):
    return [(base + "/" + os.path.dirname(f), [f]) for f in files]

# Build up a list of extra files to install.
#
# Include the example configuration files.
data_files_list = [("share/tangelo/conf", ["conf/tangelo.conf.global",
                                           "conf/tangelo.conf.local"]),
                   ("share/tangelo/data", ["data/get-flickr-data.py"]),
                   ("share/tangelo", ["images/tangelo.ico"])]

# Include the website base files, excluding generated tests and compiled python
# files.
web_files = filter(lambda f: not (f.startswith("web/tests") or f.endswith(".pyc")),
                   rcollect("web"))
data_files_list += copy_with_dir(web_files, "share/tangelo")

# Create the package.
distutils.core.setup(name="tangelo",
                     version="0.6",
                     author="Kitware, Inc.",
                     author_email="tangelo-users@public.kitware.com",
                     url="http://kitware.github.io/tangelo",
                     packages=["tangelo",
                               "tangelo.autobahn",
                               "tangelo.ws4py",
                               "tangelo.ws4py.server"],
                     scripts=["bin/tangelo",
                              "bin/tangelo-passwd",
                              "bin/vtkweb-launcher.py"],
                     data_files=data_files_list,
                     description="Tangelo Web Framework",
                     long_description="Tangelo is a Python-based web " +
                     "server framework bundled with clientside tools " +
                     "to help you supercharge your web applications " +
                     "with the power of Python",
                     license="Apache License, Version 2.0",
                     platforms=["Linux", "OS X", "Windows"],
                     install_requires=["cherrypy >= 3.2",
                                       "Twisted >= 13.2"])
