#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from distutils.core import setup

setup(
    name = "tarball69_mass_rename",
    version = "1.0",
    description = "mass rename - massive renaming of same type files in a directory",
    author = "Raphaël SEBAN",
    author_email = "motus@laposte.net",
    maintainer = "Raphaël SEBAN",
    maintainer_email = "motus@laposte.net",
    url = "https://github.com/tarball69/mass_rename",
    download_url = "https://github.com/tarball69/mass_rename",
    keywords = ["console", "file", "utility", "rename"],
    classifiers = [
        "Development Status :: 6 - Mature",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: End Users/Desktop",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved",
        "License :: OSI Approved :: GNU General Public License (GPL)",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Natural Language :: English",
        "Operating System :: POSIX",
        "Operating System :: POSIX :: Linux",
        "Operating System :: Unix",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.2",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4",
        "Topic :: Utilities",
    ],
    license = """
Licensed under GNU General Public License v3.
    """,
    long_description = """
mass_rename
===========

Introduction
------------

**mass_rename** is a very simple console file utility written in
**Python3.2+** for UNIX/Linux machines and designed to **massively
rename files of same extension** in a given directory.

**mass_rename2** is simply a **Python2.7+** port of **mass_rename**.

This utility was originally programmed to massively rename my
holidays photos and it has kept some default values this way *e.g.*
default file ext is still `.jpg`.

As for each console utility, you may type in a shell console:

    $ python3 mass_rename.py --help

in order to get more detail about internal features and args.

Notice: I've tested *mass_rename* on a **MS-Windows** machine and it
reported to **work OK** when I used it into the working directory,
but I definitely don't know *how to set up* a python script as a
system-wide executable on MS-Windows platforms, I'm sorry.

Development status
------------------

    Development Status :: 6 - Mature

Software has been:

* Linux:

    * TESTED OK for all distros;

* macOS:

    * NOT YET TESTED;

* MS-Windows:

    * PARTIALLY TESTED OK on Win 8 only;

Installation
------------

Simply copy `mass_rename.py` or `mass_rename2.py` (if you use
Python2.7+) into `/usr/bin` directory onto your UNIX/Linux machine
and ensure it has the executable sticky bit switched on *e.g.* in a
shell console:

    $ sudo cp mass_rename.py /usr/bin/mass_rename

    $ sudo chmod +x /usr/bin/mass_rename

    $ mass_rename --help

That's all, folks!

Bug report
----------

In order to **track bugs** and fix them correctly, we'd like to hear
from you.

If you encountered **any problem** during the use of `mass_rename`
utility software, please leave us a comment and tell us:

* environment:
    * which platform? (Windows, macOS, Linux)
    * which Python version? (2.7+, 3.2+)
    * which **mass_rename** version?

* traceback (optional):
    * could you please copy/paste the console error text?
    * could you tell us few words about what happened?

**Whatever happened**, we'd like to know about it.

You will find an open issue **"It did *NOT* work for me!"** at:

https://github.com/tarball69/mass_rename/issues/1

Thank you for your contributions.

"""
)
