# -*-coding:utf-8 -*
#
# TARTES, Copyright (c) 2014, Quentin Libois, Picard Ghislain 
# All rights reserved. 
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# 


# functions to compute refractive index of ice and impurities at wavelengths given in argument
# wavelength is in m

from numpy import array,interp,log,exp,pi

def refice(wavelengths):
    """return real and imag part of ice refractive index. wavelengths (m) from Warren (2008)"""
    return interp(wavelengths*1e9,wl,refice_r),exp(interp(log(wavelengths*1e9),log(wl),log(refice_i)))

# wl in nm corresponding to the index below
wl=1000*array([
  1.990E-001,  2.010E-001,  2.019E-001,  2.100E-001,  2.500E-001,  3.000E-001,  3.500E-001,  3.900E-001,  4.000E-001,  4.100E-001 ,  4.200E-001,  4.300E-001,  4.400E-001,  4.500E-001,  4.600E-001,  4.700E-001,  4.800E-001,  4.900E-001,  5.000E-001,  5.100E-001 ,  5.200E-001,  5.300E-001,  5.400E-001,  5.500E-001,  5.600E-001,  5.700E-001,  5.800E-001,  5.900E-001,  6.000E-001,  6.100E-001 ,  6.200E-001,  6.300E-001,  6.400E-001,  6.500E-001,  6.600E-001,  6.700E-001,  6.800E-001,  6.900E-001,  7.000E-001,  7.100E-001 ,  7.200E-001,  7.300E-001,  7.400E-001,  7.500E-001,  7.600E-001,  7.700E-001,  7.800E-001,  7.900E-001,  8.000E-001,  8.100E-001 ,  8.200E-001,  8.300E-001,  8.400E-001,  8.500E-001,  8.600E-001,  8.700E-001,  8.800E-001,  8.900E-001,  9.000E-001,  9.100E-001 ,  9.200E-001,  9.300E-001,  9.400E-001,  9.500E-001,  9.600E-001,  9.700E-001,  9.800E-001,  9.900E-001,  1.000E+000,  1.010E+000 ,  1.020E+000,  1.030E+000,  1.040E+000,  1.050E+000,  1.060E+000,  1.070E+000,  1.080E+000,  1.090E+000,  1.100E+000,  1.110E+000 ,  1.120E+000,  1.130E+000,  1.140E+000,  1.150E+000,  1.160E+000,  1.170E+000,  1.180E+000,  1.190E+000,  1.200E+000,  1.210E+000 ,  1.220E+000,  1.230E+000,  1.240E+000,  1.250E+000,  1.260E+000,  1.270E+000,  1.280E+000,  1.290E+000,  1.300E+000,  1.310E+000 ,  1.320E+000,  1.330E+000,  1.340E+000,  1.350E+000,  1.360E+000,  1.370E+000,  1.380E+000,  1.390E+000,  1.400E+000,  1.410E+000 ,  1.420E+000,  1.430E+000,  1.440E+000,  1.449E+000,  1.460E+000,  1.471E+000,  1.481E+000,  1.493E+000,  1.504E+000,  1.515E+000 ,  1.527E+000,  1.538E+000,  1.563E+000,  1.587E+000,  1.613E+000,  1.650E+000,  1.680E+000,  1.700E+000,  1.730E+000,  1.760E+000 ,  1.800E+000,  1.830E+000,  1.840E+000,  1.850E+000,  1.855E+000,  1.860E+000,  1.870E+000,  1.890E+000,  1.905E+000,  1.923E+000 ,  1.942E+000,  1.961E+000,  1.980E+000,  2.000E+000,  2.020E+000,  2.041E+000,  2.062E+000,  2.083E+000,  2.105E+000,  2.130E+000 ,  2.150E+000,  2.170E+000,  2.190E+000,  2.220E+000,  2.240E+000,  2.245E+000,  2.250E+000,  2.260E+000,  2.270E+000,  2.290E+000 ,  2.310E+000,  2.330E+000,  2.350E+000,  2.370E+000,  2.390E+000,  2.410E+000,  2.430E+000,  2.460E+000,  2.500E+000,  2.520E+000 ,  2.550E+000,  2.565E+000,  2.580E+000,  2.590E+000,  2.600E+000,  2.620E+000,  2.675E+000,  2.725E+000,  2.778E+000,  2.817E+000 ,  2.833E+000,  2.849E+000,  2.865E+000,  2.882E+000,  2.899E+000,  2.915E+000,  2.933E+000,  2.950E+000,  2.967E+000,  2.985E+000 ,  3.003E+000])

# real part of the ice refractive index
refice_r=array([1.3943, 1.3914 , 1.3901, 1.3801, 1.3509, 1.3339, 1.3249, 1.3203, 1.3194, 1.3185, 1.3177, 1.3170, 1.3163, 1.3157, 1.3151, 1.3145, 1.3140, 1.3135, 1.3130, 1.3126, 1.3121, 1.3117, 1.3114, 1.3110, 1.3106, 1.3103, 1.3100, 1.3097, 1.3094, 1.3091, 1.3088, 1.3085, 1.3083, 1.3080, 1.3078, 1.3076, 1.3073, 1.3071, 1.3069, 1.3067, 1.3065, 1.3062, 1.3060, 1.3059, 1.3057, 1.3055, 1.3053, 1.3051, 1.3049, 1.3047, 1.3046, 1.3044, 1.3042, 1.3040, 1.3039, 1.3037, 1.3035, 1.3033, 1.3032, 1.3030, 1.3028, 1.3027, 1.3025, 1.3023, 1.3022, 1.3020, 1.3019, 1.3017, 1.3015, 1.3014, 1.3012, 1.3010, 1.3009, 1.3007, 1.3005, 1.3003, 1.3002, 1.3000, 1.2998, 1.2997, 1.2995, 1.2993, 1.2991, 1.2990, 1.2988, 1.2986, 1.2984, 1.2982, 1.2980, 1.2979, 1.2977, 1.2975, 1.2973, 1.2971, 1.2969, 1.2967, 1.2965, 1.2963, 1.2961, 1.2959, 1.2957, 1.2955, 1.2953, 1.2951, 1.2949, 1.2946, 1.2944, 1.2941, 1.2939, 1.2937, 1.2934, 1.2931, 1.2929, 1.2927, 1.2924, 1.2921, 1.2920, 1.2918, 1.2916, 1.2914, 1.2912, 1.2909, 1.2903, 1.2897, 1.2890, 1.2879, 1.2870, 1.2863, 1.2853, 1.2843, 1.2828, 1.2816, 1.2811, 1.2807, 1.2805, 1.2802, 1.2797, 1.2788, 1.2780, 1.2771, 1.2762, 1.2756, 1.2750, 1.2744, 1.2736, 1.2728, 1.2718, 1.2707, 1.2694, 1.2677, 1.2663, 1.2648, 1.2633, 1.2609, 1.2591, 1.2587, 1.2582, 1.2573, 1.2564, 1.2545, 1.2525, 1.2504, 1.2482, 1.2459, 1.2435, 1.2409, 1.2382, 1.2337, 1.2270, 1.2232, 1.2169, 1.2135, 1.2097, 1.2071, 1.2043, 1.1983, 1.1776, 1.1507, 1.1083, 1.0657, 1.0453, 1.0236, 1.0001, 0.9747, 0.9563, 0.9538, 0.9678, 0.9873, 1.0026, 1.0180, 1.0390])

# imaginary part of the ice refractive index
refice_i=array([9.565E-011, 3.249E-011, 2.0E-011  , 2.0E-011  , 2.0E-011  , 2.0E-011  , 2.0E-011  , 2.0E-011  , 2.365E-011, 2.669E-011, 3.135E-011, 4.140E-011, 6.268E-011, 9.239E-011, 1.325E-010, 1.956E-010, 2.861E-010, 4.172E-010, 5.889E-010, 8.036E-010, 1.076E-009, 1.409E-009, 1.813E-009, 2.289E-009, 2.839E-009, 3.461E-009, 4.159E-009, 4.930E-009, 5.730E-009, 6.890E-009, 8.580E-009, 1.040E-008, 1.220E-008, 1.430E-008, 1.660E-008, 1.890E-008, 2.090E-008, 2.400E-008, 2.900E-008, 3.440E-008, 4.030E-008, 4.300E-008, 4.920E-008, 5.870E-008, 7.080E-008, 8.580E-008, 1.020E-007, 1.180E-007, 1.340E-007, 1.400E-007, 1.430E-007, 1.450E-007, 1.510E-007, 1.830E-007, 2.150E-007, 2.650E-007, 3.350E-007, 3.920E-007, 4.200E-007, 4.440E-007, 4.740E-007, 5.110E-007, 5.530E-007, 6.020E-007, 7.550E-007, 9.260E-007, 1.120E-006, 1.330E-006, 1.620E-006, 2.000E-006, 2.250E-006, 2.330E-006, 2.330E-006, 2.170E-006, 1.960E-006, 1.810E-006, 1.740E-006, 1.730E-006, 1.700E-006, 1.760E-006, 1.820E-006, 2.040E-006, 2.250E-006, 2.290E-006, 3.040E-006, 3.840E-006, 4.770E-006, 5.760E-006, 6.710E-006, 8.660E-006, 1.020E-005, 1.130E-005, 1.220E-005, 1.290E-005, 1.320E-005, 1.350E-005, 1.330E-005, 1.320E-005, 1.320E-005, 1.310E-005, 1.320E-005, 1.320E-005, 1.340E-005, 1.390E-005, 1.420E-005, 1.480E-005, 1.580E-005, 1.740E-005, 1.980E-005, 3.442E-005, 5.959E-005, 1.028E-004, 1.516E-004, 2.030E-004, 2.942E-004, 3.987E-004, 4.941E-004, 5.532E-004, 5.373E-004, 5.143E-004, 4.908E-004, 4.594E-004, 3.858E-004, 3.105E-004, 2.659E-004, 2.361E-004, 2.046E-004, 1.875E-004, 1.650E-004, 1.522E-004, 1.411E-004, 1.302E-004, 1.310E-004, 1.339E-004, 1.377E-004, 1.432E-004, 1.632E-004, 2.566E-004, 4.081E-004, 7.060E-004, 1.108E-003, 1.442E-003, 1.614E-003, 1.640E-003, 1.566E-003, 1.458E-003, 1.267E-003, 1.023E-003, 7.586E-004, 5.255E-004, 4.025E-004, 3.235E-004, 2.707E-004, 2.228E-004, 2.037E-004, 2.026E-004, 2.035E-004, 2.078E-004, 2.171E-004, 2.538E-004, 3.138E-004, 3.858E-004, 4.591E-004, 5.187E-004, 5.605E-004, 5.956E-004, 6.259E-004, 6.820E-004, 7.530E-004, 7.685E-004, 7.647E-004, 7.473E-004, 7.392E-004, 7.437E-004, 7.543E-004, 8.059E-004, 1.367E-003, 3.508E-003, 1.346E-002, 3.245E-002, 4.572E-002, 6.287E-002, 8.548E-002, 1.198E-001, 1.690E-001, 2.210E-001, 2.760E-001, 3.120E-001, 3.470E-001, 3.880E-001, 4.380E-001])
