__version__ = VERSION = version = "0.0.6"

import argparse
import sys
import json

from .parser import Parser
from .lexer import Lexer

def parse(script, debug=0):
    return Parser().parse(script, debug=debug)

def main():
    parser = argparse.ArgumentParser(prog='taskscript',
                                     add_help=True,
                                     formatter_class=argparse.RawDescriptionHelpFormatter,
                                     epilog="""Learn more at \033[92mhttp://dev.orderbliss.com/tasks\033[0m""")
    parser.add_argument('--version', action='version', version='Task Script '+version+" - http://dev.orderbliss.com/tasks")
    parser.add_argument('--verbose', '-v', action="store_true", help="Verbose mode")
    parser.add_argument('--lexer', '-l', action="store_true", help="Show lexer tokens")
    parser.add_argument('--parse', '-p', action="store_true", help="Parse only, dont show json dump")
    parser.add_argument('--silent', '-s', action="store_true", help="Silent mode. Return syntax errors only.")
    parser.add_argument('file', nargs="?", help="File to parse")

    if len(sys.argv) == 1:
        parser.print_help()
    else:
        args = parser.parse_args()

        with open(args.file) as f:
            task = f.read()

        if args.lexer:
            print '\033[91m*************************************************\033[0m'
            print "             \033[92mScript Lexer Tokens\033[0m"
            lexer = Lexer()
            lexer.input(task)
            for x, tok in enumerate(lexer.lexer):
                print tok
            print '\033[91m*************************************************\033[0m'

        result = Parser().parse(task, debug=1 if args.verbose else 0)
        if args.parse:
            if not args.silent:
                print "\033[92mScript syntax passed!\033[0m  " + "\033[32m"+u"\u2713"+"\033[39m"
        else:
            if not args.silent:
                print json.dumps(result.json(), indent=2, separators=(',', ': '))

if __name__ == '__main__':
    main()
