/*
 * Decompiled with CFR 0.152.
 */
package ext.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;

public class ZAppEnv {
    private static final Properties properties = new Properties();
    private static File iniFile = null;

    public static void load(String fileNameNoPath) {
        try {
            iniFile = new File(System.getProperty("user.home"), "powerssr.ini");
            if (!iniFile.exists()) {
                FileWriter writer = new FileWriter(iniFile);
                writer.close();
            } else if (!iniFile.canWrite()) {
                throw new IOException("");
            }
            FileInputStream input = new FileInputStream(iniFile);
            properties.load(input);
            input.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Please check file: powerssr.ini in your installation directory, I guess it's read only. If so, please change that to writable!");
            System.exit(-1);
        }
    }

    public static void save(String fileNameNoPath) {
        try {
            FileOutputStream output = new FileOutputStream(iniFile);
            properties.store(output, "powerssr ini file");
            output.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }
}

