/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import ext.lang.ZIllegalDataException;
import ext.swing.ZButton;
import ext.swing.ZDialogModel;
import ext.swing.ZFontColorDialog;
import ext.swing.ZLabelCellRenderer;
import ext.swing.ZLabelPane;
import ext.swing.ZTable1DPlot;
import ext.swing.ZTable2DPlot;
import ext.swing.ZTableCollectionDialog;
import ext.swing.ZTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;

public class ZTableViewer
extends ZLabelPane {
    private ZDialogModel optionModel = null;
    private ZFontColorDialog optionDialog = null;
    private ZTableCollectionDialog collectionDialog = null;
    private ZLabelCellRenderer renderer = new ZLabelCellRenderer();
    private int pmSize = 0;
    private JPanel panel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane LP_table = new JScrollPane();
    protected JTable table = new JTable();
    protected JToolBar toolBar = new JToolBar();
    private ZButton B_option = new ZButton();
    private ZButton B_copyTo = new ZButton();
    private ZButton B_collect = new ZButton();
    private ZButton B_1DPlot = new ZButton();
    private ZButton B_2DPlot = new ZButton();
    private JPopupMenu PM_copyTo = new JPopupMenu();
    private JMenuItem M_all = new JMenuItem();
    private JMenuItem M_upper = new JMenuItem();
    private JMenuItem M_lower = new JMenuItem();

    public ZTableViewer() {
        try {
            this.jbInit();
            this.optionModel = ZFontColorDialog.createFontColorModel(this.renderer.getFont(), this.renderer.getBackground(), this.renderer.getForeground());
            this.optionDialog = new ZFontColorDialog(this.optionModel);
            this.collectionDialog = new ZTableCollectionDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void set(String[] header, String[][] data) {
        this.table.setModel(new ZTableModel(data, header));
        this.setDisplay();
        this.collectionDialog.setTable(this.table);
    }

    public void set(ZTableModel model) {
        this.table.setModel(model);
        this.setDisplay();
        this.collectionDialog.setTable(this.table);
    }

    public void enablePlotting(boolean b) {
        if (b) {
            this.toolBar.add((Component)this.B_1DPlot, null);
            this.toolBar.add((Component)this.B_2DPlot, null);
        } else {
            this.toolBar.remove(this.B_1DPlot);
            this.toolBar.remove(this.B_2DPlot);
        }
    }

    private void setDisplay() {
        TableColumn column = null;
        int count = this.table.getModel().getColumnCount();
        if (count == 1) {
            column = this.table.getColumnModel().getColumn(0);
            column.setCellRenderer(this.renderer);
            column.setPreferredWidth(500);
            return;
        }
        if (count == 2) {
            column = this.table.getColumnModel().getColumn(0);
            column.setCellRenderer(this.renderer);
            column.setPreferredWidth(150);
            column = this.table.getColumnModel().getColumn(1);
            column.setPreferredWidth(400);
            column.setCellRenderer(this.renderer);
            return;
        }
        for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setCellRenderer(this.renderer);
            if (i == 0) {
                column.setPreferredWidth(120);
                column.setMinWidth(80);
                continue;
            }
            column.setPreferredWidth(60);
            column.setMinWidth(40);
        }
    }

    public void clear() {
        this.table.setModel(null);
    }

    public JTable getTable() {
        return this.table;
    }

    public ZTableModel getModel() {
        return (ZTableModel)this.table.getModel();
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.borderLayout1);
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(0);
        this.table.setModel(new ZTableModel());
        this.LP_table.getViewport().setBackground(Color.white);
        this.toolBar.setFloatable(false);
        this.B_option.set("option", "  Set display  ", "set color and font");
        this.B_option.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.B_option_actionPerformed(e);
            }
        });
        this.B_copyTo.set("copyto", "  Copy to clipboard  ", "pastable by EXCEL!");
        this.B_copyTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.B_copyTo_actionPerformed(e);
            }
        });
        this.B_collect.set("collect", "  Collect information  ", "Collect information");
        this.B_collect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.B_collect_actionPerformed(e);
            }
        });
        this.M_all.setText("Copy the whole table");
        this.M_all.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.M_all_actionPerformed(e);
            }
        });
        this.M_upper.setText("Copy upper triangle");
        this.M_upper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.M_upper_actionPerformed(e);
            }
        });
        this.M_lower.setText("Copy lower triangle");
        this.M_lower.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.M_lower_actionPerformed(e);
            }
        });
        this.B_1DPlot.set("1dplot", "  1-D plot  ", "1-dimensional plot");
        this.B_1DPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.plot1D();
            }
        });
        this.B_2DPlot.set("2dplot", "  2-D plot  ", "2-dimensional plot");
        this.B_2DPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTableViewer.this.plot2D();
            }
        });
        this.panel.add((Component)this.LP_table, "Center");
        this.panel.add((Component)this.toolBar, "South");
        this.toolBar.add((Component)this.B_option, null);
        this.toolBar.add((Component)this.B_copyTo, null);
        this.toolBar.add((Component)this.B_collect, null);
        this.LP_table.getViewport().add((Component)this.table, null);
        this.PM_copyTo.add(this.M_all);
        this.PM_copyTo.add(this.M_upper);
        this.PM_copyTo.add(this.M_lower);
        this.pmSize = (int)this.PM_copyTo.getPreferredSize().getHeight();
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 400));
        this.setComponent(this.panel);
    }

    private void B_option_actionPerformed(ActionEvent e) {
        this.optionDialog.showAtCenter();
        if (this.optionDialog.getReturnType()) {
            this.renderer.setFont((Font)this.optionDialog.getModel().getData("font"));
            this.renderer.setColor((Color)this.optionDialog.getModel().getData("foregroundColor"), (Color)this.optionDialog.getModel().getData("backgroundColor"));
            this.setDisplay();
            this.repaint();
        }
    }

    private void B_copyTo_actionPerformed(ActionEvent e) {
        this.PM_copyTo.show((JComponent)e.getSource(), 0, -1 * this.pmSize);
    }

    private void M_all_actionPerformed(ActionEvent e) {
        int i;
        JTextArea ta = new JTextArea();
        int count = this.table.getColumnCount();
        for (i = 0; i < count; ++i) {
            ta.append(String.valueOf(String.valueOf(this.table.getColumnName(i))).concat("\t"));
        }
        ta.append("\n");
        for (i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 0; j < count; ++j) {
                ta.append(String.valueOf(String.valueOf(this.table.getValueAt(i, j))).concat("\t"));
            }
            ta.append("\n");
        }
        ta.selectAll();
        ta.copy();
    }

    private void M_lower_actionPerformed(ActionEvent e) {
        int i;
        if (this.table.getColumnCount() != this.table.getRowCount() + 1) {
            JOptionPane.showMessageDialog(this, "This table is not square matrix. ");
            return;
        }
        JTextArea ta = new JTextArea();
        int count = this.table.getColumnCount();
        for (i = 0; i < count; ++i) {
            ta.append(String.valueOf(String.valueOf(this.table.getColumnName(i))).concat("\t"));
        }
        ta.append("\n");
        for (i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 0; j < i + 2; ++j) {
                ta.append(String.valueOf(String.valueOf(this.table.getValueAt(i, j))).concat("\t"));
            }
            ta.append("\n");
        }
        ta.selectAll();
        ta.copy();
    }

    private void M_upper_actionPerformed(ActionEvent e) {
        int i;
        if (this.table.getColumnCount() != this.table.getRowCount() + 1) {
            JOptionPane.showMessageDialog(this, "This table is not square matrix. ");
            return;
        }
        JTextArea ta = new JTextArea();
        int count = this.table.getColumnCount();
        for (i = 0; i < count; ++i) {
            ta.append(String.valueOf(String.valueOf(this.table.getColumnName(i))).concat("\t"));
        }
        ta.append("\n");
        for (i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 0; j < count; ++j) {
                if (j == 0 || j >= i + 1) {
                    ta.append(String.valueOf(String.valueOf(this.table.getValueAt(i, j))).concat("\t"));
                    continue;
                }
                ta.append("     \t");
            }
            ta.append("\n");
        }
        ta.selectAll();
        ta.copy();
    }

    private void B_collect_actionPerformed(ActionEvent e) {
        this.collectionDialog.showAtCenter();
    }

    private void plot1D() {
        try {
            Class<?> cls = ClassLoader.getSystemClassLoader().loadClass("jclass/chart/BaseChart");
            ZTable1DPlot plotDialog = new ZTable1DPlot();
            ZTableModel model = (ZTableModel)this.table.getModel();
            plotDialog.setData(model.getHeader(), model.getData());
            plotDialog.showAtCenter();
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "this function was disabled in this version.");
            return;
        }
        catch (ZIllegalDataException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    private void plot2D() {
        try {
            ZTable2DPlot plotDialog = new ZTable2DPlot();
            ZTableModel model = (ZTableModel)this.table.getModel();
            plotDialog.setData(model.getHeader(), model.getData());
            plotDialog.showAtCenter();
        }
        catch (ZIllegalDataException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    public static void main(String[] args) {
        ZTableViewer viewer = new ZTableViewer();
        String[] h = new String[]{"ab", "cd"};
        String[][] d = new String[][]{{"a1", "a2"}, {"b1", "b2"}};
        viewer.set(h, d);
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)viewer, "Center");
        frame.pack();
        ((Component)frame).setVisible(true);
    }
}

