/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.PETagsOnPhysicalMapV3;
import net.maizegenetics.dna.map.TagGeneticMappingInfo;
import net.maizegenetics.dna.map.TagMappingInfoV3;
import net.maizegenetics.dna.map.TagsOnGeneticMap;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.dna.tag.SAMUtils;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.util.MultiMemberGZIPInputStream;

public class AnnotateTOPM {
    TagsOnPhysicalMapV3 topm;
    TagMappingInfoV3[][][] tmiBuffers = null;
    boolean[][] bufferLights = null;
    int bufferNum = 2;
    int[] lightCounts;
    int[] bufferStartTagIndex = null;
    int[] bufferTagIndexRange = null;
    int updateBufferCountCutoff;

    public AnnotateTOPM(TagsOnPhysicalMapV3 topm) {
        this.topm = topm;
    }

    public void annotateBestMappingImport(String indexDirS, String predictDirS, TagMappingInfoV3.Aligner priorityAligner) {
        byte[] bestStrand = new byte[this.topm.getTagCount()];
        int[] bestChr = new int[this.topm.getTagCount()];
        int[] bestStartPos = new int[this.topm.getTagCount()];
        int[] bestEndPos = new int[this.topm.getTagCount()];
        byte[] bestDivergence = new byte[this.topm.getTagCount()];
        byte[] bestMapP = new byte[this.topm.getTagCount()];
        byte[] bestDcoP = new byte[this.topm.getTagCount()];
        byte[] multimaps = new byte[this.topm.getTagCount()];
        byte[] bestEvidence = new byte[this.topm.getTagCount()];
        byte[] bestMapIndex = new byte[this.topm.getTagCount()];
        int fileNum = new File(predictDirS).listFiles().length;
        for (int i = 0; i < fileNum; ++i) {
            String predictFileS = String.valueOf(i) + ".out.txt";
            predictFileS = new File(predictDirS, predictFileS).getAbsolutePath();
            String indexFileS = String.valueOf(i) + ".index.txt";
            indexFileS = new File(indexDirS, indexFileS).getAbsolutePath();
            int currentTagIndex = -1;
            try {
                Integer[] mapIndices;
                String temp;
                BufferedReader brp = new BufferedReader(new FileReader(predictFileS), 65536);
                BufferedReader bri = new BufferedReader(new FileReader(indexFileS), 65536);
                for (int j = 0; j < 5; ++j) {
                    brp.readLine();
                }
                bri.readLine();
                ArrayList<Integer> mapIndexList = new ArrayList<Integer>();
                while ((temp = bri.readLine()) != null) {
                    String[] tem = temp.split("\t");
                    int tagIndex = Integer.parseInt(tem[0]);
                    int mapIndex = Integer.parseInt(tem[1]);
                    if (tagIndex != currentTagIndex) {
                        if (currentTagIndex != -1) {
                            mapIndices = mapIndexList.toArray(new Integer[mapIndexList.size()]);
                            this.incorperateBestGeneticMapping(currentTagIndex, mapIndices, brp, bestStrand, bestChr, bestStartPos, bestEndPos, bestDivergence, bestMapP, bestDcoP, bestEvidence, bestMapIndex);
                        }
                        mapIndexList = new ArrayList();
                        currentTagIndex = tagIndex;
                    }
                    mapIndexList.add(mapIndex);
                }
                mapIndices = mapIndexList.toArray(new Integer[mapIndexList.size()]);
                this.incorperateBestGeneticMapping(currentTagIndex, mapIndices, brp, bestStrand, bestChr, bestStartPos, bestEndPos, bestDivergence, bestMapP, bestDcoP, bestEvidence, bestMapIndex);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                System.out.println(currentTagIndex);
                System.exit(0);
            }
        }
        int[] priorityIndex = this.topm.getMappingIndicesOfAligner(priorityAligner);
        int[] alignerStartMapIndex = new int[]{0, 5, 10, 15, 20, 25};
        int[][] alignerIndex = new int[alignerStartMapIndex.length][];
        alignerIndex[0] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.Bowtie2);
        alignerIndex[1] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.BWA);
        alignerIndex[2] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.Blast);
        alignerIndex[3] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.BWAMEM);
        alignerIndex[4] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.PEEnd1);
        alignerIndex[5] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.PEEnd2);
        for (int i = 0; i < this.topm.getTagCount(); ++i) {
            TagMappingInfoV3 tmi;
            if (bestStrand[i] == 0) {
                int numRank0 = this.getNumOfRank0(i, priorityIndex);
                tmi = this.topm.getMappingInfo(i, priorityIndex[0]);
                if (numRank0 == 1) {
                    bestStrand[i] = tmi.strand;
                    bestChr[i] = tmi.chromosome;
                    bestStartPos[i] = tmi.startPosition;
                    bestEndPos[i] = tmi.endPosition;
                    bestDivergence[i] = tmi.divergence;
                    bestMapP[i] = tmi.mapP;
                    bestDcoP[i] = tmi.dcoP;
                    bestMapIndex[i] = (byte)priorityIndex[0];
                    multimaps[i] = 1;
                } else {
                    bestStrand[i] = -128;
                    bestChr[i] = Integer.MIN_VALUE;
                    bestStartPos[i] = Integer.MIN_VALUE;
                    bestEndPos[i] = Integer.MIN_VALUE;
                    bestDivergence[i] = -128;
                    bestMapP[i] = -128;
                    bestDcoP[i] = -128;
                    bestMapIndex[i] = -128;
                    multimaps[i] = tmi.strand == -128 ? 0 : 99;
                }
            }
            boolean[] ifEvidence = EvidenceType.deCode(bestEvidence[i]);
            tmi = this.topm.getMappingInfo(i, alignerIndex[4][0]);
            if (tmi.chromosome == bestChr[i] && tmi.startPosition == bestStartPos[i] && tmi.strand == bestStrand[i]) {
                ifEvidence[EvidenceType.PE.getIndex()] = true;
            }
            int numRank0 = this.getNumOfRank0(i, alignerIndex[0]);
            tmi = this.topm.getMappingInfo(i, alignerIndex[0][0]);
            if (numRank0 == 0 && tmi.chromosome == bestChr[i] && tmi.startPosition == bestStartPos[i] && tmi.strand == bestStrand[i]) {
                ifEvidence[EvidenceType.SingleBestBowtie2.getIndex()] = true;
            }
            tmi = this.topm.getMappingInfo(i, alignerIndex[1][0]);
            if (tmi.chromosome == bestChr[i] && tmi.startPosition == bestStartPos[i] && tmi.strand == bestStrand[i]) {
                ifEvidence[EvidenceType.BestBWA.getIndex()] = true;
            }
            tmi = this.topm.getMappingInfo(i, alignerIndex[2][0]);
            if (numRank0 == 0 && tmi.chromosome == bestChr[i] && tmi.startPosition == bestStartPos[i] && tmi.strand == bestStrand[i]) {
                ifEvidence[EvidenceType.SingleBestBlast.getIndex()] = true;
            }
            tmi = this.topm.getMappingInfo(i, alignerIndex[3][0]);
            if (numRank0 == 0 && tmi.chromosome == bestChr[i] && tmi.startPosition == bestStartPos[i] && tmi.strand == bestStrand[i]) {
                ifEvidence[EvidenceType.SingleBestBWAMEM.getIndex()] = true;
            }
            bestEvidence[i] = EvidenceType.code(ifEvidence);
        }
        this.topm.writeBestMappingDataSets(bestStrand, bestChr, bestStartPos, bestEndPos, bestDivergence, bestMapP, bestDcoP, multimaps, bestEvidence, bestMapIndex);
    }

    private void incorperateBestGeneticMapping(int tagIndex, Integer[] mapIndices, BufferedReader br, byte[] bestStrand, int[] bestChr, int[] bestStartPos, int[] bestEndPos, byte[] bestDivergence, byte[] bestMapP, byte[] bestDcoP, byte[] bestEvidence, byte[] bestMapIndices) {
        ArrayList<Integer> yMapIndexList = new ArrayList<Integer>();
        try {
            for (int i = 0; i < mapIndices.length; ++i) {
                String in = br.readLine();
                String[] temp = in.startsWith(" ") ? in.split("\\s+")[3].split(":") : in.split("\\s+")[2].split(":");
                if (temp[1].equals("N")) continue;
                yMapIndexList.add(mapIndices[i]);
            }
            if (yMapIndexList.isEmpty()) {
                return;
            }
            double pBest = 1.0;
            int bestMapIndex = -1;
            for (int i = 0; i < yMapIndexList.size(); ++i) {
                TagGeneticMappingInfo tgmi = this.topm.getGeneticMappingInfo(tagIndex, (Integer)yMapIndexList.get(i));
                if (tgmi.p < 0.0 || !(tgmi.p < pBest)) continue;
                pBest = tgmi.p;
                bestMapIndex = (Integer)yMapIndexList.get(i);
            }
            if (bestMapIndex == -1) {
                return;
            }
            if (bestMapIndex >= 25) {
                bestMapIndex -= 5;
            }
            TagMappingInfoV3 tmi = this.topm.getMappingInfo(tagIndex, bestMapIndex);
            bestStrand[tagIndex] = tmi.strand;
            bestChr[tagIndex] = tmi.chromosome;
            bestStartPos[tagIndex] = tmi.startPosition;
            bestEndPos[tagIndex] = tmi.endPosition;
            bestDivergence[tagIndex] = tmi.divergence;
            bestMapP[tagIndex] = tmi.mapP;
            bestDcoP[tagIndex] = tmi.dcoP;
            bestEvidence[tagIndex] = (byte)(1 << EvidenceType.values().length - 1);
            bestMapIndices[tagIndex] = (byte)bestMapIndex;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println(tagIndex);
            System.exit(1);
        }
    }

    public void annotateBestMappingPredict(String modelFileS, String tagCountFileS, String inputDirS, String indexDirS, String outputDirS) {
        String predictFileS;
        int i;
        String[] attributeName = new String[]{"TagCount", "TagLength", "GC", "Chr", "Pos", "Source", "Rank", "Score", "SigSiteNum", "SigSiteRange", "P", "PRatio", "NumOfRank0", "NumOfAlign", "NumOfAlignAll", "Rorw"};
        TagCounts tc = new TagCounts(tagCountFileS, TagsByTaxa.FilePacking.Byte);
        int fileSize = this.topm.getChunkSize();
        int left = this.topm.getTagCount() % fileSize;
        int fileNum = left == 0 ? this.topm.getTagCount() / fileSize : this.topm.getTagCount() / fileSize + 1;
        int[] alignerStartMapIndex = new int[]{0, 5, 10, 15, 20, 25};
        int[][] alignerIndex = new int[alignerStartMapIndex.length][];
        alignerIndex[0] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.Bowtie2);
        alignerIndex[1] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.BWA);
        alignerIndex[2] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.Blast);
        alignerIndex[3] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.BWAMEM);
        alignerIndex[4] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.PEEnd1);
        alignerIndex[5] = this.topm.getMappingIndicesOfAligner(TagMappingInfoV3.Aligner.PEEnd2);
        String missing = "?";
        for (i = 0; i < fileNum; ++i) {
            predictFileS = String.valueOf(i) + ".pre.arff";
            predictFileS = new File(inputDirS, predictFileS).getAbsolutePath();
            String indexFileS = String.valueOf(i) + ".index.txt";
            indexFileS = new File(indexDirS, indexFileS).getAbsolutePath();
            int startTagIndex = i * fileSize;
            int endTagIndex = startTagIndex + fileSize;
            if (endTagIndex > this.topm.getTagCount()) {
                endTagIndex = this.topm.getTagCount();
            }
            try {
                int j;
                BufferedWriter bwp = new BufferedWriter(new FileWriter(predictFileS), 65536);
                BufferedWriter bwi = new BufferedWriter(new FileWriter(indexFileS), 65536);
                bwp.write("@relation trainingFinalSet\n\n");
                for (j = 0; j < attributeName.length - 1; ++j) {
                    bwp.write("@attribute " + attributeName[j] + " numeric\n");
                }
                bwp.write("@attribute Rorw {Y,N}\n");
                bwp.write("\n@data\n");
                bwi.write("TagIndex\tMapIndex");
                bwi.newLine();
                for (j = startTagIndex; j < endTagIndex; ++j) {
                    int cnt = 0;
                    long[] tag = this.topm.getTag(j);
                    int index = tc.getTagIndex(tag);
                    if (index < 0) {
                        System.out.println("TagCount file and TOPM file don't match, program quits");
                        System.exit(0);
                    }
                    int readCount = tc.getReadCount(index);
                    String seq = BaseEncoder.getSequenceFromLong(tag);
                    for (int k = 0; k < this.topm.getTagLength(j); ++k) {
                        if (seq.charAt(k) != 'G' && seq.charAt(k) != 'C') continue;
                        ++cnt;
                    }
                    double gc = (double)cnt / (double)this.topm.getTagLength(j);
                    int[] numOfRank0 = new int[alignerStartMapIndex.length];
                    int[] numOfAlign = new int[alignerStartMapIndex.length];
                    for (int k = 0; k < numOfRank0.length; ++k) {
                        numOfRank0[k] = this.getNumOfRank0(j, alignerIndex[k]);
                        numOfAlign[k] = this.getNumOfAlign(j, alignerIndex[k]);
                    }
                    double pBest = this.getPBest(j);
                    if (pBest == 1.0) continue;
                    int numOfAlignAll = this.getNumOfAlignAll(j);
                    for (int k = 0; k < this.topm.getMappingNum(); ++k) {
                        double boxValue;
                        TagMappingInfoV3 tmi = this.topm.getMappingInfo(j, k);
                        TagGeneticMappingInfo tgmi = this.topm.getGeneticMappingInfo(j, k);
                        if (tmi.chromosome < 0 || tgmi.p < 0.0) continue;
                        bwp.write(String.valueOf(this.boxcox(readCount, -0.181818)) + ",");
                        bwp.write(String.valueOf(this.topm.getTagLength(j)) + ",");
                        bwp.write(String.valueOf(gc) + ",");
                        bwp.write(String.valueOf(tmi.chromosome) + ",");
                        bwp.write(String.valueOf(tmi.startPosition) + ",");
                        bwp.write(String.valueOf(tmi.mappingSource) + ",");
                        bwp.write(String.valueOf(tmi.mappingRank) + ",");
                        if (tmi.mappingScore < 0) {
                            bwp.write(missing + ",");
                        } else {
                            bwp.write(String.valueOf(tmi.mappingScore) + ",");
                        }
                        if (tgmi.sigSiteNum < 0) {
                            bwp.write(missing + ",");
                        } else {
                            boxValue = this.boxcox(tgmi.sigSiteNum, 0.10101);
                            bwp.write(String.valueOf(boxValue) + ",");
                        }
                        if (tgmi.sigSiteRange < 0) {
                            bwp.write(missing + ",");
                        } else {
                            boxValue = this.boxcox(tgmi.sigSiteRange, 0.424242);
                            bwp.write(String.valueOf(boxValue) + ",");
                        }
                        if (tgmi.p < 0.0) {
                            bwp.write(missing + ",");
                            bwp.write(missing + ",");
                        } else {
                            boxValue = this.boxcox(this.minusLog10P(tgmi.p), -0.060606);
                            bwp.write(String.valueOf(boxValue) + ",");
                            if (tgmi.p == 0.0) {
                                bwp.write(String.valueOf(pBest / Double.MIN_VALUE) + ",");
                            } else {
                                bwp.write(String.valueOf(pBest / tgmi.p) + ",");
                            }
                        }
                        index = Arrays.binarySearch(alignerStartMapIndex, k);
                        if (index < 0) {
                            index = -index - 2;
                        }
                        bwp.write(String.valueOf(numOfRank0[index]) + ",");
                        bwp.write(String.valueOf(numOfAlign[index]) + ",");
                        bwp.write(String.valueOf(numOfAlignAll) + ",");
                        bwp.write("N,");
                        bwp.newLine();
                        bwi.write(String.valueOf(j) + "\t" + String.valueOf(k));
                        bwi.newLine();
                    }
                }
                bwp.flush();
                bwi.flush();
                bwp.close();
                bwi.close();
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                System.exit(1);
            }
        }
        for (i = 0; i < fileNum; ++i) {
            predictFileS = String.valueOf(i) + ".pre.arff";
            predictFileS = new File(inputDirS, predictFileS).getAbsolutePath();
            String outputFileS = String.valueOf(i) + ".out.txt";
            outputFileS = new File(outputDirS, outputFileS).getAbsolutePath();
            try {
                Runtime run = Runtime.getRuntime();
                String cmd = "cmd /c java weka.classifiers.trees.RandomForest -p 0 -T " + predictFileS + " -l " + modelFileS + " > " + outputFileS;
                System.out.println(cmd);
                Process p = run.exec(cmd);
                p.waitFor();
                System.out.println("Prediction is made at " + outputFileS);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                System.exit(1);
            }
        }
    }

    public int getNumOfRank0(int tagIndex, int[] mapIndex) {
        int cnt = 0;
        for (int i = 0; i < mapIndex.length; ++i) {
            TagMappingInfoV3 tmi = this.topm.getMappingInfo(tagIndex, mapIndex[i]);
            if (tmi.chromosome < 0 || tmi.mappingRank != 0) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getNumOfAlign(int tagIndex, int[] mapIndex) {
        int cnt = 0;
        for (int i = 0; i < mapIndex.length; ++i) {
            TagMappingInfoV3 tmi = this.topm.getMappingInfo(tagIndex, mapIndex[i]);
            if (tmi.chromosome < 0) continue;
            ++cnt;
        }
        return cnt;
    }

    public double getPBest(int tagIndex) {
        double p = 1.0;
        for (int i = 0; i < this.topm.getMappingNum(); ++i) {
            TagGeneticMappingInfo tgmi = this.topm.getGeneticMappingInfo(tagIndex, i);
            if (tgmi.p < 0.0 || !(tgmi.p < p)) continue;
            p = tgmi.p;
        }
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return p;
    }

    public int getNumOfAlignAll(int tagIndex) {
        int cnt = 0;
        for (int i = 0; i < 20; ++i) {
            TagMappingInfoV3 tmi = this.topm.getMappingInfo(tagIndex, i);
            if (tmi.chromosome < 0) continue;
            ++cnt;
        }
        return cnt;
    }

    public double minusLog10P(double p) {
        if (p < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if ((p = -Math.log10(p)) == Double.POSITIVE_INFINITY) {
            p = -Math.log10(Double.MIN_VALUE);
        }
        return p;
    }

    private double boxcox(double y, double lambda) {
        if (lambda != 0.0) {
            return (Math.pow(y, lambda) - 1.0) / lambda;
        }
        return Math.log(y);
    }

    public void annotateWithBowtie2(String samFileS, int maxMappingNum) {
        String[] dataSetNames = this.topm.creatTagMappingInfoDatasets(this.topm.getMappingNum(), maxMappingNum);
        this.iniTMIBuffers(this.bufferNum, maxMappingNum);
        System.out.println("Reading SAM format tag alignment (Bowtie2) from: " + samFileS);
        System.out.println("Coverting SAM to TOPMHDF5...");
        byte mappingSource = TagMappingInfoV3.Aligner.Bowtie2.getValue();
        int chunkCnt = 0;
        try {
            BufferedReader br = samFileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(samFileS))))) : new BufferedReader(new FileReader(new File(samFileS)), 65536);
            while (!br.readLine().startsWith("@PG")) {
            }
            String inputStr = null;
            while ((inputStr = br.readLine()) != null) {
                int bufferTagIndex;
                int mappingDatasetIndex;
                int bufferIndex;
                String[] temp = inputStr.split("\\s");
                int orientiation = Integer.parseInt(temp[1]);
                int chr = Integer.MIN_VALUE;
                int strand = -128;
                int startPos = Integer.MIN_VALUE;
                int endPos = Integer.MIN_VALUE;
                short mappingScore = Short.MIN_VALUE;
                byte divergence = -128;
                byte perfectMatch = -128;
                String seqS = temp[9];
                if (orientiation != 4) {
                    int[] alignSpan;
                    if (orientiation == 16 || orientiation == 272) {
                        seqS = BaseEncoder.getReverseComplement(seqS);
                        chr = Integer.parseInt(temp[2]);
                        strand = -1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[1];
                        endPos = alignSpan[0];
                        mappingScore = Short.parseShort(temp[11].split(":")[2]);
                        divergence = temp[17].startsWith("NM") ? Byte.parseByte(temp[17].split(":")[2]) : Byte.parseByte(temp[16].split(":")[2]);
                        perfectMatch = temp[5].equals(String.valueOf(seqS.length()) + "M") && divergence == 0 ? (byte)1 : 0;
                    } else {
                        chr = Integer.parseInt(temp[2]);
                        strand = 1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[0];
                        endPos = alignSpan[1];
                        mappingScore = Short.parseShort(temp[11].split(":")[2]);
                        divergence = temp[17].startsWith("NM") ? Byte.parseByte(temp[17].split(":")[2]) : Byte.parseByte(temp[16].split(":")[2]);
                        perfectMatch = temp[5].equals(String.valueOf(seqS.length()) + "M") && divergence == 0 ? (byte)1 : 0;
                    }
                }
                TagMappingInfoV3 theTMI = new TagMappingInfoV3(chr, (byte)strand, startPos, endPos, divergence, perfectMatch, mappingSource, mappingScore);
                long[] seq = BaseEncoder.getLongArrayFromSeq(seqS, this.topm.getTagSizeInLong() * 32);
                int tagIndex = this.topm.getTagIndex(seq);
                if (tagIndex < this.bufferTagIndexRange[0] || tagIndex >= this.bufferTagIndexRange[1]) {
                    System.out.println("The index of the tag from sam file is out of buffer range. Program quits.");
                    System.out.println("Please increase the buffer number");
                    System.exit(1);
                }
                if ((bufferIndex = Arrays.binarySearch(this.bufferStartTagIndex, tagIndex)) < 0) {
                    bufferIndex = -bufferIndex - 2;
                }
                if ((mappingDatasetIndex = this.getMappingDatasetIndex(bufferIndex, bufferTagIndex = tagIndex % this.topm.getChunkSize())) == Integer.MIN_VALUE) continue;
                this.tmiBuffers[bufferIndex][mappingDatasetIndex][bufferTagIndex] = theTMI;
                if (!this.bufferLights[bufferIndex][bufferTagIndex]) {
                    int n = bufferIndex;
                    this.lightCounts[n] = this.lightCounts[n] + 1;
                }
                this.bufferLights[bufferIndex][bufferTagIndex] = true;
                if (this.lightCounts[0] != this.topm.getChunkSize() || this.lightCounts[1] <= this.updateBufferCountCutoff) continue;
                this.saveTMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
                this.updateTMIBuffer();
                System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
            }
            this.saveTMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
            this.topm.setMappingNum(this.topm.getMappingNum() + maxMappingNum);
            System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void annotateWithBWA(String samFileS, int maxMappingNum) {
        String[] dataSetNames = this.topm.creatTagMappingInfoDatasets(this.topm.getMappingNum(), maxMappingNum);
        this.iniTMIBuffers(this.bufferNum, maxMappingNum);
        System.out.println("Reading SAM format tag alignment (BWA) from: " + samFileS);
        System.out.println("Coverting SAM to TOPMHDF5...");
        byte mappingSource = TagMappingInfoV3.Aligner.BWA.getValue();
        int chunkCnt = 0;
        try {
            BufferedReader br = samFileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(samFileS))))) : new BufferedReader(new FileReader(new File(samFileS)), 65536);
            String inputStr = null;
            while ((inputStr = br.readLine()).startsWith("@")) {
            }
            while (inputStr != null) {
                int bufferTagIndex;
                int mappingDatasetIndex;
                int bufferIndex;
                String[] temp = inputStr.split("\\s");
                int orientiation = Integer.parseInt(temp[1]);
                int chr = Integer.MIN_VALUE;
                byte strand = -128;
                int startPos = Integer.MIN_VALUE;
                int endPos = Integer.MIN_VALUE;
                short mappingScore = Short.MIN_VALUE;
                byte divergence = -128;
                byte perfectMatch = -128;
                String seqS = temp[9];
                String XAString = null;
                if (temp[temp.length - 1].startsWith("XA")) {
                    XAString = temp[temp.length - 1].replaceFirst("XA:Z:", "");
                }
                if (orientiation != 4) {
                    int[] alignSpan;
                    if (orientiation == 16) {
                        seqS = BaseEncoder.getReverseComplement(seqS);
                        chr = Integer.parseInt(temp[2]);
                        strand = -1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[1];
                        endPos = alignSpan[0];
                        divergence = Byte.parseByte(temp[12].split(":")[2]);
                        perfectMatch = temp[5].equals(String.valueOf(seqS.length()) + "M") && divergence == 0 ? (byte)1 : 0;
                    } else {
                        chr = Integer.parseInt(temp[2]);
                        strand = 1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[0];
                        endPos = alignSpan[1];
                        divergence = Byte.parseByte(temp[12].split(":")[2]);
                        perfectMatch = temp[5].equals(String.valueOf(seqS.length()) + "M") && divergence == 0 ? (byte)1 : 0;
                    }
                }
                TagMappingInfoV3 theTMI = new TagMappingInfoV3(chr, strand, startPos, endPos, divergence, perfectMatch, mappingSource, mappingScore);
                long[] seq = BaseEncoder.getLongArrayFromSeq(seqS, this.topm.getTagSizeInLong() * 32);
                int tagIndex = this.topm.getTagIndex(seq);
                if (tagIndex < this.bufferTagIndexRange[0] || tagIndex >= this.bufferTagIndexRange[1]) {
                    System.out.println("The index of the tag from sam file is out of buffer range. Program quits.");
                    System.out.println("Please increase the buffer number");
                    System.exit(1);
                }
                if ((bufferIndex = Arrays.binarySearch(this.bufferStartTagIndex, tagIndex)) < 0) {
                    bufferIndex = -bufferIndex - 2;
                }
                if ((mappingDatasetIndex = this.getMappingDatasetIndex(bufferIndex, bufferTagIndex = tagIndex % this.topm.getChunkSize())) == Integer.MIN_VALUE) continue;
                this.tmiBuffers[bufferIndex][mappingDatasetIndex][bufferTagIndex] = theTMI;
                if (!this.bufferLights[bufferIndex][bufferTagIndex]) {
                    int n = bufferIndex;
                    this.lightCounts[n] = this.lightCounts[n] + 1;
                }
                if (XAString != null) {
                    temp = XAString.split(";");
                    for (int i = 0; i < temp.length && (mappingDatasetIndex = this.getMappingDatasetIndex(bufferIndex, bufferTagIndex)) != Integer.MIN_VALUE; ++i) {
                        int[] alignSpan;
                        String[] tem = temp[i].split(",");
                        chr = Integer.parseInt(tem[0]);
                        if (tem[1].startsWith("+")) {
                            strand = 1;
                            alignSpan = SAMUtils.adjustCoordinates(tem[2], Integer.parseInt(tem[1].substring(1)));
                            startPos = alignSpan[1];
                            endPos = alignSpan[0];
                        } else {
                            strand = -1;
                            alignSpan = SAMUtils.adjustCoordinates(tem[2], Integer.parseInt(tem[1].substring(1)));
                            startPos = alignSpan[0];
                            endPos = alignSpan[1];
                        }
                        divergence = Byte.parseByte(tem[3]);
                        perfectMatch = tem[2].equals(String.valueOf(seqS.length()) + "M") && divergence == 0 ? (byte)1 : 0;
                        this.tmiBuffers[bufferIndex][mappingDatasetIndex][bufferTagIndex] = theTMI = new TagMappingInfoV3(chr, strand, startPos, endPos, divergence, perfectMatch, mappingSource, mappingScore);
                    }
                }
                this.bufferLights[bufferIndex][bufferTagIndex] = true;
                if (this.lightCounts[0] == this.topm.getChunkSize() && this.lightCounts[1] > this.updateBufferCountCutoff) {
                    this.saveBWATMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
                    this.updateTMIBuffer();
                    System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
                }
                inputStr = br.readLine();
            }
            this.saveBWATMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
            this.topm.setMappingNum(this.topm.getMappingNum() + maxMappingNum);
            System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void annotateWithBWAMEM(String samFileS, int maxMappingNum) {
        String[] dataSetNames = this.topm.creatTagMappingInfoDatasets(this.topm.getMappingNum(), maxMappingNum);
        this.iniTMIBuffers(this.bufferNum, maxMappingNum);
        System.out.println("Reading SAM format tag alignment (BWAMEM) from: " + samFileS);
        System.out.println("Coverting SAM to TOPMHDF5...");
        byte mappingSource = TagMappingInfoV3.Aligner.BWAMEM.getValue();
        try {
            BufferedReader br = samFileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(samFileS))))) : new BufferedReader(new FileReader(new File(samFileS)), 65536);
            String inputStr = null;
            while ((inputStr = br.readLine()).startsWith("@")) {
            }
            int mapCnt = 0;
            int tagIndex = 0;
            int chunkCnt = 0;
            int seqLength = Integer.MIN_VALUE;
            while (inputStr != null) {
                int bufferTagIndex;
                int mappingDatasetIndex;
                int bufferIndex;
                long[] seq;
                String[] temp = inputStr.split("\\s");
                int orientiation = Integer.parseInt(temp[1]);
                int chr = Integer.MIN_VALUE;
                int strand = -128;
                int startPos = Integer.MIN_VALUE;
                int endPos = Integer.MIN_VALUE;
                short mappingScore = Short.MIN_VALUE;
                byte divergence = -128;
                byte perfectMatch = -128;
                String seqS = temp[9];
                if (seqS.equals("*")) {
                    ++mapCnt;
                } else {
                    mapCnt = 1;
                    seqLength = seqS.length();
                }
                if (mapCnt > maxMappingNum) {
                    inputStr = br.readLine();
                    continue;
                }
                if (orientiation != 4) {
                    int[] alignSpan;
                    if (orientiation == 16 || orientiation == 272) {
                        if (!seqS.equals("*")) {
                            seqS = BaseEncoder.getReverseComplement(seqS);
                        }
                        chr = Integer.parseInt(temp[2]);
                        strand = -1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[1];
                        endPos = alignSpan[0];
                        divergence = Byte.parseByte(temp[11].split(":")[2]);
                        perfectMatch = temp[5].equals(String.valueOf(seqLength) + "M") && divergence == 0 ? (byte)1 : 0;
                        mappingScore = Byte.parseByte(temp[12].split(":")[2]);
                    } else if (orientiation == 0 || orientiation == 256) {
                        chr = Integer.parseInt(temp[2]);
                        strand = 1;
                        alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                        startPos = alignSpan[0];
                        endPos = alignSpan[1];
                        divergence = Byte.parseByte(temp[11].split(":")[2]);
                        if (temp[5].equals(String.valueOf(seqLength) + "M") && divergence == 0) {
                            perfectMatch = 1;
                        }
                        perfectMatch = 0;
                        mappingScore = Byte.parseByte(temp[12].split(":")[2]);
                    } else {
                        inputStr = br.readLine();
                        continue;
                    }
                }
                TagMappingInfoV3 theTMI = new TagMappingInfoV3(chr, (byte)strand, startPos, endPos, divergence, perfectMatch, mappingSource, mappingScore);
                if (!(seqS.equals("*") || (tagIndex = this.topm.getTagIndex(seq = BaseEncoder.getLongArrayFromSeq(seqS, this.topm.getTagSizeInLong() * 32))) >= this.bufferTagIndexRange[0] && tagIndex < this.bufferTagIndexRange[1])) {
                    System.out.println("The index of the tag from sam file is out of buffer range. Program quits.");
                    System.out.println("Please increase the buffer number");
                    System.exit(1);
                }
                if ((bufferIndex = Arrays.binarySearch(this.bufferStartTagIndex, tagIndex)) < 0) {
                    bufferIndex = -bufferIndex - 2;
                }
                if ((mappingDatasetIndex = this.getMappingDatasetIndex(bufferIndex, bufferTagIndex = tagIndex % this.topm.getChunkSize())) == Integer.MIN_VALUE) {
                    inputStr = br.readLine();
                    continue;
                }
                this.tmiBuffers[bufferIndex][mappingDatasetIndex][bufferTagIndex] = theTMI;
                if (!this.bufferLights[bufferIndex][bufferTagIndex]) {
                    int n = bufferIndex;
                    this.lightCounts[n] = this.lightCounts[n] + 1;
                }
                this.bufferLights[bufferIndex][bufferTagIndex] = true;
                if (this.lightCounts[1] > this.updateBufferCountCutoff) {
                    this.saveBWATMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
                    this.updateTMIBuffer();
                    System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
                }
                inputStr = br.readLine();
            }
            this.saveTMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
            this.topm.setMappingNum(this.topm.getMappingNum() + maxMappingNum);
            System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void annotateWithBlastFromDir(String blastDirS, int maxMappingNum) {
        String[] dataSetNames = this.topm.creatTagMappingInfoDatasets(this.topm.getMappingNum(), maxMappingNum);
        this.iniTMIBuffers(2, maxMappingNum);
        System.out.println("Reading BLAST table format tag alignment (BLAST) from: " + blastDirS);
        System.out.println("Coverting BLAST to TOPMHDF5...");
        byte mappingSource = TagMappingInfoV3.Aligner.Blast.getValue();
        Object[] infiles = new File(blastDirS).listFiles();
        Arrays.sort(infiles);
        int chunkCnt = 0;
        try {
            for (int i = 0; i < infiles.length; ++i) {
                System.out.println("Reading BLAST table format tag alignment (BLAST) from: " + ((File)infiles[i]).getAbsolutePath());
                BufferedReader br = ((File)infiles[i]).getName().endsWith("gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream((File)infiles[i])))) : new BufferedReader(new FileReader((File)infiles[i]), 65536);
                String inputStr = null;
                while ((inputStr = br.readLine()) != null) {
                    TagMappingInfoV3 theTMI;
                    int bufferTagIndex;
                    int mappingDatasetIndex;
                    int bufferIndex;
                    int tagIndex;
                    int endPos;
                    String[] temp = inputStr.split("\\s+");
                    int chr = Integer.parseInt(temp[1]);
                    byte strand = -128;
                    int startPos = Integer.parseInt(temp[8]);
                    strand = startPos < (endPos = Integer.parseInt(temp[9])) ? (byte)1 : -1;
                    short mappingScore = Short.parseShort(temp[11].replaceAll("\\..+", ""));
                    byte divergence = Byte.valueOf(temp[4]);
                    byte perfectMatch = 0;
                    if (temp[2].startsWith("100")) {
                        perfectMatch = 1;
                    }
                    if ((tagIndex = Integer.parseInt(temp[0])) >= this.bufferStartTagIndex[1]) {
                        int n = (tagIndex - this.bufferStartTagIndex[1]) / this.topm.getChunkSize() + 1;
                        for (int j = 0; j < n; ++j) {
                            this.saveTMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
                            this.updateTMIBuffer();
                        }
                    }
                    if ((bufferIndex = Arrays.binarySearch(this.bufferStartTagIndex, tagIndex)) < 0) {
                        bufferIndex = -bufferIndex - 2;
                    }
                    if ((mappingDatasetIndex = this.getMappingDatasetIndex(bufferIndex, bufferTagIndex = tagIndex % this.topm.getChunkSize())) == Integer.MIN_VALUE) continue;
                    this.tmiBuffers[bufferIndex][mappingDatasetIndex][bufferTagIndex] = theTMI = new TagMappingInfoV3(chr, strand, startPos, endPos, divergence, perfectMatch, mappingSource, mappingScore);
                }
                br.close();
                System.gc();
            }
            this.saveTMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
            this.topm.setMappingNum(this.topm.getMappingNum() + maxMappingNum);
            System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void annotateWithBLAST(String blastM8FileS, int maxMappingNum) {
        String[] dataSetNames = this.topm.creatTagMappingInfoDatasets(this.topm.getMappingNum(), maxMappingNum);
        this.iniTMIBuffers(2, maxMappingNum);
        System.out.println("Reading BLAST table format tag alignment (BLAST) from: " + blastM8FileS);
        System.out.println("Coverting BLAST to TOPMHDF5...");
        byte mappingSource = TagMappingInfoV3.Aligner.Blast.getValue();
        int chunkCnt = 0;
        try {
            BufferedReader br = blastM8FileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(blastM8FileS))))) : new BufferedReader(new FileReader(new File(blastM8FileS)), 65536);
            String inputStr = null;
            while ((inputStr = br.readLine()) != null) {
                int bufferTagIndex;
                int mappingDatasetIndex;
                int bufferIndex;
                int tagIndex;
                int endPos;
                String[] temp = inputStr.split("\\s+");
                int chr = Integer.parseInt(temp[1]);
                byte strand = -128;
                int startPos = Integer.parseInt(temp[8]);
                strand = startPos < (endPos = Integer.parseInt(temp[9])) ? (byte)1 : -1;
                short mappingScore = Short.parseShort(temp[11].replaceAll("\\..+", ""));
                byte divergence = Byte.valueOf(temp[4]);
                byte perfectMatch = 0;
                if (temp[2].startsWith("100")) {
                    perfectMatch = 1;
                }
                if ((tagIndex = Integer.parseInt(temp[0])) >= this.bufferStartTagIndex[1]) {
                    int n = (tagIndex - this.bufferStartTagIndex[1]) / this.topm.getChunkSize() + 1;
                    for (int j = 0; j < n; ++j) {
                        this.saveTMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
                        this.updateTMIBuffer();
                    }
                }
                if ((bufferIndex = Arrays.binarySearch(this.bufferStartTagIndex, tagIndex)) < 0) {
                    bufferIndex = -bufferIndex - 2;
                }
                if ((mappingDatasetIndex = this.getMappingDatasetIndex(bufferIndex, bufferTagIndex = tagIndex % this.topm.getChunkSize())) == Integer.MIN_VALUE) continue;
                TagMappingInfoV3 theTMI = new TagMappingInfoV3(chr, strand, startPos, endPos, divergence, perfectMatch, mappingSource, mappingScore);
                System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
                this.tmiBuffers[bufferIndex][mappingDatasetIndex][bufferTagIndex] = theTMI;
            }
            this.saveTMIBufferToTOPM(this.tmiBuffers[0], dataSetNames, this.bufferStartTagIndex[0] / this.topm.getChunkSize(), mappingSource);
            this.topm.setMappingNum(this.topm.getMappingNum() + maxMappingNum);
            System.out.println(++chunkCnt + " chunks are annotated. " + this.topm.getChunkNum() + " chunks in total");
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void annotateWithPE(String PETOPMFileS, int maxMappingNum) {
        byte forwardMappingSource = TagMappingInfoV3.Aligner.PEEnd1.getValue();
        byte backMappingSource = TagMappingInfoV3.Aligner.PEEnd2.getValue();
        PETagsOnPhysicalMapV3 ptopm = new PETagsOnPhysicalMapV3(PETOPMFileS);
        String[] forwardDataSetNames = this.topm.creatTagMappingInfoDatasets(this.topm.getMappingNum(), maxMappingNum);
        this.topm.setMappingNum(this.topm.getMappingNum() + maxMappingNum);
        String[] backwardDataSetNames = this.topm.creatTagMappingInfoDatasets(this.topm.getMappingNum(), maxMappingNum);
        this.topm.setMappingNum(this.topm.getMappingNum() + maxMappingNum);
        for (int i = 0; i < this.topm.getChunkNum(); ++i) {
            TagMappingInfoV3[][] forwardBuffer = this.getPopulateTMIBuffer(maxMappingNum);
            TagMappingInfoV3[][] backBuffer = this.getPopulateTMIBuffer(maxMappingNum);
            int startIndex = i * this.topm.getChunkSize();
            int endIndex = startIndex + this.topm.getChunkSize();
            if (endIndex > this.topm.getTagCount()) {
                endIndex = this.topm.getTagCount();
            }
            for (int j = startIndex; j < endIndex; ++j) {
                TagMappingInfoV3 theTMI;
                byte divergence;
                short mappingScore;
                int startPos;
                byte strand;
                byte chr;
                int k;
                long[] t = this.topm.getTag(j);
                int index = ptopm.getTagIndexWithLongestSeq(t);
                if (index == -1) continue;
                int max = ptopm.getMappingNum(index);
                if (max > maxMappingNum) {
                    max = maxMappingNum;
                }
                for (k = 0; k < max; ++k) {
                    chr = ptopm.getChr(index, k);
                    strand = ptopm.getStrand(index, k);
                    startPos = ptopm.getStartPos(index, k);
                    mappingScore = ptopm.getScore(index, k);
                    divergence = ptopm.getDivergence(index, k);
                    forwardBuffer[k][j - startIndex] = theTMI = new TagMappingInfoV3(chr, strand, startPos, Integer.MIN_VALUE, divergence, -128, forwardMappingSource, mappingScore);
                }
                max = ptopm.getMappingNum(ptopm.getPairIndex(index));
                if (max > maxMappingNum) {
                    max = maxMappingNum;
                }
                for (k = 0; k < max; ++k) {
                    chr = ptopm.getChr(ptopm.getPairIndex(index), k);
                    strand = ptopm.getStrand(ptopm.getPairIndex(index), k);
                    startPos = ptopm.getStartPos(ptopm.getPairIndex(index), k);
                    mappingScore = ptopm.getScore(ptopm.getPairIndex(index), k);
                    divergence = ptopm.getDivergence(ptopm.getPairIndex(index), k);
                    backBuffer[k][j - startIndex] = theTMI = new TagMappingInfoV3(chr, strand, startPos, Integer.MIN_VALUE, divergence, -128, backMappingSource, mappingScore);
                }
            }
            this.saveTMIBufferToTOPM(forwardBuffer, forwardDataSetNames, i);
            this.saveTMIBufferToTOPM(backBuffer, backwardDataSetNames, i);
            System.out.println("Chunk " + i + "(index) with " + this.topm.getChunkSize() + " tags is annotated");
        }
    }

    public void annotateWithGMGW(String TOGMFileS, int maxMappingNum) {
        TagsOnGeneticMap togm = new TagsOnGeneticMap(TOGMFileS, TagsByTaxa.FilePacking.Text);
        String dataSetName = this.topm.creatTagGeneticMappingInfoGWDataset();
        for (int i = 0; i < this.topm.getChunkNum(); ++i) {
            TagGeneticMappingInfo[] gmChunk = new TagGeneticMappingInfo[this.topm.getChunkSize()];
            for (int j = 0; j < this.topm.getChunkSize(); ++j) {
                gmChunk[j] = new TagGeneticMappingInfo();
            }
            int startIndex = i * this.topm.getChunkSize();
            int endIndex = startIndex + this.topm.getChunkSize();
            if (endIndex > this.topm.getTagCount()) {
                endIndex = this.topm.getTagCount();
            }
            for (int j = startIndex; j < endIndex; ++j) {
                TagGeneticMappingInfo tgmi;
                long[] t = this.topm.getTag(j);
                int index = togm.getTagIndex(t);
                if (index < 0) continue;
                int chr = togm.getGChr(index);
                int position = togm.getGPos(index);
                gmChunk[j - startIndex] = tgmi = new TagGeneticMappingInfo(Double.NEGATIVE_INFINITY, chr, position, Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            this.topm.writeTagGeneticMappingInfoGWDataSet(dataSetName, gmChunk, i);
            if (i % 100 != 0) continue;
            System.out.println("Chunk " + i + "(index) with " + this.topm.getChunkSize() + " tags is annotated with genome wide genetic mapping");
        }
    }

    private void saveBWATMIBufferToTOPM(TagMappingInfoV3[][] tmiBuffer, String[] dataSetNames, int chunkIndex, byte mappingSource) {
        int j;
        int i;
        for (i = 0; i < tmiBuffer.length; ++i) {
            for (j = 0; j < tmiBuffer[i].length; ++j) {
                if (tmiBuffer[i][j] != null) continue;
                tmiBuffer[i][j] = new TagMappingInfoV3();
                tmiBuffer[i][j].setMappingSource(mappingSource);
            }
        }
        for (i = 0; i < tmiBuffer.length; ++i) {
            for (j = 0; j < tmiBuffer[i].length; ++j) {
                tmiBuffer[i][j].setMappingRank((byte)i);
            }
        }
        this.topm.writeTagMappingInfoDataSets(dataSetNames, tmiBuffer, chunkIndex);
    }

    private void saveTMIBufferToTOPM(TagMappingInfoV3[][] tmiBuffer, String[] dataSetNames, int chunkIndex) {
        for (int i = 0; i < tmiBuffer[0].length; ++i) {
            int sum = 0;
            for (int j = 0; j < tmiBuffer.length; ++j) {
                if (tmiBuffer[j][i].mappingSource != -128) continue;
                ++sum;
            }
            if (sum == tmiBuffer.length) continue;
            TreeSet<Short> set = new TreeSet<Short>();
            for (int j = 0; j < tmiBuffer.length; ++j) {
                set.add(tmiBuffer[j][i].mappingScore);
            }
            Object[] sA = set.toArray(new Short[set.size()]);
            byte[] rank = new byte[tmiBuffer.length];
            for (int j = 0; j < rank.length; ++j) {
                rank[j] = (byte)(sA.length - Arrays.binarySearch(sA, (Object)tmiBuffer[j][i].mappingScore) - 1);
                tmiBuffer[j][i].setMappingRank(rank[j]);
            }
        }
        this.topm.writeTagMappingInfoDataSets(dataSetNames, tmiBuffer, chunkIndex);
    }

    private void saveTMIBufferToTOPM(TagMappingInfoV3[][] tmiBuffer, String[] dataSetNames, int chunkIndex, byte mappingSource) {
        int i;
        for (i = 0; i < tmiBuffer.length; ++i) {
            for (int j = 0; j < tmiBuffer[i].length; ++j) {
                if (tmiBuffer[i][j] != null) continue;
                tmiBuffer[i][j] = new TagMappingInfoV3();
                tmiBuffer[i][j].setMappingSource(mappingSource);
            }
        }
        for (i = 0; i < tmiBuffer[0].length; ++i) {
            TreeSet<Short> set = new TreeSet<Short>();
            for (int j = 0; j < tmiBuffer.length; ++j) {
                set.add(tmiBuffer[j][i].mappingScore);
            }
            Object[] sA = set.toArray(new Short[set.size()]);
            byte[] rank = new byte[tmiBuffer.length];
            for (int j = 0; j < rank.length; ++j) {
                rank[j] = (byte)(sA.length - Arrays.binarySearch(sA, (Object)tmiBuffer[j][i].mappingScore) - 1);
                tmiBuffer[j][i].setMappingRank(rank[j]);
            }
        }
        this.topm.writeTagMappingInfoDataSets(dataSetNames, tmiBuffer, chunkIndex);
    }

    private void updateTMIBuffer() {
        for (int i = 0; i < this.tmiBuffers.length - 1; ++i) {
            this.tmiBuffers[i] = this.tmiBuffers[i + 1];
            this.bufferStartTagIndex[i] = this.bufferStartTagIndex[i + 1];
            this.bufferLights[i] = this.bufferLights[i + 1];
            this.lightCounts[i] = this.lightCounts[i + 1];
        }
        this.tmiBuffers[this.tmiBuffers.length - 1] = new TagMappingInfoV3[this.tmiBuffers[0].length][this.topm.getChunkSize()];
        int n = this.tmiBuffers.length - 1;
        this.bufferStartTagIndex[n] = this.bufferStartTagIndex[n] + this.topm.getChunkSize();
        this.bufferLights[this.tmiBuffers.length - 1] = new boolean[this.topm.getChunkSize()];
        this.lightCounts[this.tmiBuffers.length - 1] = 0;
        this.calBufferTagIndexRange();
    }

    private TagMappingInfoV3[][] getPopulateTMIBuffer(int maxMappingNum) {
        TagMappingInfoV3[][] tmiBuffer = new TagMappingInfoV3[maxMappingNum][this.topm.getChunkSize()];
        for (int i = 0; i < tmiBuffer.length; ++i) {
            for (int j = 0; j < tmiBuffer[i].length; ++j) {
                tmiBuffer[i][j] = new TagMappingInfoV3();
            }
        }
        return tmiBuffer;
    }

    private void iniTMIBuffers(int bufferNum, int maxMappingNum) {
        this.tmiBuffers = new TagMappingInfoV3[bufferNum][maxMappingNum][this.topm.getChunkSize()];
        this.bufferStartTagIndex = new int[bufferNum];
        for (int i = 0; i < bufferNum; ++i) {
            this.bufferStartTagIndex[i] = i * this.topm.getChunkSize();
        }
        this.calBufferTagIndexRange();
        this.bufferLights = new boolean[bufferNum][this.topm.getChunkSize()];
        this.lightCounts = new int[bufferNum];
        this.updateBufferCountCutoff = (int)((double)this.topm.getChunkSize() * 0.2);
    }

    private void calBufferTagIndexRange() {
        this.bufferTagIndexRange = new int[2];
        this.bufferTagIndexRange[0] = this.bufferStartTagIndex[0];
        this.bufferTagIndexRange[1] = this.bufferStartTagIndex[this.tmiBuffers.length - 1] + this.topm.getChunkSize();
    }

    private int getMappingDatasetIndex(int bufferIndex, int bufferTagIndex) {
        for (int i = 0; i < this.tmiBuffers[0].length; ++i) {
            if (this.tmiBuffers[bufferIndex][i][bufferTagIndex] != null) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public static enum EvidenceType {
        GM(1, 0),
        PE(2, 1),
        SingleBestBowtie2(4, 2),
        BestBWA(8, 3),
        SingleBestBlast(16, 4),
        SingleBestBWAMEM(32, 5);

        private byte typeCode;
        private int index;

        private EvidenceType(byte value, int indexInBestEvidence) {
            this.typeCode = value;
            this.index = indexInBestEvidence;
        }

        public byte getCode() {
            return this.typeCode;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean getIfHasEvidence(EvidenceType type, boolean[] ifEvidence) {
            return ifEvidence[type.getIndex()];
        }

        public static byte code(boolean[] ifEvidence) {
            int evidenceByte = 0;
            for (int i = 0; i < ifEvidence.length; ++i) {
                evidenceByte <<= 1;
                if (!ifEvidence[i]) continue;
                evidenceByte |= 1;
            }
            return (byte)evidenceByte;
        }

        public static boolean[] deCode(byte evidenceByte) {
            boolean[] ifEvidence = new boolean[EvidenceType.getSize()];
            int test = 1;
            for (int i = 0; i < ifEvidence.length; ++i) {
                int value = evidenceByte >> i & test;
                ifEvidence[ifEvidence.length - i - 1] = value != 0;
            }
            return ifEvidence;
        }

        public static int getSize() {
            return EvidenceType.values().length;
        }
    }
}

