/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.maizegenetics.analysis.gbs.PolymorphismFinder;
import net.maizegenetics.analysis.gbs.TagMatchFinder;
import net.maizegenetics.analysis.gbs.cluster;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.ReadsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class Clusters {
    cluster[] cls;

    public Clusters(ReadsByTaxa rbt) {
        this.getClusters(rbt);
    }

    public Clusters(TagsByTaxa tbt) {
        this.getClusters(tbt);
    }

    public Clusters(String infileS, boolean binary) {
        this.readCluster(infileS, binary);
    }

    public void getClusters(ReadsByTaxa rbt) {
        PolymorphismFinder pf = new PolymorphismFinder(rbt);
        ArrayList<cluster> clList = new ArrayList<cluster>();
        for (int i = 0; i < rbt.haplotypeNum; ++i) {
            long[] queryLongSeq = new long[]{rbt.haplotype[0][i], rbt.haplotype[1][i]};
            ArrayList<Integer> hitIndex = pf.findOneMismatch(queryLongSeq);
            if (hitIndex.isEmpty()) continue;
            Integer[] hitIndexArray = hitIndex.toArray(new Integer[hitIndex.size()]);
            for (int j = 0; j < hitIndexArray.length; ++j) {
                cluster cl = new cluster(i, hitIndexArray[j], hitIndexArray.length + 1, true);
                clList.add(cl);
            }
        }
        this.cls = clList.toArray(new cluster[clList.size()]);
    }

    public void getClusters(TagsByTaxa tbt) {
        ArrayList<cluster> clList = new ArrayList<cluster>();
        TagMatchFinder tmf = new TagMatchFinder(tbt);
        for (int i = 0; i < tbt.getTagCount(); ++i) {
            long[] qTag = tbt.getTag(i);
            TreeMap<Integer, Integer> hitDiv = tmf.findMatchesWithIntLengthWords(qTag, 1, false);
            for (Map.Entry<Integer, Integer> each : hitDiv.entrySet()) {
                if (each.getValue() <= 0) continue;
                clList.add(new cluster(i, each.getKey(), hitDiv.size(), true));
            }
        }
        this.cls = clList.toArray(new cluster[clList.size()]);
    }

    public void networkFilter() {
        int i;
        TreeSet<cluster> clSet = new TreeSet<cluster>();
        TreeSet<Integer> threeSet = new TreeSet<Integer>();
        ArrayList<cluster> twoClusterList = new ArrayList<cluster>();
        for (i = 0; i < this.cls.length; ++i) {
            this.cls[i].switchQueryAndHit();
        }
        Arrays.sort(this.cls);
        for (i = 0; i < this.cls.length; ++i) {
            if (this.cls[i].cSize > 2) {
                threeSet.add(this.cls[i].queryIndex);
                threeSet.add(this.cls[i].hitIndex);
                continue;
            }
            clSet.add(this.cls[i]);
        }
        cluster[] tempTwoCluster = clSet.toArray(new cluster[clSet.size()]);
        Object[] threeArray = threeSet.toArray(new Integer[threeSet.size()]);
        Arrays.sort(threeArray);
        for (int i2 = 0; i2 < tempTwoCluster.length; ++i2) {
            int hit = Arrays.binarySearch(threeArray, (Object)tempTwoCluster[i2].queryIndex);
            if (hit > -1 || (hit = Arrays.binarySearch(threeArray, (Object)tempTwoCluster[i2].hitIndex)) > -1) continue;
            twoClusterList.add(tempTwoCluster[i2]);
        }
        cluster[] twoCluster = twoClusterList.toArray(new cluster[twoClusterList.size()]);
        this.cls = twoCluster;
        Arrays.sort(this.cls);
        twoCluster = null;
        tempTwoCluster = null;
        threeArray = null;
        clSet = null;
        threeSet = null;
        twoClusterList = null;
    }

    public void repeatLibraryFilter(ReadsByTaxa rbt, String TagSeqS, String repeatlibS) {
        String[] tagSeqs = new String[this.getSnpCount()];
        int[] clsIndex = new int[tagSeqs.length];
        int count = 0;
        for (int i = 0; i < this.cls.length; ++i) {
            if (!this.cls[i].ifSnp) continue;
            long[] longSeq = new long[]{rbt.haplotype[0][this.cls[i].queryIndex], rbt.haplotype[1][this.cls[i].queryIndex]};
            tagSeqs[count] = BaseEncoder.getSequenceFromLong(longSeq);
            clsIndex[count] = i;
            ++count;
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(TagSeqS), 65536);
            for (int i = 0; i < tagSeqs.length; ++i) {
                bw.write(">" + String.valueOf(clsIndex[i]));
                bw.newLine();
                bw.write(tagSeqs[i]);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Error occurred while writing " + TagSeqS);
        }
        String blastFileS = TagSeqS.replace("fasta", "blast");
        String cmd = "blastn -query " + TagSeqS + " -db " + repeatlibS + " -out " + blastFileS + " -evalue 1e-10 -outfmt 6";
        System.out.println(cmd);
        try {
            Runtime.getRuntime().exec(cmd).waitFor();
        }
        catch (Exception e) {
            System.out.println("Error occurred while doing blast " + e.toString());
        }
        TreeSet<Integer> repeatIndex = new TreeSet<Integer>();
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(blastFileS), 65536);
            while ((temp = br.readLine()) != null) {
                Integer index = Integer.valueOf(temp.split("\t")[0]);
                repeatIndex.add(index);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred while reading" + blastFileS);
        }
        Integer[] repeatIndexArray = repeatIndex.toArray(new Integer[repeatIndex.size()]);
        for (int i = 0; i < repeatIndexArray.length; ++i) {
            this.cls[repeatIndexArray[i].intValue()].ifSnp = false;
        }
    }

    public void repeatFilter(ReadsByTaxa rbt, double ratio) {
        int beginIndex;
        int i;
        int[] tagCount = new int[2 * this.getSnpCount()];
        int[] clusterIndex = new int[2 * this.getSnpCount()];
        for (i = 0; i < this.cls.length; ++i) {
            if (!this.cls[i].ifSnp) continue;
            int totalA = 0;
            int totalC = 0;
            for (int j = 0; j < rbt.taxaNum; ++j) {
                totalA += rbt.hapDist[this.cls[i].queryIndex][j];
                totalC += rbt.hapDist[this.cls[i].hitIndex][j];
            }
            tagCount[2 * i] = totalA;
            clusterIndex[2 * i] = i;
            tagCount[2 * i + 1] = totalC;
            clusterIndex[2 * i + 1] = i;
        }
        for (i = 0; i < tagCount.length - 1; ++i) {
            for (int j = i + 1; j < tagCount.length; ++j) {
                if (tagCount[i] <= tagCount[j]) continue;
                int mid = tagCount[i];
                tagCount[i] = tagCount[j];
                tagCount[j] = mid;
                mid = clusterIndex[i];
                clusterIndex[i] = clusterIndex[j];
                clusterIndex[j] = mid;
            }
        }
        for (int i2 = beginIndex = (int)Math.floor((double)clusterIndex.length * (1.0 - ratio)); i2 < clusterIndex.length; ++i2) {
            this.cls[clusterIndex[i2]].ifSnp = false;
        }
    }

    public int getSnpCount() {
        int snpCount = 0;
        for (int i = 0; i < this.cls.length; ++i) {
            if (!this.cls[i].ifSnp) continue;
            ++snpCount;
        }
        return snpCount;
    }

    public void alleleFrequencyFileter(ReadsByTaxa rbt, double minBorderMaf, double maxBorderMaf) {
        for (int i = 0; i < this.cls.length; ++i) {
            double maf;
            if (!this.cls[i].ifSnp) continue;
            int totalA = 0;
            int totalC = 0;
            for (int j = 0; j < rbt.taxaNum; ++j) {
                totalA += rbt.hapDist[this.cls[i].queryIndex][j];
                totalC += rbt.hapDist[this.cls[i].hitIndex][j];
            }
            int min = totalA;
            if (totalC < totalA) {
                min = totalC;
            }
            if (!((maf = (double)min / (double)(totalA + totalC)) < minBorderMaf) && !(maf > maxBorderMaf)) continue;
            this.cls[i].ifSnp = false;
        }
    }

    public void heteozygoteFilter(ReadsByTaxa rbt) {
        for (int i = 0; i < this.cls.length; ++i) {
            int heteoA = 0;
            int heteoC = 0;
            int totalA = 0;
            int totalC = 0;
            boolean flag = false;
            if (!this.cls[i].ifSnp) continue;
            for (int j = 0; j < rbt.taxaNum; ++j) {
                if (rbt.hapDist[this.cls[i].queryIndex][j] > 0) {
                    totalA += rbt.hapDist[this.cls[i].queryIndex][j];
                    if (rbt.hapDist[this.cls[i].hitIndex][j] <= 0) continue;
                    totalC += rbt.hapDist[this.cls[i].hitIndex][j];
                    heteoA += rbt.hapDist[this.cls[i].queryIndex][j];
                    heteoC += rbt.hapDist[this.cls[i].hitIndex][j];
                    boolean ifSig = this.chiSquareEvenDf1(rbt.hapDist[this.cls[i].queryIndex][j], rbt.hapDist[this.cls[i].hitIndex][j], 3.841);
                    if (!ifSig) continue;
                    this.cls[i].ifSnp = false;
                    flag = true;
                    break;
                }
                if (rbt.hapDist[this.cls[i].hitIndex][j] <= 0) continue;
                totalC += rbt.hapDist[this.cls[i].hitIndex][j];
            }
            if (flag || !this.chiSquareEvenDf1(heteoA, heteoC, 3.841)) continue;
            this.cls[i].ifSnp = false;
        }
    }

    public boolean chiSquareDf1(int ob1, int ob2, int ex1, int ex2, double chiValueCutoff) {
        double o1 = (double)ob1 / (double)(ob1 + ob2);
        double o2 = (double)ob2 / (double)(ob1 + ob2);
        double e1 = (double)ex1 / (double)(ex1 + ex2);
        double e2 = (double)ex2 / (double)(ex1 + ex2);
        double chi = Math.pow(o1 - e1, 2.0) / e1 + Math.pow(o2 - e2, 2.0) / e2;
        return chi > chiValueCutoff;
    }

    public boolean chiSquareEvenDf1(int ob1, int ob2, double chiValueCutoff) {
        double o1 = ob1;
        double o2 = ob2;
        double ex = (o1 + o2) / 2.0;
        double chi = Math.pow(o1 - ex, 2.0) / ex + Math.pow(o2 - ex, 2.0) / ex;
        return chi > chiValueCutoff;
    }

    public void readCluster(String infileS, boolean binary) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(infileS), 65536));
            this.cls = new cluster[dis.readInt()];
            int[] temp = new int[3];
            for (int i = 0; i < this.cls.length; ++i) {
                for (int j = 0; j < temp.length; ++j) {
                    temp[j] = dis.readInt();
                }
                this.cls[i] = new cluster(temp[0], temp[1], temp[2], dis.readBoolean());
            }
        }
        catch (Exception e) {
            System.out.println("erroe in reading" + infileS + e.toString());
        }
    }

    public void hapDetail(ReadsByTaxa rbt, String outfileS, float coverRate) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this.cls.length; ++i) {
            String temp;
            if (!this.cls[i].ifSnp || (temp = this.getHapDetail(rbt, i, this.cls[i].queryIndex, this.cls[i].hitIndex, coverRate)) == null) continue;
            al.add(temp);
        }
        String[] hapMap = al.toArray(new String[al.size()]);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("rs\talleles\tchrom\tpos\tstrand\tassembly\tcenter\tprotLSID\tassayLSID\tpanelLSID\tQCcode\t");
            for (int i = 0; i < rbt.getTaxaCount() - 1; ++i) {
                bw.write(rbt.getTaxaNames()[i] + "\t");
            }
            bw.write(rbt.getTaxaNames()[rbt.getTaxaCount() - 1]);
            bw.newLine();
            boolean count = false;
            for (int i = 0; i < hapMap.length; ++i) {
                bw.write(hapMap[i]);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private String getHapDetail(ReadsByTaxa rbt, int ID, int queryIndex, int hitIndex, float coverRate) {
        StringBuilder sb = new StringBuilder();
        sb.append(queryIndex).append("\tA/C\t").append(1).append("\t").append(hitIndex).append("\t+\tNA\tSWGDiv\tGBS\tSWGV1\tSWGPop\tQC+\t");
        int countN = 0;
        int totalA = 0;
        int totalC = 0;
        int hetQuery = 0;
        int hetHit = 0;
        for (int i = 0; i < rbt.taxaNum; ++i) {
            if (rbt.hapDist[queryIndex][i] > 0) {
                totalA += rbt.hapDist[queryIndex][i];
                if (rbt.hapDist[hitIndex][i] > 0) {
                    totalC += rbt.hapDist[hitIndex][i];
                    sb.append(String.valueOf(rbt.hapDist[queryIndex][i])).append("|").append(String.valueOf(rbt.hapDist[hitIndex][i])).append("\t");
                    hetQuery += rbt.hapDist[queryIndex][i];
                    hetHit += rbt.hapDist[hitIndex][i];
                    continue;
                }
                sb.append(String.valueOf(rbt.hapDist[queryIndex][i])).append("|").append("\t");
                continue;
            }
            if (rbt.hapDist[hitIndex][i] > 0) {
                totalC += rbt.hapDist[hitIndex][i];
                sb.append("|");
                sb.append(String.valueOf(rbt.hapDist[hitIndex][i])).append("\t");
                continue;
            }
            sb.append("N").append("\t");
            ++countN;
        }
        if (1.0f - (float)countN / (float)rbt.taxaNum < coverRate) {
            return null;
        }
        sb.append(String.valueOf(hetQuery)).append("\t");
        sb.append(String.valueOf(hetHit)).append("\t");
        sb.append(String.valueOf(totalA)).append("\t");
        sb.append(String.valueOf(totalC));
        return sb.toString();
    }

    public void writeHapMap(ReadsByTaxa rbt, String outfileS, float coverRate) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this.cls.length; ++i) {
            String temp;
            if (!this.cls[i].ifSnp || (temp = this.getHapMapRecord(rbt, i + 1, this.cls[i].queryIndex, this.cls[i].hitIndex, coverRate)) == null) continue;
            al.add(temp);
        }
        String[] hapMap = al.toArray(new String[al.size()]);
        try {
            int i;
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("rs\talleles\tchrom\tpos\tstrand\tassembly\tcenter\tprotLSID\tassayLSID\tpanelLSID\tQCcode\t");
            for (i = 0; i < rbt.getTaxaCount() - 1; ++i) {
                bw.write(rbt.getTaxaNames()[i] + "\t");
            }
            bw.write(rbt.getTaxaNames()[rbt.getTaxaCount() - 1]);
            bw.newLine();
            for (i = 0; i < hapMap.length; ++i) {
                bw.write(hapMap[i]);
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private String getHapMapRecord(ReadsByTaxa rbt, int ID, int queryIndex, int hitIndex, float coverRate) {
        StringBuilder sb = new StringBuilder();
        sb.append(queryIndex).append("|").append(hitIndex).append("\tA/C\t").append(1).append("\t").append(ID).append("\t+\tNA\tSWGDiv\tGBS\tSWGV1\tSWGPop\tQC+\t");
        int countN = 0;
        int totalA = 0;
        int totalC = 0;
        for (int i = 0; i < rbt.taxaNum; ++i) {
            if (rbt.hapDist[queryIndex][i] > 0) {
                totalA += rbt.hapDist[queryIndex][i];
                if (rbt.hapDist[hitIndex][i] > 0) {
                    totalC += rbt.hapDist[hitIndex][i];
                    sb.append("R").append("\t");
                    continue;
                }
                sb.append("A").append("\t");
                continue;
            }
            if (rbt.hapDist[hitIndex][i] > 0) {
                totalC += rbt.hapDist[hitIndex][i];
                sb.append("C").append("\t");
                continue;
            }
            sb.append("N").append("\t");
            ++countN;
        }
        if (1.0f - (float)countN / (float)rbt.taxaNum < coverRate) {
            return null;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void writeCluster(String outfileS, boolean binary) {
        int snpCount = this.getSnpCount();
        if (binary) {
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfileS), 65536));
                dos.writeInt(snpCount);
                for (int i = 0; i < this.cls.length; ++i) {
                    this.cls[i].writeBinary(dos);
                }
                dos.flush();
                dos.close();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        } else {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
                bw.write(Integer.toString(snpCount));
                bw.newLine();
                bw.write("queryIndex\thitIndex\tdiv\tclusterSize");
                bw.newLine();
                for (int i = 0; i < this.cls.length; ++i) {
                    this.cls[i].writeTxt(bw);
                }
                bw.flush();
                bw.close();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    public void writeFastA(ReadsByTaxa rbt, String outFastAS) {
        try {
            int count = 1;
            BufferedWriter bw = new BufferedWriter(new FileWriter(outFastAS), 65536);
            for (int i = 0; i < this.cls.length; ++i) {
                if (!this.cls[i].ifSnp) continue;
                long[] longSeq = new long[]{rbt.haplotype[0][this.cls[i].queryIndex], rbt.haplotype[1][this.cls[i].queryIndex]};
                bw.write(">" + String.valueOf(count));
                bw.newLine();
                bw.write("G" + BaseEncoder.getSequenceFromLong(longSeq));
                bw.newLine();
                longSeq[0] = rbt.haplotype[0][this.cls[i].hitIndex];
                longSeq[1] = rbt.haplotype[1][this.cls[i].hitIndex];
                bw.write(">" + String.valueOf(++count));
                bw.newLine();
                bw.write("G" + BaseEncoder.getSequenceFromLong(longSeq));
                bw.newLine();
                ++count;
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Error occurred while writing" + outFastAS);
        }
    }

    public void prin() {
        for (int i = 0; i < 100; ++i) {
            this.cls[i].screenPri();
        }
        System.out.println(this.cls.length);
    }
}

