/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.FileWriter;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TagGWASMap;
import net.maizegenetics.dna.map.TagGWASMapInfo;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class PanAFilteringTagMapPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanAFilteringTagMapPlugin.class);
    String tagMapFileS = null;
    String anchorFileS = null;
    int distanceCutoff;

    public PanAFilteringTagMapPlugin() {
        super(null, false);
    }

    public PanAFilteringTagMapPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -t  tagMap file\n -a  output file\n -c  distance cutoff\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        TagGWASMap tgm = new TagGWASMap(this.tagMapFileS);
        double logCut = Math.log10(this.distanceCutoff);
        System.out.println("Distance cutoff is " + String.valueOf(this.distanceCutoff) + " bp");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.anchorFileS), 65536);
            bw.write("Tag\tTagLength\tGChr\tGPos\tLog10Distance");
            bw.newLine();
            int cnt = 0;
            for (int i = 0; i < tgm.getTagCount(); ++i) {
                TagGWASMapInfo info = tgm.getTagGWASMapInfo(i);
                if (info.predictedDistance > logCut) continue;
                long[] t = tgm.getTag(i);
                bw.write(BaseEncoder.getSequenceFromLong(t) + "\t" + String.valueOf(tgm.getTagLength(i)) + "\t");
                bw.write(String.valueOf(info.gChr) + "\t" + String.valueOf(info.gPos) + "\t" + String.valueOf(info.predictedDistance));
                bw.newLine();
                if (++cnt % 100000 != 0) continue;
                System.out.println(String.valueOf(cnt + 1) + " anchors are written");
            }
            bw.flush();
            bw.close();
            System.out.println(String.valueOf(cnt) + " (" + String.valueOf((double)cnt / (double)tgm.getTagCount()) + ") anchors are written to " + this.anchorFileS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-t", "--tagMap-file", true);
            this.engine.add("-a", "--anchor-file", true);
            this.engine.add("-c", "--dictance-cutoff", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-t")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.tagMapFileS = this.engine.getString("-t");
        if (!this.engine.getBoolean("-a")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.anchorFileS = this.engine.getString("-a");
        if (!this.engine.getBoolean("-c")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.distanceCutoff = Integer.valueOf(this.engine.getString("-c"));
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

